c
c...HIM Version
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ieopen(mode)
c
c...Open The IEEE Bus
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            mode, err, DEV_IEREOPEN
c
  100 err = DEV_IEREOPEN(mode)
      IF (err.eq.0) THEN
        ie_dayno = '000 '
        ie_clkmode = 0
        ie_hwest = 0
      ENDIF
      dev_ieopen = err
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iereopen(mode)
c
c...ReOpen The IEEE-Interface
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$ASSIGN, SYS$QIOW, SYS$SETEF, p1,
     *            DEV_IESETEVENT, DEV_IEASTENABLE, me_event,
     *            him_event, event
      INTEGER
     *            mode
      BYTE
     *            buf(8)
      DATA
     *            me_event/'00000201'x/, him_event/'00000200'x/
c
c...Decide Who We Are
c
  100 ie_whoami = him
      event = him_event
      IF (mode.eq.0) THEN
        p1 = CinC
      ELSE
        p1 = notCinC
      ENDIF
c
c...Assign Channel
c
      ret = SYS$ASSIGN(
     1                 'IXA0',
     2                 ie_chan,
     3                ,
     4
     *                )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_iereopen = -1
        RETURN
      ENDIF
c
c...Initialize Controller Depending On IE_WHOAMI
c
      ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_INITIALIZE),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(p1),
     8               %VAL(ie_whoami),
     9              ,
     A              ,
     B              ,
     C
     *               )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iereopen = -2
        RETURN
      ENDIF
c
c...Set TimeOut
c
      ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_SETMODE+IO$M_TIMOUT),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(3),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iereopen = -3
        RETURN
      ENDIF
c
c...Allow Control Passing And CinC Service Request Events
c
      ret = DEV_IESETEVENT(event)
      IF (ret.ne.0) THEN
        dev_iereopen = ret
        RETURN
      ENDIF
c
c...Enable ATTN ASTs For CinC
c
      ie_doservice = 0
      IF (mode.eq.0) THEN
        ret = DEV_IEASTENABLE()
        IF (ret.ne.0) THEN
          dev_iereopen = ret
          RETURN
        ENDIF
      ENDIF
c
c...Send UNT and UNL To Reset The Bus For CinC
c
      IF (mode.eq.0) THEN
        buf(1) = UNT
        buf(2) = UNL
        ret = SYS$QIOW(
     1                ,
     2                 %VAL(ie_chan),
     3                 %VAL(IO$_COMMANDS),
     4                 ie_iosb,
     5                ,
     6                ,
     7                 buf,
     8                 %VAL(2),
     9                ,
     A                ,
     B                ,
     C
     *                )
         IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
           dev_iereopen = -6
           RETURN
         ENDIF
       ENDIF
c
c...That Is All
c
      ie_efn = 31
      ret = SYS$SETEF(%VAL(ie_efn))
      ie_iosb(1) = SS$_NORMAL
      dev_iereopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ieclose
c
c...Give Everything Back
c
c	Don't Bother With Error Checking
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, SYS$DASSGN
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_INITIALIZE),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(notCinC),
     8               %VAL(ie_whoami),
     9              ,
     A              ,
     B              ,
     C
     *               )
      ret = SYS$DASSGN(
     1                 %VAL(ie_chan)
     *                )
      ie_doservice = 0
      ie_efn = 0
      ie_chan = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_clkinit(hwest)
c
c...Initialize Clocks
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            v(32), w(32)
      INTEGER
     *            DEV_VAXDAYNO, DEV_VAXCLOCK, DEV_WWVCLOCK, i,
     *            vh, vm, wh, wm, err, hwest, DEV_UTCRACK
      REAL
     *            d, vs, ws
c
 9001 FORMAT (3x, 1x, i2, 1x, i2, 1x, f6.3)
c
c...Get VAX Time And Probe WWV
c
  100 ie_hwest = hwest
      err = DEV_VAXDAYNO()
      err = DEV_VAXCLOCK(v,32)
      DO i=1,3
        err = DEV_WWVCLOCK(w,32)
        IF (err.eq.19) GO TO 120
      ENDDO
c
c...WWV Is Not Responding
c
  110 err = DEV_VAXDAYNO()
      ie_deltat = 0.0
      ie_clkmode = 1
      dev_clkinit = 0
      RETURN
c
c...WWV Is Responding.  Calibrate VAX Just In Case
c
  120 err = DEV_UTCRACK(v, i,vh,vm,vs)
      err = DEV_UTCRACK(w, i,wh,wm,ws)
      i = 3600*(wh-vh) + 60*(wm-vm)
      ie_deltat = i + (ws-vs)
      ie_clkmode = 0
      dev_clkinit = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_vaxdayno
c
c...Get Day Number From VAX System Clock
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            v(32)
      CHARACTER*8
     *            t
      INTEGER
     *            nly(12), yly(12), m, d, y, dn, hh, mm, days, i, n,
     *            err, DEV_VAXCLOCK, DEV_UTCRACK
      REAL
     *            ss
      DATA
     *  nly/0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334/,
     *  yly/0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335/
c
 9001 FORMAT (3x, 1x, i2, 1x, i2, 1x, f6.3)
 9002 FORMAT (i3.3, ' ')
c
c...Get System Month, Day, Year
c
  100 CALL IDATE(m,d,y)
      IF (MOD(y,4).eq.0) THEN
        n = yly(m) + d
        days = 366
      ELSE
        n = nly(m) + d
        days = 365
      ENDIF
c
c...Get System Clock, Etc., To Correct DayNumber For UT
c
      err = DEV_VAXCLOCK(v,32)
      err = DEV_UTCRACK(v, dn,hh,mm,ss)
      hh = hh + ie_hwest
      IF (hh.ge.24) THEN
        hh = hh - 24
        n = n + 1
      ENDIF
      IF (n.gt.days) THEN
        n = n - days
        y = y + 1
      ENDIF
c
c...Update The Field
c
      WRITE (ie_dayno,9002) n
      dev_vaxdayno = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_clkread(buf,n)
c
c...Choose WWV Or VAX Clock
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            buf(*)
      INTEGER
     *            err, DEV_VAXCLOCK, DEV_WWVCLOCK, n, i
c
c...Use WWV Unless It Is Known To Be Dead.  Try A Few Times Just To Be Sure
c
  100 IF (ie_clkmode.eq.0) THEN
        DO i=1,3
          err = DEV_WWVCLOCK(buf,n)
          IF (err.eq.19) GO TO 110
        ENDDO
c
c...WWV Has Died Since Initial TurnOn
c
        ie_clkmode = 1
      ENDIF
      err = DEV_VAXCLOCK(buf,n)
c
c...Exit With Guaranteed Proper Clock Count
c
  110 dev_clkread = err
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_vaxclock(buf,n)
c
c...Get The VAX UT And Put It In The Format Of The WWV Receiver
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            buf(*)
      INTEGER
     *            n, i
      INTEGER*4
     *            ret, SYS$ASCTIM
      CHARACTER*11
     *            t
c
 9001 FORMAT (i2.2)
c
c...Get The System Time And UT.  Day Number Already Points To UT.
c
  100 ret = SYS$ASCTIM(
     1                ,
     2                 t,
     3                ,
     4                 %VAL(1)
     *                )
      i = 10*(ICHAR(t(1:1))-48) + (ICHAR(t(2:2))-48)
      i = i + ie_hwest
      IF (i.ge.24) THEN
        i = i - 24
      ENDIF
      t(1:1) = CHAR(i/10 + 48)
      t(2:2) = CHAR(MOD(i,10) + 48)
c
c...Copy Into Format Of WWV Clock
c
      DO i=1,4
        buf(i) = ICHAR(ie_dayno(i:i))
      ENDDO
      DO i=1,11
        buf(i+4) = ICHAR(t(i:i))
      ENDDO
      buf(16) = '0'
      buf(17) = ' '
      buf(18) = ' '
      buf(19) = ' '
      dev_vaxclock = 19
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_wwvclock(ut,nut)
c
c...Get The UT
c
c	Complete String Is 19 Bytes
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      BYTE
     *            ut(*), buf(32)
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            i, n, nut
c
c...Request For Time Is T<NL>
c
  100 buf(1) = ICHAR('T')
      buf(2) = 10
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(2),
     9              ,
     A              ,
     B               %VAL(MLAx+UT_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_wwvclock = -1
        RETURN
      ENDIF
c
c...Listen For Response -- String Is 19 Characters Or Terminate By <NL>
c
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(19),
     9               %VAL(10),
     A               %VAL(1),
     B               %VAL(MTAx+UT_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_wwvclock = -2
        RETURN
      ENDIF
c
c...Copy Out The String -- Ignore Length Errors Or Low Quality For Now
c
      n = MIN(nut,ie_iosb(2))
      DO i=1,n
        ut(i) = buf(i)
      ENDDO
c
c...Update The DayNumber Field
c
      DO i=1,3
        ie_dayno(i:i) = CHAR(ZEXT(buf(i)))
      ENDDO
      dev_wwvclock = n
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_lstclock(unit,lst,nlst)
c
c...Get The LST From Requested UNIT
c
c	Complete String Is 14 Characters
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      BYTE
     *            lst(*), buf(32)
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            i, n, nlst, unit, lstadd
c
c...Choose Device
c
  100 IF (unit.eq.0) THEN
        lstadd = LSTPRI_ADD
      ELSE
        lstadd = LSTSEC_ADD
      ENDIF
c
c...Request For Time Is T<CR>
c
      buf(1) = ICHAR('T')
      buf(2) = 13
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(2),
     9              ,
     A              ,
     B               %VAL(MLAx+lstadd),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_lstclock = -1
        RETURN
      ENDIF
c
c...Listen For Response -- String Is 15 Characters Or Terminate By <CR>
c
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(14),
     9               %VAL(13),
     A               %VAL(1),
     B               %VAL(MTAx+lstadd),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_lstclock = -2
        RETURN
      ENDIF
c
c...Copy Out The String -- Ignore Length Errors Or Low Quality For Now
c
      n = MIN(nlst,ie_iosb(2))
      DO i=1,n
        lst(i) = buf(i)
      ENDDO
      dev_lstclock = n
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_enc40(enc,n)
c
c...Get The 40-Inch Encoder
c
c	Complete String Is 35 Characters
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      BYTE
     *            enc(*), buf(64), com(4)
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            i, n, nenc
      DATA
     *            com/'G', '0', 13, 10/
c
c...Request
c
  100 ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               com,
     8               %VAL(4),
     9              ,
     A              ,
     B               %VAL(MLAx+ENC40_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_enc40 = -1
        RETURN
      ENDIF
c
c...Listen For Response -- String Is 35 Characters Or Terminate By <NL>
c
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(35),
     9               %VAL(10),
     A               %VAL(1),
     B               %VAL(MTAx+ENC40_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_enc40 = -2
        RETURN
      ENDIF
      IF (ie_iosb(2).ne.35) THEN
        dev_enc40 = -3
        RETURN
      ENDIF
c
c...Copy Out
c
      n = MIN(nenc,ie_iosb(2))
      DO i=1,n
        enc(i) = buf(i)
      ENDDO
      dev_enc40 = n
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_enc61(enc,nenc)
c
c...Get The 61-Inch Telescope Encoder Reading
c
c	Complete String Is 35 Characters
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      BYTE
     *            enc(*), buf(64), com(4)
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            i, n, nenc
      DATA
     *            com/'G', '0', 13, 10/
c
c...Request
c
  100 ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               com,
     8               %VAL(4),
     9              ,
     A              ,
     B               %VAL(MLAx+ENC61_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_enc61 = -1
        RETURN
      ENDIF
c
c...Listen For Response -- String Is 35 Characters Or Terminate By <NL>
c
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(35),
     9               %VAL(10),
     A               %VAL(1),
     B               %VAL(MTAx+ENC61_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_enc61 = -2
        RETURN
      ENDIF
      IF (ie_iosb(2).ne.35) THEN
        dev_enc61 = -3
        RETURN
      ENDIF
c
c...Copy Out
c
      n = MIN(nenc,ie_iosb(2))
      DO i=1,n
        enc(i) = buf(i)
      ENDDO
      dev_enc61 = n
      RETURN
      END
c
c=============================================================================
c
c   IEEE Control Routines
c
      SUBROUTINE  dev_ieackevent
c
c...AST Routine Called To Acknowledge An Event
c
c	Intentionally Stupid -- Requestor will wait for its timeout period
c		before faulting.  Therefore we will not do the serial poll
c		here but later when doing the other processing.
c
      INCLUDE
     *            'devices.inc'
c
  100 ie_doservice = 1
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_utcrack(b, dn,hh,mm,ss)
c
c...FORTRAN Called From C Is Not Happy With Internal Reads.  Bug?
c
      INCLUDE
     *            'devices.inc'
      BYTE
     *            b(*)
      INTEGER
     *            dn, hh, mm, s, ms, c(16), i
      REAL
     *            ss
c
c...Mask Ugly Characters
c
  100 DO i=1,16
        IF ((b(i).ge.48).and.(b(i).le.57)) THEN
          c(i) = b(i) - 48
        ELSE
          c(i) = 0
        ENDIF
      ENDDO
      dn = c( 1)*100 + c( 2)*10 + c( 3)
      hh = c( 5)*10  + c( 6)
      mm = c( 8)*10  + c( 9)
      s  = c(11)*10  + c(12)
      ms = c(14)*100 + c(15)*10 + c(16)
      ss = REAL(s) + 0.001*REAL(ms)
      dev_utcrack = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ieservice
c
c...Request Service
c
c	Done By notCinC To Get Attention Of CinC
c
c	Note That Bit 6 Of SRSB Actually Generates The Request And
c	That All Other Bits Are Available To The User
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW
      BYTE
     *            srsb
      DATA
     *            srsb/'40'x/
c
      ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_SERVICE),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(srsb),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ieservice = -30
      ELSE
        dev_ieservice = 0
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iedoservice
c
c...Perform Service Recognition
c
c	Done By CinC To Recognize notCinC
c
c	Perform Both REC_EVENT And SER_POLL
c
c	RETURN < 0	Error Of Some Kind
c	RETURN == 0	Nobody Wants Us
c	RETURN >0	Address Of Requestor
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW
      BYTE
     *            tlkbuf, bytcnt, response
c
 9001 FORMAT (' Unknown Event Code Received...IOSB(2)=', z8)
c
c...AST Set Flag That Somebody Wanted Service
c
  100 IF (ie_doservice.eq.0) THEN
        dev_iedoservice = 0
        RETURN
      ENDIF
      ie_doservice = 0
c
c...Perform Serial Poll Since We Know Who Called Us
c
      tlkbuf = MTAx+him
      bytcnt = 1
      ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_SER_POLL),
     4               ie_iosb,
     5              ,
     6              ,
     7               tlkbuf,
     8               %VAL(bytcnt),
     9               response,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iedoservice = -41
        RETURN
      ENDIF
c
c...Save The Response And Return The Address
c
      ie_reqarg = response
      dev_iedoservice = him
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ieastenable
c
c...Enable AST
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      EXTERNAL
     *            dev_ieackevent
      INTEGER
     *            ret, SYS$QIOW
c
c...Reset ATTN AST
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_SETMODE+IO$M_ATTNAST),
     4               ie_iosb,
     5              ,
     6              ,
     7               %REF(dev_ieackevent),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ieastenable = -5
      ELSE
        dev_ieastenable = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iesetevent(value)
c
c...Enable Service Events
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW, value
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_SETEVENT),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(value),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iesetevent = -4
      ELSE
        dev_iesetevent = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ierecevent
c
c...Receive Events By Waiting
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_REC_EVENT),
     4               ie_iosb,
     5              ,
     6              ,
     7              ,
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ierecevent = -9
      ELSE
        dev_ierecevent = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iecinctest
c
c...Test If We Are CinC
c
c	RETURN <  0 Means Error
c	RETURN == 0 Means NO
c	RETURN >  0 Means YES
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW, state
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_SENSEMODE),
     4               ie_iosb,
     5              ,
     6              ,
     7              ,
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iecinctest = -7
      ELSE
        state = IAND(ie_iosb(4), 15)
        IF ((state.eq.1).or.(state.eq.2)) THEN
          dev_iecinctest = 1
        ELSEIF (state.eq.3) THEN
          dev_iecinctest = 0
        ELSE
          dev_iecinctest = -8
        ENDIF
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_iemetohim
c
c...Sequencer To Pass Control, Wait, Get Control
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            i, j, DEV_IEDOSERVICE, DEV_IEPASSCNTL, DEV_IECINCTEST,
     *            DEV_IEASTENABLE, DEV_IERECEVENT, DEV_IEAUXOUT, dacr
      DATA
     *            dacr/1/
c
c...Process Service Request To Allow Him To Proceed
c
  100 i = DEV_IEDOSERVICE()
      IF (i.lt.0) THEN
        dev_iemetohim = i
        RETURN
      ENDIF
c
c...Pass CinC Status To Him
c
      i = DEV_IEPASSCNTL()
      IF (i.lt.0) THEN
        dev_iemetohim = i
        RETURN
      ENDIF
c
c...Wait Until He Returns It To Us (Or We TimeOut)
c
      i = DEV_IERECEVENT()
      i = DEV_IEAUXOUT(dacr)
c
c...We Are Now CinC Again (Unless Something Has Gone Wrong)
c
      j = DEV_IEASTENABLE()
      IF (j.ne.0) THEN
        i = j
      ENDIF
c
c...All Done
c
      IF (i.lt.0) THEN
        dev_iemetohim = i
      ELSE
        dev_iemetohim = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_iehimtome
c
c...Sequencer To Get Control, Do Something, And Give Control
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            i, j, DEV_IEPASSCNTL, DEV_IECINCTEST, DEV_IERECEVENT,
     *            dacr, DEV_IEAUXOUT
      DATA
     *            dacr/1/
c
c...Recieve Control As Event
c
  100 i = DEV_IERECEVENT()
      IF (i.lt.0) THEN
        dev_iehimtome = i
        RETURN
      ENDIF
      i = DEV_IEAUXOUT(dacr)
c
c...We Are Now CinC.  Execute User's Program
c
  110 CALL ie_slaveboss
c
c...Give CinC
c
      i = DEV_IEPASSCNTL()
      IF (i.lt.0) THEN
        dev_iehimtome = i
      ELSE
        dev_iehimtome = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_iepasscntl
c
c...Pass Control To The Other Guy
c
c	Including Logic To Recover From Timeout Of PASSCNTL
c
      INCLUDE
     *               'devices.inc'
      INCLUDE
     *               '($SSDEF)'
      INCLUDE
     *               '($IODEF)'
      INTEGER
     *               who, ret, SYS$QIOW, DEV_IEAUXOUT, rlc
      DATA
     *               rlc/'22'o/
c
c...Point To The Other Guy
c
  100 IF (ie_whoami.eq.me) THEN
        who = him
      ELSE
        who = me
      ENDIF
c
c...Use Utility But Anticipate Timeout
c
      ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_PASSCONTROL),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(who+MTAx),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
c
c...Analyze Error Returns
c
      IF (ret.ne.SS$_NORMAL) THEN
        dev_iepasscntl = -60
        RETURN
      ENDIF
      IF (ie_iosb(1).eq.SS$_NORMAL) THEN
        dev_iepasscntl = 0
        RETURN
      ENDIF
      IF (ie_iosb(1).ne.SS$_TIMEOUT) THEN
        dev_iepasscntl = -61
        RETURN
      ENDIF
c
c...We Timed Out.  WorkAround Is To Issue RLC Ourselves
c
      ret = DEV_IEAUXOUT(rlc)
      IF (ret.ne.0) THEN
        dev_iepasscntl = ret
      ELSE
        dev_iepasscntl = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_ieauxout(value)
c
c...Issue An Auxilliary Command
c
      INCLUDE
     *               'devices.inc'
      INCLUDE
     *               '($SSDEF)'
      INCLUDE
     *               '($IODEF)'
      INTEGER
     *               value, ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_AUXILIARY),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(value),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ieauxout = -90
      ELSE
        dev_ieauxout = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_iecmdout(value)
c
c...Issue An IEEE Command
c
      INCLUDE
     *               'devices.inc'
      INCLUDE
     *               '($SSDEF)'
      INCLUDE
     *               '($IODEF)'
      INTEGER
     *               value, ret, SYS$QIOW
c
  100 ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_COMMAND),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(value),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iecmdout = -91
      ELSE
        dev_iecmdout = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_iecstate(value)
c
c...Change CinC Active/Standby State
c
      INCLUDE
     *               'devices.inc'
      INCLUDE
     *               '($SSDEF)'
      INCLUDE
     *               '($IODEF)'
      INTEGER
     *               value, ret, SYS$QIOW, arg
c
  100 IF (value.eq.0) THEN
        arg = IO$_GO_TO_CSBS
      ELSE
        arg = IO$_GO_TO_CACS
      ENDIF
      ret = SYS$QIOW(
     1              ,
     2               %VAL(ie_chan),
     3               %VAL(IO$_AUXILIARY),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(arg),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iecstate = -92
      ELSE
        dev_iecstate = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iewkeith(out,address)
c
c...Write To Keithley 705 or 195
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      CHARACTER*(*)
     *            out
      INTEGER*4
     *            ret, SYS$QIOW, nout, address, i
      BYTE
     *            buf(255)
c
c...Copy The String And Append Terminator
c
  100 nout = LEN(out)
      DO i=1,nout
        buf(i) = ICHAR(out(i:i))
      ENDDO
      buf(nout+1) = 'X'
      buf(nout+2) = 13
      buf(nout+3) = 10
      nout = nout+3
c
c...Transmit With MLAx Prepended
c
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(nout),
     9              ,
     A              ,
     B               %VAL(MLAx+address),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_iewkeith = ret
      ELSE
        dev_iewkeith = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ierkeith(nin,in,address)
c
c...Read (Only) From Keithley 705 or 195
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      CHARACTER*(*)
     *            in
      INTEGER*4
     *            ret, SYS$QIOW, nin, address, i, j
      BYTE
     *            buf(2000)
c
c...Request Read Into Our Buffer -- Use LF As Terminator
c
  100 ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(2000),
     9               %VAL(10),
     A               %VAL(1),
     B               %VAL(MTAx+address),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ierkeith = ret
        RETURN
      ENDIF
c
c...Copy The String And Return
c
      nin = MIN(ie_iosb(2), LEN(in))
      DO i=1,nin
        j = buf(i)
        in(i:i) = CHAR(j)
      ENDDO
      dev_ierkeith = 0
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iebrkeith(nin,in,address)
c
c...Read (Only) From Keithley 705 or 195
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      BYTE
     *            in(*)
      INTEGER*4
     *            ret, SYS$QIOW, nin, address, DEV_SLEEP, DEV_IEWKEITH
c
c...Request Read Into User Buffer -- Use LF As Terminator
c
  100 ret = DEV_SLEEP(0.3)
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               in,
     8               %VAL(3000),
     9               %VAL(10),
     A               %VAL(1),
     B               %VAL(MTAx+address),
     C
     *              )
      IF  ((ret.ne.SS$_NORMAL)
     * .or.(ie_iosb(1).ne.SS$_NORMAL)
     * .or.(ie_iosb(2).ne.1201)) THEN
c
c...Error recovery is to try one more time!
c
        ret = DEV_SLEEP(1.0)
        ret = DEV_IEWKEITH('G3', K195_ADD)
        ret = SYS$QIOW(
     1                 %VAL(ie_efn),
     2                 %VAL(ie_chan),
     3                 %VAL(IO$_READVBLK),
     4                 ie_iosb,
     5                ,
     6                ,
     7                 in,
     8                 %VAL(3000),
     9                 %VAL(10),
     A                 %VAL(1),
     B                 %VAL(MTAx+address),
     C
     *                )
        IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)
     *  .or.(ie_iosb(2).ne.1201)) THEN
c
c...Two Failures -- ????
c
          dev_iebrkeith = ret
          RETURN
        ENDIF
      ENDIF
c
c...All Is OK
c
      nin = ie_iosb(2)
      dev_iebrkeith = 0
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ieremote(mode)
c
c...Remote Enable (REN) Processing Is Not Device Specific
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, mode
      BYTE
     *            no, yes, buf
      DATA
     *            no/'020'o/, yes/'220'o/
c
  100 IF (mode.eq.0) THEN
        buf = no
      ELSE
        buf = yes
      ENDIF
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_AUXILIARY),
     4               ie_iosb,
     5              ,
     6              ,
     7               %VAL(buf),
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ieremote = ret
      ELSE
        dev_ieremote = 0
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_ieserpoll(address,stat)
c
c...Perform A Serial Poll On The Requested Unit
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW, address, stat, ad
c
  100 ad = MTAx + address
      stat = 0
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_SER_POLL),
     4               ie_iosb,
     5              ,
     6              ,
     7               ad,
     8               %VAL(1),
     9               stat,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        dev_ieserpoll = ret
      ELSE
        dev_ieserpoll = 0
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iehpoi(out,nin,in)
c
c...Write The String And Read The Response
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      CHARACTER*(*)
     *            out, in
      INTEGER*4
     *            ret, SYS$QIOW, nin, nout, i
      BYTE
     *            buf(256)
c
c...Copy String Then Write It
c
  100 nout = LEN(out)
      nin = 0
      IF (nout.eq.0) THEN
        dev_iehpoi = 0
        RETURN
      ENDIF
      IF ((nout.lt.0).or.(nout.gt.254)) THEN
        dev_iehpoi = -1
        RETURN
      ENDIF
      DO i=1,nout
        buf(i) = ICHAR(out(i:i))
      ENDDO
      nout = nout+1
      buf(nout) = 10
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(nout),
     9              ,
     A              ,
     B               %VAL(MLAx+LASER_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        IF (ret.ne.SS$_NORMAL) THEN
          in(1:6) = 'W__QIO'
          dev_iehpoi = ret
        ELSE
          in(1:6) = 'W_IOSB'
          dev_iehpoi = ie_iosb(1)
        ENDIF
        RETURN
      ENDIF
c
c...Listen For Response. Terminator is ASCII LF == 10
c
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_READVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(255),
     9               %VAL(10),
     A               %VAL(1),
     B               %VAL(MTAx+LASER_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        IF (ret.ne.SS$_NORMAL) THEN
          in(1:6) = 'R__QIO'
          dev_iehpoi = ret
        ELSE
          in(1:6) = 'R_IOSB'
          dev_iehpoi = ie_iosb(1)
        ENDIF
        RETURN
      ENDIF
c
c...Copy Out The String -- Ignore Length Errors For Now
c
c	Strip CR,LF,NULL
c
      nout = MIN(LEN(in),ie_iosb(2))
      nin = 0
      DO i=1,nout
        IF ((buf(i).ne.10).and.(buf(i).ne.13).and.(buf(i).ne.0)) THEN
          nin = nin+1
          in(nin:nin) = CHAR(ZEXT(buf(i)))
        ENDIF
      ENDDO
      dev_iehpoi = 0
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_iehpo(out)
c
c...Write The String.
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      CHARACTER*(*)
     *            out
      INTEGER*4
     *            ret, SYS$QIOW, nout, i
      BYTE
     *            buf(256)
c
c...Copy String Then Write It
c
  100 nout = LEN(out)
      IF (nout.eq.0) THEN
        dev_iehpo = 0
        RETURN
      ENDIF
      IF ((nout.lt.0).or.(nout.gt.254)) THEN
        dev_iehpo = -1
        RETURN
      ENDIF
      DO i=1,nout
        buf(i) = ICHAR(out(i:i))
      ENDDO
      nout = nout+1
      buf(nout) = 10
      ret = SYS$QIOW(
     1               %VAL(ie_efn),
     2               %VAL(ie_chan),
     3               %VAL(IO$_WRITEVBLK),
     4               ie_iosb,
     5              ,
     6              ,
     7               buf,
     8               %VAL(nout),
     9              ,
     A              ,
     B               %VAL(MLAx+LASER_ADD),
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(ie_iosb(1).ne.SS$_NORMAL)) THEN
        IF (ret.ne.SS$_NORMAL) THEN
          dev_iehpo = ret
        ELSE
          dev_iehpo = ie_iosb(1)
        ENDIF
        RETURN
      ENDIF
      dev_iehpo = 0
      RETURN
      END
