c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_getpriv
c
c...Get Various Privilege
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($PRVDEF)'
      INTEGER*4
     *            mask(2), ret, SYS$SETPRV
c
  100 mask(1) = 0
      mask(2) = 0
      mask(1) = IBSET(mask(1),PRV$V_PFNMAP)
      mask(1) = IBSET(mask(1),PRV$V_LOG_IO)
      mask(1) = IBSET(mask(1),PRV$V_ALTPRI)
      mask(1) = IBSET(mask(1),PRV$V_PSWAPM)
      ret = SYS$SETPRV(
     1                 %VAL(1),
     2                 mask,
     3                 %VAL(1),
     4
     *                )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_getpriv = 0
      ELSE
        dev_getpriv = 1
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_givepriv
c
c...Return Special Privileges
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($PRVDEF)'
      INTEGER*4
     *            mask(2), ret, SYS$SETPRV
c
c...Give Back PFNMAP Privilege
c
  100 mask(1) = 0
      mask(2) = 0
      mask(1) = IBSET(mask(1),PRV$V_PFNMAP)
      mask(1) = IBSET(mask(1),PRV$V_LOG_IO)
      mask(1) = IBSET(mask(1),PRV$V_ALTPRI)
      mask(1) = IBSET(mask(1),PRV$V_PSWAPM)
      ret = SYS$SETPRV(
     1                 %VAL(0),
     2                 mask,
     3                 %VAL(1),
     4
     *                )
      dev_givepriv = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_getprio
c
c...Raise The Process Priority
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$SETPRI
c
  100 ret = SYS$SETPRI(
     1                ,
     2                ,
     3                 %VAL(17),
     4
     *                )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_getprio = 0
      ELSE
        dev_getprio = 1
      ENDIF
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_giveprio
c
c...Lower The Process Priority
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$SETPRI
c
  100 ret = SYS$SETPRI(
     1                ,
     2                ,
     3                 %VAL(6),
     4
     *                )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_giveprio = 0
      ELSE
        dev_giveprio = 1
      ENDIF
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_noast
c
c...Block ASTs From Being Delivered
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$SETAST
c
  100 ret = SYS$SETAST(
     1                 %VAL(0)
     *                )
      dev_noast = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_yesast
c
c...Allow ASTs To Be Delivered
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$SETAST
c
  100 ret = SYS$SETAST(
     1                 %VAL(1)
     *                )
      dev_yesast = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_dotau(seconds,buf)
c
c...Messy VMS Real --> Character --> 64-bit Internal Time
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *             ret, SYS$BINTIM, buf(*)
      CHARACTER*13
     *             c
      REAL
     *             seconds, x
      INTEGER
     *             i, hh, mm, ss, hs
c
 9001 FORMAT ('0 ', i2.2, ':', i2.2, ':', i2.2, '.', i2.2)
c
c...Make Character String Of The Time
c
  100 IF ((seconds.lt.0.01).or.(seconds.ge.86400.0)) THEN
        dev_dotau = -1
        RETURN
      ENDIF
      x = 100.0*seconds
      i = x
      hh = i/360000
      i = i - hh*360000
      mm = i/6000
      i = i - mm*6000
      ss = i/100
      hs = i - ss*100
      WRITE (c,9001,err=110) hh,mm,ss,hs
      ret = SYS$BINTIM(
     1                 c,
     2                 buf
     *                )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_dotau = -2
      ELSE
        dev_dotau = 0
      ENDIF
      RETURN
c
  110 dev_dotau = -3
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_spawn(cmd)
c
c...VMS Specific
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      CHARACTER*(*)
     *            cmd
      INTEGER*4
     *            ret, LIB$SPAWN
c
  100 ret = LIB$SPAWN(cmd,,,,,,,,,)
      IF (ret.eq.SS$_NORMAL) THEN
        dev_spawn = 0
      ELSE
        dev_spawn = ret
      ENDIF
      RETURN
      END
