c
c------------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pwopen(mode)
c
c...Called Once To Initialize Things
c
      INCLUDE
     *         'devices.inc'
      INCLUDE
     *         '($SSDEF)'
      INCLUDE
     *         '($IODEF)'
      INCLUDE
     *         '($SECDEF)'
      INTEGER*4
     *         SYS$CRMPSC, SYS$ASSIGN, SYS$SETEF, SYS$QIOW,
     *         ret, mask(2), npage, nvbn, dummy, DEV_PW40IOCTL,
     *         DEV_PW61IOCTL
      INTEGER
     *         mode
c
c...Initialization Depends On MODE
c
c	MODE == 0	Means Only TrackBall
c	MODE == 1	Means 61-inch Telescope
c	MODE == 2	Means 40-inch Telescope
c
  100 pw_mode = mode
      IF ((mode.lt.0).or.(mode.gt.2)) THEN
        dev_pwopen = -9
        RETURN
      ENDIF
c
c...Allocate Device
c
      ret = SYS$ASSIGN(
     1                 'PWA0:',
     2                 pw_chan,
     3                ,
     4
     *                )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_pwopen = -1
        RETURN
      ENDIF
c
c...Create And Map 22-bit Q-Bus For Mapped IO Register Page
c
      pwc_in(1) = %LOC(pwc_page(1))
      pwc_in(2) = pwc_in(1) + 511
      npage = 1
      nvbn = (dec_cbase + pwc_addr)/512
      ret = SYS$CRMPSC(
     1                 pwc_in,
     2                 pwc_out,
     3                ,
     4                 %VAL(SEC$M_PFNMAP+SEC$M_WRT),
     5                ,
     6                ,
     7                ,
     8                 %VAL(0),
     9                 %VAL(npage),
     A                 %VAL(nvbn),
     B                ,
     C
     *                )
      IF ((ret.ne.SS$_NORMAL).and.(ret.ne.SS$_CREATED)) THEN
        dev_pwopen = -2
        RETURN
      ENDIF
      IF ((pwc_in(1).ne.pwc_out(1))
     *.or.(pwc_in(2).ne.pwc_out(2))) THEN
        STOP 'PWA0 CSRs Are Not Page Aligned'
      ENDIF
      pw_efn = 33
      ret = SYS$SETEF(%VAL(pw_efn))
      pw_iosb(1) = SS$_NORMAL
c
c...Further Processing For 61-Inch
c
      IF (pw_mode.eq.1) THEN
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                ,
     8                 %VAL(3),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pwopen = -3
          RETURN
        ENDIF
        ret = DEV_PW61IOCTL(0,dummy)
c
c...Further Processing For 40-Inch
c
      ELSEIF (pw_mode.eq.2) THEN
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                ,
     8                 %VAL(3),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pwopen = -3
          RETURN
        ENDIF
        ret = DEV_PW40IOCTL(0,dummy)
      ENDIF
c
c..That's All
c
      dev_pwopen = 0
      RETURN
      END
c
c-------------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pwclose
c
c...Give Everything Back
c
c	Don't Bother With Error Checking
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$DASSGN, SYS$DELTVA
      INTEGER
     *            dummy, DEV_PW61IOCTL, DEV_PW40IOCTL
c
  100 IF (pw_mode.eq.1) THEN
        ret = DEV_PW61IOCTL(0,dummy)
      ELSEIF (pw_mode.eq.2) THEN
        ret = DEV_PW40IOCTL(0,dummy)
      ENDIF
      ret = SYS$DELTVA(
     1                 pwc_out
     *                )
      ret = SYS$DASSGN(
     1                 %VAL(pw_chan)
     *                )
      pw_chan = 0
      pw_efn = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pw61ioctl(arg,buf)
c
c	40-Inch Version Of IOCTL
c
c	PARAMETERS Reflect DJ.H -- Do Not Change At Random!!!
c
      INCLUDE
     *             'devices.inc'
      INCLUDE
     *             '($SSDEF)'
      INCLUDE
     *             '($IODEF)'
      PARAMETER
     *             TEL_IDLE    =   0,
     *             TEL_RESET   =  -1,
     *             TEL_STOP    =  -2,
     *             DOME_STOP   =  -3,
     *             FOCUS_STOP  =  -4,
     *             EW_STOP     =  -5,
     *             NS_STOP     =  -6,
     *             TEL_STAT    =  -7,
     *             TEL_METER   =  -8,
     *             DOME_FOCUS  =  -9,
     *             TEL_ABS     = -10,
     *             TEL_CLEAR   = -11,
     *             TEL_DUMP    = -12,
     *             TEL_REL     = -13,
     *             AG_IN       = -14
      PARAMETER
     *             NAG_YB0     = -20,
     *             NAG_NB0     = -21,
     *             NAG_YB1     = -22,
     *             NAG_NB1     = -23,
     *             NAG_YB2     = -24,
     *             NAG_NB2     = -25,
     *             NAG_YB3     = -26,
     *             NAG_NB3     = -27,
     *             NAG_YSH     = -28,
     *             NAG_NSH     = -29,
     *             NAG_YCP     = -30,
     *             NAG_NCP     = -31,
     *             NAG_INP     = -32
      INTEGER
     *             arg, iload, k, buf(*), count, ret, SYS$QIOW,
     *             pwbuf(2), tripcnt, tripid, ii, jj, kk
      INTEGER*2
     *             c, i, j,
     *             E_SLEW, W_SLEW, E_SET, W_SET, E_GUIDE, W_GUIDE,
     *             N_SLEW, S_SLEW, N_SET, S_SET, N_GUIDE, S_GUIDE,
     *             EW_ALL, NS_ALL, EWNS, DOME_LEFT, DOME_RIGHT,
     *             DOME_ALL, FOCUS_IN, FOCUS_OUT, FOCUS_ALL
      INTEGER*2
     *             NAG_B0, NAG_B1, NAG_B2, NAG_B3, NAG_SH, NAG_CP
      EQUIVALENCE
     *             (pwbuf(1),tripcnt),
     *             (pwbuf(2),tripid)
c
c...OneTime LOAD To Cure 16-Bit Problems
c
      IF (iload.eq.0) THEN
        iload = 1
        E_SLEW     = '000001'o
        W_SLEW     = '000002'o
        E_SET      = '000004'o
        W_SET      = '000010'o
        E_GUIDE    = '000020'o
        W_GUIDE    = '000040'o
        N_SLEW     = '000100'o
        S_SLEW     = '000200'o
        N_SET      = '000400'o
        S_SET      = '001000'o
        N_GUIDE    = '002000'o
        S_GUIDE    = '004000'o
        DOME_LEFT  = '010000'o
        DOME_RIGHT = '020000'o
        FOCUS_IN   = '040000'o
        FOCUS_OUT  = '100000'o
        EW_ALL     = E_SLEW+W_SLEW+E_SET+W_SET+E_GUIDE+W_GUIDE
        NS_ALL     = N_SLEW+S_SLEW+N_SET+S_SET+N_GUIDE+S_GUIDE
        EWNS       = EW_ALL+NS_ALL
        DOME_ALL   = DOME_LEFT+DOME_RIGHT
        FOCUS_ALL  = FOCUS_IN+FOCUS_OUT
        NAG_B0     = '000001'o
        NAG_B1     = '000002'o
        NAG_B2     = '000004'o
        NAG_B3     = '000010'o
        NAG_SH     = '000020'o
        NAG_CP     = '000400'o
      ENDIF
c
c...Decode With SWITCH Statement
c
c	First Commands Are Distinct OPCODES
c
c	A,B,C,D Are Defined In PWDRIVER.MAR For TrackBall
c	I,J,K,L Are Defined In PWDRIVER.MAR For Interrupt/Dome
c
  100 IF ((arg.eq.TEL_IDLE).or.(arg.eq.TEL_RESET)) THEN
        pw_ereg = '177777'o
        pw_greg = '177777'o
        pw_mreg = '177777'o
        pw_ecsr = '000400'o
        pw_gcsr = '000400'o
        pw_mcsr = '000400'o
        pw_fcsr = 0
        pw_hcsr = 0
        pw_ncsr = 0
        pw_ocsr = 0
        pw_pcsr = 0
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                 pwbuf,
     8                 %VAL(1),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pw61ioctl = -2
          RETURN
        ENDIF
      ELSEIF (arg.eq.TEL_STOP) THEN
        pw_ereg = IIOR(pw_ereg, EWNS)
      ELSEIF (arg.eq.DOME_STOP) THEN
        pw_ereg = IIOR(pw_ereg, DOME_ALL)
      ELSEIF (arg.eq.FOCUS_STOP) THEN
        pw_ereg = IIOR(pw_ereg, FOCUS_ALL)
      ELSEIF (arg.eq.EW_STOP) THEN
        pw_ereg = IIOR(pw_ereg, EW_ALL)
      ELSEIF (arg.eq.NS_STOP) THEN
        pw_ereg = IIOR(pw_ereg, NS_ALL)
      ELSEIF (arg.eq.TEL_STAT) THEN
        buf( 1) = pw_ereg
        buf( 2) = pw_freg
      ELSEIF (arg.eq.TEL_METER) THEN
        pw_greg = '177577'o
        i = pw_hreg
        pw_greg = '177677'o
        j = pw_hreg
        CALL dev_pw61decode(i,j,buf(1))
        pw_greg = '177737'o
        i = pw_hreg
        pw_greg = '177757'o
        j = pw_hreg
        CALL dev_pw61decode(i,j,buf(2))
        pw_greg = '177767'o
        i = pw_hreg
        pw_greg = '177773'o
        j = pw_hreg
        CALL dev_pw61decode(i,j,buf(3))
        pw_greg = '177775'o
        i = pw_hreg
        pw_greg = '177776'o
        j = pw_hreg
        CALL dev_pw61decode(i,j,buf(4))
        pw_greg = '177777'o
      ELSEIF (arg.eq.DOME_FOCUS) THEN
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                 pwbuf,
     8                 %VAL(1),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pw61ioctl = -3
          RETURN
        ENDIF
        buf( 1) = tripid
        buf( 2) = tripcnt
        buf( 3) = IIAND(pw_ireg,'1777'o)
      ELSEIF (arg.eq.TEL_DUMP) THEN
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                 pwbuf,
     8                 %VAL(1),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pw61ioctl = -4
          RETURN
        ENDIF
        buf( 1) = pw_ereg
        buf( 2) = pw_freg
        buf( 3) = pw_greg
        buf( 4) = pw_hreg
        buf( 5) = pw_areg
        buf( 6) = pw_breg
        buf( 7) = pw_creg
        buf( 8) = pw_dreg
        buf( 9) = pw_ireg
        buf(10) = pw_jreg
        buf(11) = pw_kreg
        buf(12) = pw_lreg
        buf(13) = tripid
        buf(14) = tripcnt
c
c...These Are Requests For New AutoGuider Stuff
c
      ELSEIF (arg.eq.NAG_NB0) THEN
        c = pw_mreg
        pw_mreg = IAND(c,INOT(NAG_B0))
      ELSEIF (arg.eq.NAG_NB1) THEN
        c = pw_mreg
        pw_mreg = IAND(c,INOT(NAG_B1))
      ELSEIF (arg.eq.NAG_NB2) THEN
        c = pw_mreg
        pw_mreg = IAND(c,INOT(NAG_B2))
      ELSEIF (arg.eq.NAG_NB3) THEN
        c = pw_mreg
        pw_mreg = IAND(c,INOT(NAG_B3))
      ELSEIF (arg.eq.NAG_YSH) THEN
        c = pw_mreg
        pw_mreg = IAND(c,INOT(NAG_SH))
      ELSEIF (arg.eq.NAG_YCP) THEN
        c = pw_mreg
        pw_mreg = IAND(c,INOT(NAG_CP))
      ELSEIF (arg.eq.NAG_YB0) THEN
        pw_mreg = IIOR(pw_mreg, NAG_B0)
      ELSEIF (arg.eq.NAG_YB1) THEN
        pw_mreg = IIOR(pw_mreg, NAG_B1)
      ELSEIF (arg.eq.NAG_YB2) THEN
        pw_mreg = IIOR(pw_mreg, NAG_B2)
      ELSEIF (arg.eq.NAG_YB3) THEN
        pw_mreg = IIOR(pw_mreg, NAG_B3)
      ELSEIF (arg.eq.NAG_NSH) THEN
        pw_mreg = IIOR(pw_mreg, NAG_SH)
      ELSEIF (arg.eq.NAG_NCP) THEN
        pw_mreg = IIOR(pw_mreg, NAG_CP)
      ELSEIF (arg.eq.NAG_INP) THEN
        buf(1) = pw_nreg
c
c...These Are Requests For Motion
c
      ELSE
        k = IAND(arg,'177777'o)
        IF (k.ge.32768) THEN
          c = k - 65536
        ELSE
          c = k
        ENDIF
        IF ((c.eq.E_SLEW).or.(c.eq.E_SET).or.(c.eq.E_GUIDE)) THEN
          i = INOT(IIOR(pw_ereg, EW_ALL))
          pw_ereg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.W_SLEW).or.(c.eq.W_SET).or.(c.eq.W_GUIDE)) THEN
          i = INOT(IIOR(pw_ereg, EW_ALL))
          pw_ereg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.N_SLEW).or.(c.eq.N_SET).or.(c.eq.N_GUIDE)) THEN
          i = INOT(IIOR(pw_ereg, NS_ALL))
          pw_ereg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.S_SLEW).or.(c.eq.S_SET).or.(c.eq.S_GUIDE)) THEN
          i = INOT(IIOR(pw_ereg, NS_ALL))
          pw_ereg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.DOME_LEFT).or.(c.eq.DOME_RIGHT)) THEN
          i = INOT(IIOR(pw_ereg, DOME_ALL))
          pw_ereg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.FOCUS_IN).or.(c.eq.FOCUS_OUT)) THEN
          i = INOT(IIOR(pw_ereg, FOCUS_ALL))
          pw_ereg = INOT(IIOR(c,i))
        ELSE
          dev_pw61ioctl = -1
          RETURN
        ENDIF
      ENDIF
      dev_pw61ioctl = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      SUBROUTINE  dev_pw61decode(i,j,k)
c
c...Decode The 61-inch Meter Digits
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *            i, j
      INTEGER
     *            k
c
  100 k =       IIAND(       i     ,'17'o)
     *  +    10*IIAND(IISHFT(i, -4),'17'o)
     *  +   100*IIAND(IISHFT(i, -8),'17'o)
     *  +  1000*IIAND(IISHFT(i,-12),'17'o)
     *  + 10000*IIAND(       j     ,'01'o)
      IF (IIAND(j,2).eq.0) THEN
        k = -k
      ENDIF
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pw40ioctl(arg,buf)
c
c	40-Inch Version Of IOCTL
c
c	Port	Direction	Function			Was
c---------------------------------------------------------------------------
c
c	A	In		Low Clock			(Like T61)
c	B	In		High Clock			(Like T61)
c	C	Out		TB/Clock Selector		(Like T61)
c	D	In		TrackBall Data			(Like T61)
c
c	E	Out		Encoder Select			A
c	F	Out		Telescope Mover			B
c	G	In		AutoGuider Input		N
c	H	Out		AutoGuider Output		M
c
c	I	In		Dome Microswitch Interrupt	I
c	J	In		CCD Temperature			(J)
c	K	In		Dome Azimuth			C
c	L	In		Dome Temperature		D
c
c	M	In		HA Coarse			A
c	N	In		HA Fine				B
c	O	In		DEC Fine			C
c	P	In		DEC Coarse			D
c
c
c	PARAMETERS Reflect DJ.H -- Do Not Change At Random!!!
c
      INCLUDE
     *             'devices.inc'
      INCLUDE
     *             '($SSDEF)'
      INCLUDE
     *             '($IODEF)'
      PARAMETER
     *             TEL_IDLE    =   0,
     *             TEL_RESET   =  -1,
     *             TEL_STOP    =  -2,
     *             DOME_STOP   =  -3,
     *             FOCUS_STOP  =  -4,
     *             EW_STOP     =  -5,
     *             NS_STOP     =  -6,
     *             TEL_STAT    =  -7,
     *             TEL_METER   =  -8,
     *             DOME_FOCUS  =  -9,
     *             TEL_ABS     = -10,
     *             TEL_CLEAR   = -11,
     *             TEL_DUMP    = -12,
     *             TEL_REL     = -13,
     *             AG_IN       = -14
      PARAMETER
     *             NAG_YB0     = -20,
     *             NAG_NB0     = -21,
     *             NAG_YB1     = -22,
     *             NAG_NB1     = -23,
     *             NAG_YB2     = -24,
     *             NAG_NB2     = -25,
     *             NAG_YB3     = -26,
     *             NAG_NB3     = -27,
     *             NAG_YSH     = -28,
     *             NAG_NSH     = -29,
     *             NAG_YCP     = -30,
     *             NAG_NCP     = -31,
     *             NAG_INP     = -32
      INTEGER
     *             arg, iload, k, buf(*), count, ret, SYS$QIOW,
     *             pwbuf(2), tripcnt, tripid, ii, jj, kk
      INTEGER*2
     *             c, i, j,
     *             E_SLEW, W_SLEW, E_SET, W_SET, E_GUIDE, W_GUIDE,
     *             N_SLEW, S_SLEW, N_SET, S_SET, N_GUIDE, S_GUIDE,
     *             EW_ALL, NS_ALL, EWNS, DOME_LEFT, DOME_RIGHT,
     *             DOME_ALL, FOCUS_IN, FOCUS_OUT, FOCUS_ALL
      INTEGER*2
     *             NAG_B0, NAG_B1, NAG_B2, NAG_B3, NAG_SH, NAG_CP
      EQUIVALENCE
     *             (pwbuf(1),tripcnt),
     *             (pwbuf(2),tripid)
c
c...OneTime LOAD To Cure 16-Bit Problems
c
      IF (iload.eq.0) THEN
        iload = 1
        E_SLEW     = '000001'o
        W_SLEW     = '000010'o
        E_SET      = '000002'o
        W_SET      = '000020'o
        E_GUIDE    = '000004'o
        W_GUIDE    = '000040'o
        N_SLEW     = '000100'o
        S_SLEW     = '001000'o
        N_SET      = '000200'o
        S_SET      = '002000'o
        N_GUIDE    = '000400'o
        S_GUIDE    = '004000'o
        DOME_LEFT  = '010000'o
        DOME_RIGHT = '020000'o
        FOCUS_IN   = '040000'o
        FOCUS_OUT  = '100000'o
        EW_ALL     = E_SLEW+W_SLEW+E_SET+W_SET+E_GUIDE+W_GUIDE
        NS_ALL     = N_SLEW+S_SLEW+N_SET+S_SET+N_GUIDE+S_GUIDE
        EWNS       = EW_ALL+NS_ALL
        DOME_ALL   = DOME_LEFT+DOME_RIGHT
        FOCUS_ALL  = FOCUS_IN+FOCUS_OUT
        NAG_B0     = '000001'o
        NAG_B1     = '000002'o
        NAG_B2     = '000004'o
        NAG_B3     = '000010'o
        NAG_SH     = '000020'o
        NAG_CP     = '000400'o
      ENDIF
c
c...Decode With SWITCH Statement
c
c	First Commands Are Distinct OPCODES
c
c	A,B,C,D Are Defined In PWDRIVER.MAR For TrackBall
c	I,J,K,L Are Defined In PWDRIVER.MAR For Interrupt/Dome
c
  100 IF ((arg.eq.TEL_IDLE).or.(arg.eq.TEL_RESET)) THEN
        pw_ereg = '177777'o
        pw_freg = '177777'o
        pw_hreg = '177777'o
        pw_ecsr = '000400'o
        pw_fcsr = '000400'o
        pw_hcsr = '000400'o
        pw_gcsr = 0
        pw_mcsr = 0
        pw_ncsr = 0
        pw_ocsr = 0
        pw_pcsr = 0
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                 pwbuf,
     8                 %VAL(1),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pw40ioctl = -2
          RETURN
        ENDIF
      ELSEIF (arg.eq.TEL_STOP) THEN
        pw_freg = IIOR(pw_freg, EWNS)
      ELSEIF (arg.eq.DOME_STOP) THEN
        pw_freg = IIOR(pw_freg, DOME_ALL)
      ELSEIF (arg.eq.FOCUS_STOP) THEN
        pw_freg = IIOR(pw_freg, FOCUS_ALL)
      ELSEIF (arg.eq.EW_STOP) THEN
        pw_freg = IIOR(pw_freg, EW_ALL)
      ELSEIF (arg.eq.NS_STOP) THEN
        pw_freg = IIOR(pw_freg, NS_ALL)
      ELSEIF (arg.eq.TEL_STAT) THEN
        buf(1) = pw_freg
      ELSEIF (arg.eq.DOME_FOCUS) THEN
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                 pwbuf,
     8                 %VAL(1),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pw40ioctl = -3
          RETURN
        ENDIF
        buf( 1) = tripid
        buf( 2) = tripcnt
        buf( 3) = pw_kreg
      ELSEIF (arg.eq.TEL_DUMP) THEN
        ret = SYS$QIOW(
     1                 %VAL(pw_efn),
     2                 %VAL(pw_chan),
     3                 %VAL(IO$_SETMODE),
     4                 pw_iosb,
     5                ,
     6                ,
     7                 pwbuf,
     8                 %VAL(1),
     9                ,
     A                ,
     B                ,
     C
     *                )
        IF (ret.ne.SS$_NORMAL) THEN
          dev_pw40ioctl = -4
          RETURN
        ENDIF
        buf( 1) = pw_ereg
        buf( 2) = pw_freg
        buf( 3) = pw_kreg
        buf( 4) = pw_lreg
        buf( 5) = pw_ireg
        buf( 6) = pw_jreg
        buf( 7) = 0
        buf( 8) = 0
        buf( 9) = tripcnt
        buf(10) = tripid
      ELSEIF (arg.eq.TEL_METER) THEN
        buf( 1) = pw_jreg
c
c...These Are Requestes For Encoder Reads/Writes
c
      ELSEIF (arg.eq.TEL_ABS) THEN
        pw_ereg = -2
        buf(1) = pw_mreg
        buf(2) = pw_preg
        pw_ereg = -1
      ELSEIF (arg.eq.TEL_CLEAR) THEN
        pw_ereg = -3
        DO ii=1,1000
          vs_dummy = pw_freg
        ENDDO
        pw_ereg = -1
      ELSEIF (arg.eq.TEL_REL) THEN
        ii = pw_mreg
        jj = pw_nreg
        kk = pw_mreg
        CALL dev_pwdjchoose(ii,jj,kk)
        buf( 1) = ii
        buf( 2) = jj
        ii = pw_preg
        jj = pw_oreg
        kk = pw_preg
        CALL dev_pwdjchoose(ii,jj,kk)
        buf( 3) = ii
        buf( 4) = jj
c
c...These Are Requests For New AutoGuider Stuff
c
      ELSEIF (arg.eq.NAG_NB0) THEN
        c = pw_hreg
        pw_hreg = IAND(c,INOT(NAG_B0))
      ELSEIF (arg.eq.NAG_NB1) THEN
        c = pw_hreg
        pw_hreg = IAND(c,INOT(NAG_B1))
      ELSEIF (arg.eq.NAG_NB2) THEN
        c = pw_hreg
        pw_hreg = IAND(c,INOT(NAG_B2))
      ELSEIF (arg.eq.NAG_NB3) THEN
        c = pw_hreg
        pw_hreg = IAND(c,INOT(NAG_B3))
      ELSEIF (arg.eq.NAG_YSH) THEN
        c = pw_hreg
        pw_hreg = IAND(c,INOT(NAG_SH))
      ELSEIF (arg.eq.NAG_YCP) THEN
        c = pw_hreg
        pw_hreg = IAND(c,INOT(NAG_CP))
      ELSEIF (arg.eq.NAG_YB0) THEN
        pw_hreg = IIOR(pw_hreg, NAG_B0)
      ELSEIF (arg.eq.NAG_YB1) THEN
        pw_hreg = IIOR(pw_hreg, NAG_B1)
      ELSEIF (arg.eq.NAG_YB2) THEN
        pw_hreg = IIOR(pw_hreg, NAG_B2)
      ELSEIF (arg.eq.NAG_YB3) THEN
        pw_hreg = IIOR(pw_hreg, NAG_B3)
      ELSEIF (arg.eq.NAG_NSH) THEN
        pw_hreg = IIOR(pw_hreg, NAG_SH)
      ELSEIF (arg.eq.NAG_NCP) THEN
        pw_hreg = IIOR(pw_hreg, NAG_CP)
      ELSEIF (arg.eq.NAG_INP) THEN
        buf(1) = pw_greg
c
c...These Are Requests For Motion
c
      ELSE
        k = IAND(arg,'177777'o)
        IF (k.ge.32768) THEN
          c = k - 65536
        ELSE
          c = k
        ENDIF
        IF ((c.eq.E_SLEW).or.(c.eq.E_SET).or.(c.eq.E_GUIDE)) THEN
          i = INOT(IIOR(pw_freg, EW_ALL))
          pw_freg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.W_SLEW).or.(c.eq.W_SET).or.(c.eq.W_GUIDE)) THEN
          i = INOT(IIOR(pw_freg, EW_ALL))
          pw_freg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.N_SLEW).or.(c.eq.N_SET).or.(c.eq.N_GUIDE)) THEN
          i = INOT(IIOR(pw_freg, NS_ALL))
          pw_freg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.S_SLEW).or.(c.eq.S_SET).or.(c.eq.S_GUIDE)) THEN
          i = INOT(IIOR(pw_freg, NS_ALL))
          pw_freg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.DOME_LEFT).or.(c.eq.DOME_RIGHT)) THEN
          i = INOT(IIOR(pw_freg, DOME_ALL))
          pw_freg = INOT(IIOR(c,i))
        ELSEIF ((c.eq.FOCUS_IN).or.(c.eq.FOCUS_OUT)) THEN
          i = INOT(IIOR(pw_freg, FOCUS_ALL))
          pw_freg = INOT(IIOR(c,i))
        ELSE
          dev_pw40ioctl = -1
          RETURN
        ENDIF
      ENDIF
      dev_pw40ioctl = 0
      RETURN
      END
c
c------------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pwuttb(ut,button,x,y)
c
c...Read UT And TrackBall
c
c	With PC Board, X And Y Increase According To Proper Ball Motion
c
      INCLUDE
     *              'devices.inc'
      INTEGER
     *              ut, button, x, y, longbuf, save
      INTEGER*2
     *              buf(2)
      EQUIVALENCE
     *              (buf(1),longbuf)
c
c...UT Is In AB Registers As A 32-Bit Integer
c
  100 pw_creg = 'F7FF'x
      buf(1) = pw_areg
      buf(2) = pw_breg
      ut = longbuf
c
c...Buttons Are Everywhere But X Is Here
c
      pw_creg = 'FFFC'x
      buf(1) = pw_dreg
      pw_creg = 'FFFD'x
      buf(2) = pw_dreg
      button = IAND(7, ISHFT(buf(1),-13))
      x = 15 - IAND(15,buf(1))
      x = x*256 + (255 - IAND(buf(2),255))
c
c...Here Is Y
c
      pw_creg = '1FF3'x
      buf(1) = pw_dreg
      pw_creg = '1FF7'x
      buf(2) = pw_dreg
      y = 15 - IAND(15,buf(1))
      y = y*256 + (255 - IAND(buf(2),255))
c
c...Restore And Exit
c
      pw_creg = 'FFFF'x
      dev_pwuttb = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pwutopen(uto)
c
c...Read The Open Time Register
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *            i(2)
      INTEGER*4
     *            j, uto
      EQUIVALENCE
     *            (i(1),j)
c
  100 pw_creg = 'FDFF'x
      i(1) = pw_areg
      i(2) = pw_breg
      pw_creg = 'FFFF'x
      uto = j
      dev_pwutopen = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pwutclose(utc)
c
c...Read The Close Time Register
c
      INCLUDE
     *            'devices.inc'
      INTEGER*2
     *            i(2)
      INTEGER*4
     *            j, utc
      EQUIVALENCE
     *            (i(1),j)
c
  100 pw_creg = 'FBFF'x
      i(1) = pw_areg
      i(2) = pw_breg
      pw_creg = 'FFFF'x
      utc = j
      dev_pwutclose = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pwutreset
c
c...Reset The UT Counter
c
c	Dummy write to IOSB to fool optimizer
c
      INCLUDE
     *            'devices.inc'
c
  100 pw_creg = 'FEFF'x
      pw_iosb(1) = pw_creg
      pw_creg = 'FFFF'x
      dev_pwutreset = 0
      RETURN
      END
c
c---------------------------------------------------------------------------
c
      SUBROUTINE  dev_pwdjchoose(i,j,k)
c
c...UnJitter Encoders
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            i, j, k
c
  100 i = IAND(i,'07777'o)
      j = IAND(j,'37777'o)
      k = IAND(k,'07777'o)
      IF (i.eq.k) RETURN
c
c...Big Remainder Returns Smaller Reading
c
      IF (j.gt.8191) THEN
        IF (i.gt.k) i = k
      ELSE
        IF (i.lt.k) i = k
      ENDIF
      RETURN
      END
