      INTEGER FUNCTION dev_pyopen
c
c...Open And Map (Pure Magic Happens Here)
c
      INCLUDE
     *         'devices.inc'
      INCLUDE
     *         '($SSDEF)'
      INCLUDE
     *         '($SECDEF)'
      INTEGER*4
     *         SYS$CRMPSC, SYS$ASSIGN, SYS$QIOW, SYS$SETEF,
     *         ret, mask(2), npage, nvbn, SYS$ALLOC
c
c...Allocate The Device (We Must OWN It To Avoid Disaster)
c
  100 ret = SYS$ALLOC(
     1                'PYA0:',
     2               ,
     3               ,
     4
     *               )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_pyopen = ret
        RETURN
      ENDIF
c
c...Assign Channel
c
      ret = SYS$ASSIGN(
     1                 'PYA0:',
     2                 py_chan,
     3                ,
     4
     *                )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_pyopen = -1
        RETURN
      ENDIF
c
c...Create And Map 22-bit Q-Bus For Mapped Data Arrays
c
      pym_in(1) = %LOC(py_pict(1,1,1))
      pym_in(2) = pym_in(1) + 512*512*2 - 1
      npage = (pym_in(2)+1-pym_in(1))/512
      nvbn = (dec_mbase + pym_addr)/512
      ret = SYS$CRMPSC(
     1                 pym_in,
     2                 pym_out,
     3                ,
     4                 %VAL(SEC$M_PFNMAP+SEC$M_WRT),
     5                ,
     6                ,
     7                ,
     8                 %VAL(0),
     9                 %VAL(npage),
     A                 %VAL(nvbn),
     B                ,
     C
     *                )
      IF ((ret.ne.SS$_NORMAL).and.(ret.ne.SS$_CREATED)) THEN
        dev_pyopen = -2
        RETURN
      ENDIF
      IF ((pym_in(1).ne.pym_out(1))
     * .or.(pym_in(2).ne.pym_out(2))) THEN
        STOP 'PYA0 Memory Is Not Page Aligned'
      ENDIF
c
c...Create And Map 22-bit Q-Bus For Mapped IO Register Page
c
      pyc_in(1) = %LOC(pyc_page(1))
      pyc_in(2) = pyc_in(1) + 511
      npage = 1
      nvbn = (dec_cbase + pyc_addr)/512
      ret = SYS$CRMPSC(
     1                 pyc_in,
     2                 pyc_out,
     3                ,
     4                 %VAL(SEC$M_PFNMAP+SEC$M_WRT),
     5                ,
     6                ,
     7                ,
     8                 %VAL(0),
     9                 %VAL(npage),
     A                 %VAL(nvbn),
     B                ,
     C
     *                )
      IF ((ret.ne.SS$_NORMAL).and.(ret.ne.SS$_CREATED)) THEN
        dev_pyopen = -3
        RETURN
      ENDIF
      IF ((pyc_in(1).ne.pyc_out(1))
     *.or.(pyc_in(2).ne.pyc_out(2))) THEN
        STOP 'PYA0 CSRs Are Not Page Aligned'
      ENDIF
c
c...All Is Ok
c
      py_efn = 34
      ret = SYS$SETEF(%VAL(py_efn))
      py_iosb(1) = SS$_NORMAL
      dev_pyopen = 0
      RETURN
      END
c
c-------------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pyclose
c
c...Give Everything Back
c
c	Don't Bother With Error Checking
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$DASSGN, SYS$DELTVA, SYS$DALLOC
c
c...Give Back Q-Bus Maps
c
  100 CALL py_close
      ret = SYS$DELTVA(
     1                 pym_out
     *                )
      ret = SYS$DELTVA(
     1                 pyc_out
     *                )
      ret = SYS$DASSGN(
     1                 %VAL(py_chan)
     *                )
      ret = SYS$DALLOC(
     1                 'PYA0:',
     2
     *                )
      py_chan = 0
      py_efn = 0
      dev_pyclose = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pyioctl(cmd,buf)
c
c...Interpret The Commands
c
c	WARNING -- PARAMETERS Reflect AUTOGUIDE.H Do Not Change At Random
c
      INCLUDE
     *            'devices.inc'
      PARAMETER
     *            VID_ON     = 1,
     *            VID_OFF    = 2,
     *            VID_NORMAL = 3,
     *            VID_BOX    = 4,
     *            VID_VIDEO  = 5
      INTEGER
     *            cmd, buf(*)
c
  100 IF (cmd.eq.VID_ON) THEN
      ELSEIF (cmd.eq.VID_OFF) THEN
      ELSEIF (cmd.eq.VID_NORMAL) THEN
      ELSEIF (cmd.eq.VID_BOX) THEN
      ELSEIF (cmd.eq.VID_VIDEO) THEN
      ELSE
        dev_pyioctl = -1
        RETURN
      ENDIF
      dev_pyioctl = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_pymbase(addr)
c
c...Return Address Of Image Memory To User
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            addr
c
  100 IF (py_efn.le.0) THEN
        addr = 0
        dev_pymbase = -1
      ELSE
        addr = pym_in(1)
        dev_pymbase = 0
      ENDIF
      RETURN
      END
