      PROGRAM  pygen
c
c...Generate Default PYA0 LUTs
c
      INTEGER*2
     *            buf(512), buf1(256), buf2(256)
      EQUIVALENCE
     *            (buf1(1),buf(1)),
     *            (buf2(1),buf(257))
c
c   (0,1) NORMAL, (2-7) NORMALC LUTs
c
c	INLUT 0		Linear
c	INLUT 1		Inverse Linear
c	INLUT 2/3	Multiply By 1/2
c	INLUT 4/5	Multiplu By 1/3
c	INLUT 6/7	Multiply By 1/5
c
c	OUTLUT 0,2	Linear
c	OUTLUT 1,3	Inverse Linear
c	OUTLUT 4	Multuply By 2
c	OUTLUT 5	Inverse Multiply By 2
c	OUTLUT 6	Multiply By 4
c	OUTLUT 7	Inverse Multiply By 4
c
c	8LUT 0-6	Multiply By 128,64,32,16,8,4,2
c	8LUT 7-12	Multiply By 1
c	8LUT 13		All 255
c	8LUT 14-15	All 0
c
c   WARNING:  NORMALC uses tables (HIGH,LOW) not (LOW,HIGH) !!!
c   WARNING:  Histogram Uses 8LUT 14,15
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='none',
     *      dispose='keep',
     *      form='unformatted',
     *      name='PYGEN.DAT',
     *      recl=128,
     *      recordtype='fixed',
     *      status='new',
     *      unit=9
     *     )
c
c...IN 0
c
      DO i=1,256
        CALL shove(i-1,buf1(i))
      ENDDO
      WRITE (9) buf1
c
c...IN 1
c
      DO i=1,256
        CALL shove(256-i, buf1(i))
      ENDDO
      WRITE (9) buf1
c
c...IN(2,3)
c
      DO i=1,512
        CALL shove((i-1)/2, buf(i))
      ENDDO
      WRITE (9) buf2
      WRITE (9) buf1
c
c...IN(4,5)
c
      DO i=1,512
        CALL shove((i-1)/3, buf(i))
      ENDDO
      WRITE (9) buf2
      WRITE (9) buf1
c
c...IN(6,7)
c
      DO i=1,512
        CALL shove((i-1)/5, buf(i))
      ENDDO
      WRITE (9) buf2
      WRITE (9) buf1
c
c...OUTLUT (0,1)
c
      DO i=1,256
        CALL shove(i-1, buf1(i))
      ENDDO
      WRITE (9) buf1
      DO i=1,256
        CALL shove(i-1, buf1(257-i))
      ENDDO
      WRITE (9) buf1
c
c (2,3)
c
      DO i=1,256
        CALL shove(MIN(i*2,255), buf1(i))
      ENDDO
      WRITE (9) buf1
      DO i=1,256
        CALL shove(MIN(i*2,255), buf1(257-i))
      ENDDO
      WRITE (9) buf1
c
c (4,5)
c
      DO i=1,256
        CALL shove(MIN(i*4,255), buf1(i))
      ENDDO
      WRITE (9) buf1
      DO i=1,256
        CALL shove(MIN(i*4,255), buf1(257-i))
      ENDDO
      WRITE (9) buf1
c
c (6,7)
c
      DO i=1,256
        CALL shove(MIN(i*8,255), buf1(i))
      ENDDO
      WRITE (9) buf1
      DO i=1,256
        CALL shove(MIN(i*8,255), buf1(257-i))
      ENDDO
      WRITE (9) buf1
c
c...8LUTS 0-6
c
      DO j=7,1,-1
        DO i=1,256
          buf1(i) = ISHFT(i-1,j)
        ENDDO
        WRITE (9) buf1
      ENDDO
c
c...8LUTS 7-12
c
      DO i=1,256
        buf1(i) = i-1
      ENDDO
      DO j=8,13
        WRITE (9) buf1
      ENDDO
c
c...8LUT 13
c
      DO i=1,256
        buf1(i) = 255
      ENDDO
      WRITE (9) buf1
c
c...8LUTS 14,15
c
      DO i=1,256
        buf(i) = 0
      ENDDO
      DO j=15,16
        WRITE (9) buf1
      ENDDO
c
      CLOSE (9)
      CALL EXIT
      END
c
c-----------------------------------------------------------------------------
c
      SUBROUTINE  shove(in,out)
c
      INTEGER*4
     *            in, i
      INTEGER*2
     *            out
c
  100 i = MAX(0,MIN(255, in))
      out = i
      RETURN
      END
