      INTEGER FUNCTION  dev_rtsopen
c
c...Open RTS Device
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$TRNLOG, SYS$ASSIGN, SYS$QIOW, SYS$SETEF
      INTEGER
     *            nrts_name, i
      CHARACTER*8
     *            rts_name
c
c...Get The Device And Its Characteristics
c
  100 rts_efn = 0
      ret=SYS$TRNLOG(
     1               'RTS$DEV',
     2               nrts_name,
     3               rts_name,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               rts_name(1:nrts_name),
     2               rts_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_rtsopen = -1
        RETURN
      ENDIF
      ret = SYS$QIOW(
     1               %VAL(0),
     2               %VAL(rts_chan),
     3               %VAL(IO$_SENSEMODE),
     4               rts_iosb,
     5              ,
     6              ,
     7               rts_char,
     8               %VAL(12),
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        dev_rtsopen = -2
        RETURN
      ENDIF
c
c...All Is Well
c
      rts_efn = 47
      ret = SYS$SETEF(%VAL(rts_efn))
      rts_iosb(1) = SS$_NORMAL
      dev_rtsopen = 0
      DO i=1,3
        rts_exit(i) = rts_char(i)
      ENDDO
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_rtsclose
c
c...Return The Device.  Don't Bother Checking For Errors
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($IODEF)'
      INTEGER
     *            ret, SYS$QIOW, SYS$DASSGN
c
c...If We Actually SENSEd the Device, Restore It
c
  100 IF (rts_efn.ne.0) THEN
        ret = SYS$QIOW(
     1                 %VAL(rts_efn),
     2                 %VAL(rts_chan),
     3                 %VAL(IO$_SETMODE),
     4                 rts_iosb,
     5                ,
     6                ,
     7                 rts_exit,
     8                 %VAL(12),
     9                ,
     A                ,
     B                ,
     C
     *               )
      ENDIF
c
c...Normal Exit Stuff
c
      ret = SYS$DASSGN(
     1                 %VAL(rts_chan)
     *                )
      rts_chan = 0
      rts_efn = 0
      CALL EXIT
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_rtstype(mode)
c
c...Enable/Disable TypeAhead
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INCLUDE
     *            '($TTDEF)'
      INTEGER
     *            mode, ret, SYS$QIOW
c
  100 IF (mode.eq.0) THEN
        rts_char(2) = IOR(rts_char(2),TT$M_NOTYPEAHD)
      ELSE
        rts_char(2) = IAND(rts_char(2),INOT(TT$M_NOTYPEAHD))
      ENDIF
      ret = SYS$QIOW(
     1               %VAL(rts_efn),
     2               %VAL(rts_chan),
     3               %VAL(IO$_SETMODE),
     4               rts_iosb,
     5              ,
     6              ,
     7               rts_char,
     8               %VAL(12),
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        IF (ret.ne.SS$_NORMAL) THEN
          dev_rtstype = ret
        ELSE
          dev_rtstype = rts_iosb(1)
        ENDIF
        RETURN
      ENDIF
      dev_rtstype = 0
      RETURN
      END
c
c----------------------------------------------------------------------------
c
      INTEGER FUNCTION  dev_rtsrts(mode)
c
c...Manipulate RTS Modem Line
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INCLUDE
     *            '($TTDEF)'
      INTEGER
     *            mode, ret, SYS$QIOW, i
      BYTE
     *            buf(8)
c
  100 DO i=1,8
        buf(i) = 0
      ENDDO
      IF (mode.eq.0) THEN
        buf(4) = TT$M_DS_RTS + TT$M_DS_DTR
      ELSE
        buf(3) = TT$M_DS_RTS + TT$M_DS_DTR
      ENDIF
      ret = SYS$QIOW(
     1               %VAL(rts_efn),
     2               %VAL(rts_chan),
     3               %VAL(IO$_SETMODE+IO$M_SET_MODEM+IO$M_MAINT),
     4               rts_iosb,
     5              ,
     6              ,
     7               buf,
     8              ,
     9              ,
     A              ,
     B              ,
     C
     *              )
      IF ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        IF (ret.ne.SS$_NORMAL) THEN
          dev_rtsrts = ret
        ELSE
          dev_rtsrts = rts_iosb(1)
        ENDIF
        RETURN
      ENDIF
      dev_rtsrts = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_rtsread(buf, n)
c
c...Read String If There Is Anything
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n, i
      INTEGER*2
     *              temp(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              rts_iosb,
     5             ,
     6             ,
     7              temp,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_rtsread = -1
        RETURN
      ENDIF
      IF (temp(1).le.0) THEN
        dev_rtsread = 0
        RETURN
      ENDIF
c
c...Read Number Of Characters Available Now
c
      ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_READVBLK+IO$M_TIMED),
     4              rts_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(temp(1)),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF  ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        dev_rtsread = -1
        RETURN
      ENDIF
c
c...Add A <CR> Just To Be Sure
c
      rts_iosb(2) = rts_iosb(2) + 1
      buf(rts_iosb(2)) = 13
      buf(rts_iosb(2)+1) = 0
      dev_rtsread = rts_iosb(2)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_rtswrite(buf, n)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n, i
      BYTE
     *              buf(*), dummy
c
c...Flush The TypeAhead Buffer
c
  100 ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_READVBLK+IO$M_PURGE),
     4              rts_iosb,
     5             ,
     6             ,
     7              dummy,
     8              %VAL(0),
     9             ,
     A             ,
     B             ,
     C
     *             )
c
c...Write Our Message
c
      ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              rts_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_rtswrite = -1
        RETURN
      ENDIF
      dev_rtswrite = n
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_rtspmm(buf, n)
c
c...Read String From PMM
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n, i, rtmask(4), rtdesc(2)
      INTEGER*2
     *              temp(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              rts_iosb,
     5             ,
     6             ,
     7              temp,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_rtspmm = -1
        RETURN
      ENDIF
      IF (temp(1).le.0) THEN
        dev_rtspmm = 0
        RETURN
      ENDIF
c
c...Define Appropraite EOB Characters And Read The Line
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00002000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(rts_efn),
     2             %VAL(rts_chan),
     3             %VAL(IO$_READVBLK+IO$M_TIMED),
     4             rts_iosb,
     5            ,
     6            ,
     7             buf,
     8             %VAL(n),
     9             %VAL(2),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        dev_rtspmm = -2
      ELSE
        dev_rtspmm = rts_iosb(2)
      ENDIF
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_rtsano(nout,out,nin,in,mode,timeout)
c
c...Read With Prompt And Terminatior Modification
c
c	Anomatic Needs <CR>
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, rtmask(4), rtdesc(2)
      INTEGER
     *            nout, nin, mode, timeout
      BYTE
     *            out(*), in(*)
c
c...Read Terminator Descriptor Block
c
  100 rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00002000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
c
c...Here to Issue the QIO request
c
      nout = nout+1
      out(nout) = 13
      ret=SYS$QIOW(
     1             %VAL(rts_efn),
     2             %VAL(rts_chan),
     3             %VAL(IO$_TTYREADPALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_PURGE
     x              .or.IO$M_TIMED
     x              .or.IO$M_TRMNOECHO),
     4             rts_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(nin),
     9             %VAL(timeout),
     A             rtdesc,
     B             out,
     C             %VAL(nout)
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        nin = 0
        dev_rtsano = -1
      ELSE
        nin = rts_iosb(2)
        dev_rtsano = 0
      ENDIF
      nout = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_rtsanowo(nout,out)
c
c...Write (Only) String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, nout
      BYTE
     *              out(*)
c
c...Write Our Message After Appending <CR>
c
  100 nout = nout+1
      out(nout) = 13
      ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              rts_iosb,
     5             ,
     6             ,
     7              out,
     8              %VAL(nout),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(rts_iosb(1).ne.SS$_NORMAL)) THEN
        dev_rtsanowo = -1
        RETURN
      ENDIF
      dev_rtsanowo = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_anowrite(n,buf)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n, i
      BYTE
     *              buf(*), dummy
c
c...Flush The TypeAhead Buffer
c
  100 ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_READVBLK+IO$M_PURGE),
     4              rts_iosb,
     5             ,
     6             ,
     7              dummy,
     8              %VAL(0),
     9             ,
     A             ,
     B             ,
     C
     *             )
c
c...Write Our Message
c
      n = n+1
      buf(n) = 13
      ret = SYS$QIOW(
     1              %VAL(rts_efn),
     2              %VAL(rts_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              rts_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_anowrite = -1
        RETURN
      ENDIF
      dev_anowrite = 0
      END
