c
c------------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_timopen
c
c...Kluge For VMS
c
      INCLUDE
     *             'devices.inc'
      INTEGER*4
     *             ret, SYS$SETEF, DEV_LOADTIM1, DEV_KILLTIM1
c
  100 tim_efn0 = 41
      tim_idt0 = 1
      ret = SYS$SETEF(%VAL(tim_efn0))
      tim_efn1 = 42
      tim_idt1 = 2
      ret = SYS$SETEF(%VAL(tim_efn1))
      ret = DEV_LOADTIM1(1.0)
      ret = DEV_KILLTIM1(0)
      slp_efn = 43
      slp_idt = 3
      ret = SYS$SETEF(%VAL(slp_efn))
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_timclose
c
c...Kluge For VMS
c
      INCLUDE
     *             'devices.inc'
c
  100 tim_efn0 = 0
      tim_idt0 = 0
      tim_efn1 = 0
      tim_idt1 = 0
      slp_efn = 0
      slp_idt = 0
      dev_timclose = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_sleep(seconds)
c
c...Sleep For A While
c
      INCLUDE
     *             'devices.inc'
      INCLUDE
     *             '($SSDEF)'
      PARAMETER
     *             sleep_min =  0.02,
     *             sleep_max = 59.99
      INTEGER
     *             ret, SYS$SETIMR, SYS$WAITFR, DEV_DOTAU
      CHARACTER*13
     *             c
      REAL
     *             seconds, x
      INTEGER
     *             i, mm, ss, hs
c
c...VMS Specific Stuff
c
  100 x = MAX(sleep_min,MIN(sleep_max,seconds))
      ret = DEV_DOTAU(x,slp_buf)
      IF (ret.ne.0) THEN
        dev_sleep = -1
        RETURN
      ENDIF
      ret = SYS$SETIMR(
     1                 %VAL(slp_efn),
     2                 slp_buf,
     3                ,
     4                 %VAL(slp_idt)
     *                )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_sleep = -2
        RETURN
      ENDIF
      ret = SYS$WAITFR(
     1                 %VAL(slp_efn)
     *                )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_sleep = 0
      ELSE
        dev_sleep = -3
      ENDIF
      RETURN
c
  110 dev_sleep = -4
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_settim0(mode)
c
c...Set Timer 0
c
c	MODE == 0 Means No AST		(Short Anything)
c	MODE == 1 Means AST		(Long Normal)
c	MODE == 2 Means AST		(Long Quick)
c	MODE == 3 Means AST		(Long First/Next)
c	MODE == 4 Means AST		(Long Last)
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$SETIMR
      INTEGER
     *            mode
      EXTERNAL
     *            ccd_endexp, ccd_endqck, ccd_endnxt, ccd_endlst
c
 9001 FORMAT (' PANIC!  SETTIM0 Called With Illegal Mode=', i10)
c
  100 IF (mode.eq.0) THEN
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn0),
     2                   tim_buf0,
     3                  ,
     4                   %VAL(tim_idt0)
     *                  )
      ELSEIF (mode.eq.1) THEN
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn0),
     2                   tim_buf0,
     3                   %REF(ccd_endexp),
     4                   %VAL(tim_idt0)
     *                  )
      ELSEIF (mode.eq.2) THEN
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn0),
     2                   tim_buf0,
     3                   %REF(ccd_endqck),
     4                   %VAL(tim_idt0)
     *                  )
      ELSEIF (mode.eq.3) THEN
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn0),
     2                   tim_buf0,
     3                   %REF(ccd_endnxt),
     4                   %VAL(tim_idt0)
     *                  )
      ELSEIF (mode.eq.4) THEN
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn0),
     2                   tim_buf0,
     3                   %REF(ccd_endlst),
     4                   %VAL(tim_idt0)
     *                  )
      ELSE
        WRITE (*,9001) mode
        ret = -1
      ENDIF
      IF (ret.ne.SS$_NORMAL) THEN
        dev_settim0 = -1
      ELSE
        dev_settim0 = 0
      ENDIF
      RETURN
      END
c
c-------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_waittim0
c
c...Wait For Timer 0
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER
     *            ret, SYS$WAITFR
c
  100 ret = SYS$WAITFR(
     1                 %VAL(tim_efn0)
     *                )
      IF (ret.eq.SS$_NORMAL) THEN
        dev_waittim0 = 0
      ELSE
        dev_waittim0 = -1
      ENDIF
      RETURN
      END
c
c-------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_stattim0
c
c...Return Status Of Exposure Timer.  0 Means No Exposure In Progress
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$READEF, iflag
c
  100 ret = SYS$READEF(
     1                 %VAL(tim_efn0),
     2                 iflag
     *                )
      IF (ret.eq.SS$_WASCLR) THEN
        dev_stattim0 = 1
      ELSE
        dev_stattim0 = 0
      ENDIF
      RETURN
      END
c
c-------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_cantim0
c
c...Cancel Timer 0
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$CANTIM, SYS$SETEF
c
  100 ret = SYS$CANTIM(
     1                 %VAL(tim_idt0),
     2
     *                )
      ret = SYS$SETEF(
     1                %VAL(tim_efn0)
     *               )
      dev_cantim0 = 0
      RETURN
      END
c
c-----------------------------------------------------------------------
c
      INTEGER FUNCTION dev_tautim0(seconds)
c
c...Set VMS Timer Buffer 0
c
      INCLUDE
     *            'devices.inc'
      REAL
     *            seconds
      INTEGER
     *            DEV_DOTAU
c
  100 dev_tautim0 = DEV_DOTAU(seconds,tim_buf0)
      RETURN
      END
c
c----------------------------------------------------------------------
c
      INTEGER FUNCTION dev_killtim0(mode)
c
c...Set The AST Kill Flag For Timer 0
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            mode
c
  100 tim_kill0 = mode
      dev_killtim0 = 0
      RETURN
      END
c
c------------------------------------------------------------------------
c
      SUBROUTINE  dev_dnast1
c
c...AST That Calls UPDATE
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$SETIMR, DEV_DOTAU
      EXTERNAL
     *            dev_dnast2
c
c...Reestablish AST If Kill Not Set
c
  100 IF (tim_kill1.eq.0) THEN
        CALL ccd_callup
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn1),
     2                   tim_buf1,
     3                   %REF(dev_dnast2),
     4                   %VAL(tim_idt1)
     *                  )
      ENDIF
      RETURN
      END
c
c------------------------------------------------------------------------
c
      SUBROUTINE  dev_dnast2
c
c...AST That Calls UPDATE
c
      INCLUDE
     *            'devices.inc'
      INTEGER*4
     *            ret, SYS$SETIMR, DEV_DOTAU
      EXTERNAL
     *            dev_dnast1
c
c...Reestablish AST If Kill Not Set
c
  100 IF (tim_kill1.eq.0) THEN
        CALL ccd_callup
        ret = SYS$SETIMR(
     1                   %VAL(tim_efn1),
     2                   tim_buf1,
     3                   %REF(dev_dnast1),
     4                   %VAL(tim_idt1)
     *                  )
      ENDIF
      RETURN
      END
c
c-------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_cantim1
c
c...Cancel Timer 1
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INTEGER*4
     *            ret, SYS$CANTIM, SYS$SETEF
c
  100 tim_kill1 = 1
      ret = SYS$CANTIM(
     1                 %VAL(tim_idt1),
     2
     *                )
      ret = SYS$SETEF(
     1                %VAL(tim_efn1)
     *               )
      tim_kill1 = 0
      dev_cantim1 = 0
      RETURN
      END
c
c-----------------------------------------------------------------------
c
      INTEGER FUNCTION dev_loadtim1(t)
c
c...Load VMS Version Of Timer Interval
c
      INCLUDE
     *            'devices.inc'
      REAL
     *            t
      INTEGER
     *            DEV_DOTAU
c
  100 dev_loadtim1 = DEV_DOTAU(t,tim_buf1)
      RETURN
      END
c
c----------------------------------------------------------------------
c
      INTEGER FUNCTION dev_killtim1(mode)
c
c...Set The AST Kill Flag For Timer 1
c
      INCLUDE
     *            'devices.inc'
      INTEGER
     *            mode
c
  100 tim_kill1 = mode
      dev_killtim1 = 0
      RETURN
      END
