c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_uttopen
c
c...Open TT Channel For Timed I/O, Etc.
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      CHARACTER*8
     *           uttname
      INTEGER*4
     *           ret, SYS$TRNLOG, SYS$ASSIGN, SYS$SETEF,
     *           nuttname
c
  100 ret=SYS$TRNLOG(
     1               'UTT$DEV',
     2               nuttname,
     3               uttname,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               uttname(1:nuttname),
     2               utt_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_uttopen = 1
        RETURN
      ENDIF
      utt_efn = 37
      ret = SYS$SETEF(%VAL(utt_efn))
      utt_iosb(1) = SS$_NORMAL
      dev_uttopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_uttclose
c
c...Return TT Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(utt_chan)
     *                )
      utt_chan = 0
      utt_efn = 0
      dev_uttclose = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_uttread(buf, n)
c
c...Read String If There Is Anything
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n
      INTEGER*2
     *              uttbuf(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(utt_efn),
     2              %VAL(utt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              utt_iosb,
     5             ,
     6             ,
     7              uttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_uttread = -1
        RETURN
      ENDIF
      IF (uttbuf(1).le.0) THEN
        dev_uttread = 0
        RETURN
      ENDIF
c
c...Read The Message
c
      ret = SYS$QIOW(
     1              %VAL(utt_efn),
     2              %VAL(utt_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED),
     4              utt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(utt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_uttread = -2
        RETURN
      ENDIF
      buf(utt_iosb(2)+1) = 10
      dev_uttread = utt_iosb(2) + 1
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_uttwrite(buf, n)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n
      BYTE
     *              buf(*)
c
  100 ret = SYS$QIOW(
     1              %VAL(utt_efn),
     2              %VAL(utt_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              utt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_uttwrite = -1
        RETURN
      ENDIF
      dev_uttwrite = n
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_uttrw(nin,in)
c
c...Read Bustle
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            nin
      BYTE
     *            out(3), in(*)
c
c...Bustle Trigger
c
  100 out(1) = '#'
      out(2) = '0'
      out(3) = '0'
      ret=SYS$QIOW(
     1             %VAL(utt_efn),
     2             %VAL(utt_chan),
     3             %VAL(IO$_TTYREADPALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_PURGE
     x              .or.IO$M_TIMED
     x              .or.IO$M_TRMNOECHO),
     4             utt_iosb,
     5            ,
     6            ,
     7             in,
     8             %VAL(nin),
     9             %VAL(4),
     A            ,
     B             out,
     C             %VAL(3)
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(utt_iosb(1).ne.SS$_NORMAL)) THEN
        nin = 0
        dev_uttrw = -1
      ELSE
        nin = utt_iosb(2)
        dev_uttrw = 0
      ENDIF
      RETURN
      END
