c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttopen
c
c...Open XTT Channel For Timed I/O, Etc.
c
      INCLUDE
     *           'devices.inc'
      INCLUDE
     *           '($SSDEF)'
      INCLUDE
     *           '($IODEF)'
      CHARACTER*8
     *           xttname
      INTEGER*4
     *           ret, SYS$TRNLOG, SYS$ASSIGN, SYS$SETEF, SYS$QIOW,
     *           nxttname, i
c
  100 ret=SYS$TRNLOG(
     1               'XTT$DEV',
     2               nxttname,
     3               xttname,
     4              ,
     5              ,
     6
     *              )
      ret=SYS$ASSIGN(
     1               xttname(1:nxttname),
     2               xtt_chan,
     3              ,
     4
     *              )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_xttopen = 1
        RETURN
      ENDIF
c
c...EFN Initialization
c
      xtt_efn = 38
      ret = SYS$SETEF(%VAL(xtt_efn))
      xtt_iosb(1) = SS$_NORMAL
c
c...Flush The TypeAhead Buffer
c
      ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_TTYREADALL+IO$M_TIMED+IO$M_PURGE),
     4              xtt_iosb,
     5             ,
     6             ,
     7              i,
     8              %VAL(0),
     9              %VAL(1),
     A             ,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(xtt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_xttopen = -2
        RETURN
      ENDIF
 9999 open (access='sequential',carriagecontrol='list',dispose='keep',
     * form='formatted',name='talk.sg1',status='unknown',unit=72)
      dev_xttopen = 0
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttclose
c
c...Return XTT Channel
c
      INCLUDE
     *           'devices.inc'
      INTEGER*4
     *           ret, SYS$DASSGN
c
  100 ret = SYS$DASSGN(
     1                 %VAL(xtt_chan)
     *                )
      xtt_chan = 0
      xtt_efn = 0
      dev_xttclose = 0
 9999 close (72)
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttread(buf, n)
c
c...Read String If There Is Anything
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      BYTE
     *              buf(*)
      INTEGER*4
     *              ret, SYS$QIOW, n, rtdesc(2), rtmask(4)
      INTEGER*2
     *              xttbuf(4)
c
c...Sense The Number Of Characters Waiting
c
  100 ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              xtt_iosb,
     5             ,
     6             ,
     7              xttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_xttread = -1
        RETURN
      ENDIF
      IF (xttbuf(1).le.0) THEN
        dev_xttread = 0
        RETURN
      ENDIF
c
c...Read The Message
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000400'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_TTYREADPALL
     *                  +IO$M_TIMED
     *                  +IO$M_NOECHO
     *                  +IO$M_TRMNOECHO),
     4              xtt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9              %VAL(3),
     A              rtdesc,
     B             ,
     C
     *             )
      IF ((ret.ne.SS$_NORMAL).or.(xtt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_xttread = -2
        RETURN
      ENDIF
      buf(xtt_iosb(2)+1) = 10
      dev_xttread = xtt_iosb(2) + 1
      RETURN
      END
c
c-----------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttwrite(buf, n)
c
c...Write String
c
      INCLUDE
     *              'devices.inc'
      INCLUDE
     *              '($SSDEF)'
      INCLUDE
     *              '($IODEF)'
      INTEGER*4
     *              ret, SYS$QIOW, n
      BYTE
     *              buf(*)
c
  100 ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              xtt_iosb,
     5             ,
     6             ,
     7              buf,
     8              %VAL(n),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_xttwrite = -1
        RETURN
      ENDIF
      dev_xttwrite = n
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttsg(nout,out,nin,in,mode,timeout)
c
c...Read With Prompt And Terminatior Modification
c
c	Silicon Graphics Wants <CR>
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW, rtmask(4), rtdesc(2)
      INTEGER
     *            nout, nin, mode, timeout, i, j
      BYTE
     *            out(*), in(*)
c
c...Read Terminator Descriptor Block -- Colon Is Delimiter
c
  100 rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='04000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
c
c...Here to Issue the QIO request
c
      nout = nout+1
      out(nout) = 13
      write (72,9991) nout,(out(i),i=1,nout-1)
 9991 format ('SGXMT   N=', i3, ' >>', 120a1)
      ret=SYS$QIOW(
     1             %VAL(xtt_efn),
     2             %VAL(xtt_chan),
     3             %VAL(IO$_TTYREADPALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_PURGE
     x              .or.IO$M_TIMED
     x              .or.IO$M_TRMNOECHO),
     4             xtt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(nin),
     9             %VAL(timeout),
     A             rtdesc,
     B             out,
     C             %VAL(nout)
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(xtt_iosb(1).ne.SS$_NORMAL)) THEN
        nin = 0
        in(nin+1) = 0
        dev_xttsg = -1
      ELSE
c
c...Strip All Control And Non-Printing Characters, And Terminate For C
c
        nin = 0
        DO i=1,xtt_iosb(2)
          IF ((in(i).gt.32).and.(in(i).lt.127)) THEN
            nin = nin+1
            in(nin) = in(i)
          ENDIF
        ENDDO
        in(nin+1) = 0
        dev_xttsg = 0
      write (72,9992) nin,(in(i),i=1,nin)
 9992 format ('SGRCV   N=', i3, ' >>', 120a1)
      ENDIF
      nout = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttsgread(nin,in)
c
c...Read If Anything Is Present
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER*2
     *            xttbuf(4)
      INTEGER
     *            nin, rtdesc(2), rtmask(4), nmax, i, n
      BYTE
     *            in(*), buf(132)
c
c...Sense The Number Of Characters Waiting
c
  100 nmax = nin
      nin = 0
      in(nin+1) = 0
      ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              xtt_iosb,
     5             ,
     6             ,
     7              xttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_xttsgread = -1
        RETURN
      ENDIF
      n = xttbuf(1)
      IF (n.le.0) THEN
        dev_xttsgread = 0
        RETURN
      ENDIF
c
c...Read Whatever Was There
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(xtt_efn),
     2             %VAL(xtt_chan),
     3             %VAL(IO$_TTYREADALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_TRMNOECHO),
     4             xtt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(n),
     9             %VAL(3),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(xtt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_xttsgread = -2
        RETURN
      ENDIF
c
c...Copy And Strip Useless Junk
c
      DO i=1,xtt_iosb(2)
        IF ((in(i).gt.32).and.(in(i).lt.127)) THEN
          nin = nin+1
          in(nin) = in(i)
        ENDIF
      ENDDO
      in(nin+1) = 0
      write (72,9991) nin,(in(i),i=1,nin)
 9991 format ('SGREAD  N=', i3, ' >>', 120a1)
c
c...Return If Nothing Of Any Interest Or A Colon Was The Final Character
c
      IF (nin.le.0) THEN
        dev_xttsgread = 0
        RETURN
      ENDIF
      IF (in(nin).eq.':') THEN
        dev_xttsgread = 0
        RETURN
      ENDIF
c
c...Read The Rest Of An Iteresting Message
c
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='04000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(xtt_efn),
     2             %VAL(xtt_chan),
     3             %VAL(IO$_TTYREADALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_TRMNOECHO),
     4             xtt_iosb,
     5             ,
     6             ,
     7             buf,
     8             %VAL(132),
     9             %VAL(3),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(xtt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_xttsgread = -2
        RETURN
      ENDIF
c
c...Copy And Strip Useless Junk
c
      DO i=1,xtt_iosb(2)
        IF ((buf(i).gt.32).and.(buf(i).lt.127)) THEN
          nin = nin+1
          in(nin) = buf(i)
        ENDIF
      ENDDO
      in(nin+1) = 0
      write (72,9992) nin,(in(i),i=1,nin)
 9992 format ('SGRMORE N=', i3, ' >>', 120a1)
      dev_xttsgread = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttsgwrite(nout,out)
c
c...Write But Do Not Wait For Reply
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER
     *            nout, i
      BYTE
     *            out(*)
c
c...Silicon Graphics Wants A <CR>
c
  100 nout = nout+1
      out(nout) = 13
      write (72,9991) nout,(out(i),i=1,nout-1)
 9991 format ('SGWRITE N=', i3, ' >>', 120a1)
      ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_WRITEVBLK),
     4              xtt_iosb,
     5             ,
     6             ,
     7              out,
     8              %VAL(nout),
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_xttsgwrite = -1
        RETURN
      ENDIF
      dev_xttsgwrite = 0
      RETURN
      END
c
c--------------------------------------------------------------------------
c
      INTEGER FUNCTION dev_xttlisten(nin,in)
c
c...Read If Anything Is Present
c
      INCLUDE
     *            'devices.inc'
      INCLUDE
     *            '($SSDEF)'
      INCLUDE
     *            '($IODEF)'
      INTEGER*4
     *            ret, SYS$QIOW
      INTEGER*2
     *            xttbuf(4)
      INTEGER
     *            nin, rtdesc(2), rtmask(4), nmax, i, n
      BYTE
     *            in(*), buf(132)
c
c...Sense The Number Of Characters Waiting
c
  100 nmax = nin
      nin = 0
      in(nin+1) = 0
      ret = SYS$QIOW(
     1              %VAL(xtt_efn),
     2              %VAL(xtt_chan),
     3              %VAL(IO$_SENSEMODE+IO$M_TYPEAHDCNT),
     4              xtt_iosb,
     5             ,
     6             ,
     7              xttbuf,
     8             ,
     9             ,
     A             ,
     B             ,
     C
     *             )
      IF (ret.ne.SS$_NORMAL) THEN
        dev_xttlisten = -1
        RETURN
      ENDIF
      n = xttbuf(1)
      IF (n.le.0) THEN
        dev_xttlisten = 0
        RETURN
      ENDIF
c
c...Read One Character
c
      n = 1
      rtdesc(1)=16
      rtdesc(2)=%LOC(rtmask)
      rtmask(1)='00000000'x
      rtmask(2)='00000000'x
      rtmask(3)='00000000'x
      rtmask(4)='00000000'x
      ret=SYS$QIOW(
     1             %VAL(xtt_efn),
     2             %VAL(xtt_chan),
     3             %VAL(IO$_TTYREADALL
     x              .or.IO$M_NOECHO
     x              .or.IO$M_TRMNOECHO),
     4             xtt_iosb,
     5             ,
     6             ,
     7             in,
     8             %VAL(n),
     9             %VAL(3),
     A             rtdesc,
     B            ,
     C
     *            )
      IF ((ret.ne.SS$_NORMAL).or.(xtt_iosb(1).ne.SS$_NORMAL)) THEN
        dev_xttlisten = -2
        RETURN
      ENDIF
c
c...Copy And Strip Useless Junk
c
      DO i=1,xtt_iosb(2)
        IF ((in(i).gt.32).and.(in(i).lt.127)) THEN
          nin = nin+1
          in(nin) = in(i)
        ENDIF
      ENDDO
      write (72,9991) nin,(in(i),i=1,nin)
 9991 format ('LISTEN  N=', i3, ' >>', 120a1)
      in(nin+1) = 0
      dev_xttlisten = 0
      RETURN
      END
