      SUBROUTINE  fitsinit
c
c...Initialize FITS Headers, Etc.
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            ngrabline = 36*NGRABHD
      INTEGER
     *            i, nlb, j
      CHARACTER*64
     *            lb
      CHARACTER*1
     *            q
c
c              0        1         2         3
c              12345678901234567890123456789012
c
 9000 FORMAT (q, a)
 9001 FORMAT ('SIMPLE  =                    T', 50x)
 9002 FORMAT ('BITPIX  =                    8', 50x)
 9003 FORMAT ('NAXIS   =                    2', 50x)
 9004 FORMAT ('NAXIS1  =                 ',i4,  50x)
 9005 FORMAT ('NAXIS2  =                 ',i4,  50x)
 9006 FORMAT ('BZERO   =                  0.0', 50x)
 9007 FORMAT ('BSCALE  =                  1.0', 50x)
 9008 FORMAT ('COMMENT =                 ',i4,  50x)
 9009 FORMAT ('END', 77x)
c
c...Clear Pixels Beyond Image In Last FITS Block
c
  100 DO i=1,NGRABDM
        grabdum(i) = 0
      ENDDO
c
c...Initialize A Full-Length FITS Header
c
      DO i=1,NGRABLINE-1
        WRITE (grabchead(i),9008) i
      ENDDO
      WRITE (grabchead(NGRABLINE),9009)
c
c...Initialize The FITS Header
c
      WRITE (grabchead( 1),9001)
      WRITE (grabchead( 2),9002)
      WRITE (grabchead( 3),9003)
      WRITE (grabchead( 4),9004) NCOLS
      WRITE (grabchead( 5),9005) NROWS
      WRITE (grabchead( 6),9006)
      WRITE (grabchead( 7),9007)
      q = ''''
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name='/etc/sys_id',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=88
     *     )
      READ (88,9000,err=110,end=110) nlb,lb
      CLOSE (88)
      IF (nlb.gt.0) GO TO 120
  110 nlb = 4
      lb(1:nlb) = 'pmm?'
  120 CALL fitsshove('INSTRUME= '//q//lb(1:nlb)//q,grabchead(8))
c
c...Initialize the other FITS headers
c
      CALL fitsbinit
      CALL fitsfinit
      RETURN
      END
