      FUNCTION  fitsop(lb)
c
c...Do Various Tape Operations
c
c	NOTE:  Since 8mm operations are SO SLOW, invoking any FITOP
c		will do an X_RESPOND(1) so that processing can continue,
c		and then do an X_RESPOND(0) when we are ready.
c
      INCLUDE
     *           '../global.inc'
      INTEGER
     *            err, op, fitsop, c_fitsop, buf(10), C_FITSWRITE,
     *            fitsvax
      CHARACTER*(*)
     *            lb
      BYTE
     *            bb(5)
c
  100 CALL x_respond(1)
c
c...Process Requests
c
      IF (fitsdoit.eq.0) THEN
        CALL x_fortwrite('FITS Is Not OPEN')
        fitsop = 1
        RETURN
      ENDIF
      IF (INDEX(lb,'BFM').gt.0) THEN
        err = C_FITSOP(1)
      ELSEIF (INDEX(lb,'REW').gt.0) THEN
        CALL c_fitsstat(buf)
        IF (IAND(buf(1),'0002'x).ne.0) THEN
          CALL x_fortwrite('Tape Already At BOT')
          err = 0
        ELSE
          err = C_FITSOP(2)
        ENDIF
      ELSEIF (INDEX(lb,'UNL').gt.0) THEN
        err = C_FITSOP(3)
        err = C_FITSOP(4)
      ELSEIF (INDEX(lb,'EOF').gt.0) THEN
        err = C_FITSOP(3)
      ELSEIF (INDEX(lb,'WAIT').gt.0) THEN
        CALL fitswait
        err = fitserr
      ELSEIF (INDEX(lb,'BIAS').gt.0) THEN
        bb(1) = 'B'
        bb(2) = 'I'
        bb(3) = 'A'
        bb(4) = 'S'
        bb(5) = 0
        err = C_FITSWRITE(biasbuf,NBIASBT,bb)
        IF (err.eq.0) THEN
          CALL fitswait
          err = fitserr
        ENDIF
      ELSEIF (INDEX(lb,'FLAT').gt.0) THEN
        bb(1) = 'F'
        bb(2) = 'L'
        bb(3) = 'A'
        bb(4) = 'T'
        bb(5) = 0
        err = C_FITSWRITE(flatbuf,NFLATBT,bb)
        IF (err.eq.0) THEN
          CALL fitswait
          err = fitserr
        ENDIF
      ELSEIF (INDEX(lb,'STAT').gt.0) THEN
        CALL c_fitsstat(buf)
        IF (IAND(buf(1),'0001'x).ne.0) THEN
          CALL x_fortwrite('At EOT')
        ENDIF
        IF (IAND(buf(1),'0002'x).ne.0) THEN
          CALL x_fortwrite('At BOT')
        ENDIF
        IF (IAND(buf(1),'0004'x).ne.0) THEN
          CALL x_fortwrite('Write Protected')
        ENDIF
        IF (IAND(buf(1),'0040'x).ne.0) THEN
          CALL x_fortwrite('On Line')
        ENDIF
        IF (IAND(buf(1),'4000'x).ne.0) THEN
          CALL x_fortwrite('End Of Data')
        ENDIF
        IF (IAND(buf(1),'8000'x).ne.0) THEN
          CALL x_fortwrite('At File Mark')
        ENDIF
        err = 0
      ELSE
        err = -1
      ENDIF
      IF (err.eq.0) THEN
        fitsop = 1
      ELSE
        fitsop = err
      ENDIF
      RETURN
      END
