      SUBROUTINE  do3flat(first,last)
c
c...MultiCPU Median Of 3 Grabs
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            np = ncols*nrows
      LOGICAL*1
     *            r1(NP), r2(NP), r3(NP)
      REAL
     *            f(NP), b(NP), d(NP), dn
      INTEGER
     *            first, last, i, dn1, dn2, dn3
      EQUIVALENCE
     *            (r1(1),raw1(1,1)), (r2(1),raw2(1,1)),
     *            (r3(1),raw3(1,1)),
     *            (f(1),flat(1,1)), (b(1),bias(1,1)),
     *            (d(1),data(1,1))
c
c...Processing Depends On FLATMODE
c
  100 IF (flatmode.gt.0) THEN
        DO i=first,last
          dn1 = ZEXT(r1(i))
          dn2 = ZEXT(r2(i))
          dn3 = ZEXT(r3(i))
          IF (dn1.gt.dn2) THEN
            IF (dn3.gt.dn1) THEN
              dn = dn1
            ELSE
              IF (dn3.gt.dn2) THEN
                dn = dn3
              ELSE
                dn = dn2
              ENDIF
            ENDIF
          ELSE
            IF (dn3.gt.dn2) THEN
              dn = dn2
            ELSE
              IF (dn3.gt.dn1) THEN
                dn = dn3
              ELSE
                dn = dn1
              ENDIF
            ENDIF
          ENDIF
          d(i) = dn
        ENDDO
      ELSEIF (flatmode.eq.0) THEN
        DO i=first,last
          dn1 = ZEXT(r1(i))
          dn2 = ZEXT(r2(i))
          dn3 = ZEXT(r3(i))
          IF (dn1.gt.dn2) THEN
            IF (dn3.gt.dn1) THEN
              dn = dn1
            ELSE
              IF (dn3.gt.dn2) THEN
                dn = dn3
              ELSE
                dn = dn2
              ENDIF
            ENDIF
          ELSE
            IF (dn3.gt.dn2) THEN
              dn = dn2
            ELSE
              IF (dn3.gt.dn1) THEN
                dn = dn3
              ELSE
                dn = dn1
              ENDIF
            ENDIF
          ENDIF
          d(i) = 255.0 - f(i)*(dn-b(i))
        ENDDO
      ELSE
        DO i=first,last
          dn1 = ZEXT(r1(i))
          dn2 = ZEXT(r2(i))
          dn3 = ZEXT(r3(i))
          IF (dn1.gt.dn2) THEN
            IF (dn3.gt.dn1) THEN
              dn = dn1
            ELSE
              IF (dn3.gt.dn2) THEN
                dn = dn3
              ELSE
                dn = dn2
              ENDIF
            ENDIF
          ELSE
            IF (dn3.gt.dn2) THEN
              dn = dn2
            ELSE
              IF (dn3.gt.dn1) THEN
                dn = dn3
              ELSE
                dn = dn1
              ENDIF
            ENDIF
          ENDIF
          d(i) = 255.0 - dn
        ENDDO
      ENDIF
      RETURN
      END
