      SUBROUTINE  findperim(iradius,ixline,iyline)
c
c...Perimiter Delimiters for arbitrary radius
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            nmax=8
      INTEGER
     *            ixline(*), iyline(*), iradius, nline
      INTEGER
     *            limit(nmax+1,nmax), nn, nmid, i, j, n
      DATA limit
     1 / 1, 1, 1, 0, 0, 0, 0, 0, 0,
     2   1, 2, 2, 0, 0, 0, 0, 0, 0,
     3   1, 2, 3, 3, 0, 0, 0, 0, 0,
     4   2, 3, 4, 4, 4, 0, 0, 0, 0,
     5   2, 3, 4, 5, 5, 5, 0, 0, 0,
     6   3, 4, 5, 6, 6, 6, 6, 0, 0,
     7   3, 4, 5, 6, 7, 7, 7, 7, 0,
     8   3, 4, 5, 6, 7, 8, 8, 8, 8/
c
c...Reasonably sized images have circular apertures.  Very big stars
c    will be treated in squares because the sky subtraction should not
c    be critical.
c
  100 IF (iradius.le.nmax) THEN
c
c...The Aperture is defined by the LIMIT table
c
        nline = 2*iradius + 1
        nn = nline+1
        nmid = iradius+1
        DO i=1,nmid
          ixline(i) = limit(i,iradius)
          iyline(i) = i - nmid
          ixline(nn-i) = ixline(i)
          iyline(nn-i) = (nn-i) - nmid
        ENDDO
c
c...Here for very big rasters
c
      ELSE
        nline = 2*iradius+1
        nmid = iradius+1
        DO i=1,nline
          ixline(i) = iradius
          iyline(i) = i - nmid
        ENDDO
      ENDIF
      RETURN
      END
