      SUBROUTINE  margdcalc(iter,elemt,alpha,beta,chisq,kill,
     *                      np,px,py,pz,pr)
c
c...Compute ALPHA And BETA Arrays
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            nbfit = 5
      REAL
     *            elemt(NFIT), alpha(NFIT,NFIT), beta(NFIT), chisq,
     *            aa, bb, sg, x0, y0, xx, yy, rr, zr, d,
     *            dv(NFIT), r0, zz, dfdw, px(*), py(*), pz(*), pr(*)
      INTEGER
     *            iter, kill, i, j, k, xc, yc, ir, nn, np
c
c...Copy Elements And Instant Death On Serious Problems
c
  100 x0 = elemt(1)
      y0 = elemt(2)
      bb = elemt(6)
      sg = elemt(3)
      aa = elemt(4)
      r0 = elemt(5)
      IF (aa.le.0.0) THEN
        kill = -20
        RETURN
      ENDIF
      IF (sg.le.0.0) THEN
        kill = -21
        RETURN
      ENDIF
      xc = x0 + 0.5
      IF ((xc.lt.1).or.(xc.gt.NCOLS)) THEN
        kill = -22
        RETURN
      ENDIF
      yc = y0 + 0.5
      IF ((yc.lt.1).or.(yc.gt.NROWS)) THEN
        kill = -23
        RETURN
      ENDIF
c
c...Initialization
c
      DO j=1,NBFIT
        beta(j) = 0.0
        DO k=j,NBFIT
          alpha(j,k) = 0.0
        ENDDO
      ENDDO
      chisq = 0.0
c
c...Loop Over Pixels
c
      nn = 0
      DO i=1,np
        xx = (px(i)-x0)/sg
        yy = (py(i)-y0)/sg
        zz = r0/(sg*sg)
        rr = xx*xx + yy*yy - zz
        ir = FACTOR*rr + 0.5
        IF ((ir.ge.IRMIN).and.(ir.le.IRMAX)) THEN
          nn = nn+1
          d = exparray(ir)
          dfdw = aa*deriv(ir)
          zr = pz(i) - (bb+aa*d)
          chisq = chisq + zr*zr
          pr(i) = zr
          dv(1) = 2.0*xx*dfdw/sg
          dv(2) = 2.0*yy*dfdw/sg
          dv(3) = 2.0*rr*dfdw/sg
          dv(4) = d
          dv(5) = dfdw/(sg*sg)
          DO j=1,NBFIT
           beta(j) = beta(j) + zr*dv(j)
            DO k=j,NBFIT
              alpha(j,k) = alpha(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
        ELSE
          pr(i) = TAG
        ENDIF
      ENDDO
      DO j=1,NBFIT-1
        DO k=j+1,NBFIT
          alpha(k,j) = alpha(j,k)
        ENDDO
      ENDDO
c
c...Sanity Checks
c
      IF (nn.le.NBFIT) THEN
        kill = -24
        RETURN
      ENDIF
      DO j=1,NBFIT
        IF (alpha(j,j).eq.0.0) THEN
          kill = -25
          RETURN
        ENDIF
      ENDDO
c
c...Since Number Of Pixels Is Not Constant, Return Standard Error
c
      chisq = SQRT(chisq/(nn-NBFIT))
      kill = 0
      RETURN
      END
