      SUBROUTINE  procapsky(istar,numap)
c
c...With Radius Defined, Use Precomputed Annuli To Determine Local Sky
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            sigmult = 2.0
      INTEGER
     *            i, i1, i2, ixc, iyc, ntest, nsky, itest, ir,
     *            ix, iy, istar, numap(*)
      REAL
     *            jmin, jmax
      REAL
     *            ssky
c
c...Initialization
c
  100 i1 = listapr(listaps1(numap(7))) + 1
      i2 = listapr(listaps2(numap(7)))
      ntest = MIN((i2+1-i1)/2, 300)
      ixc = xstar(istar) + 0.5
      iyc = ystar(istar) + 0.5
      nsky = 0
      ssky = 0.0
c
c...Limit The Range Of Acceptable Sky Values To Current Sky Value
c	With Sigma Chops Based On SKY Picture
c
      jmin = frsdn(nframe)
      jmax = frsup(nframe)
c
c...Logic Will Avoid Test If Star Is Well Away From Edge
c
      ir = listaps2(numap(7))
      IF  (((ixc-ir).lt.truefc).or.((ixc+ir).gt.truelc)
     * .or.((iyc-ir).lt.truefr).or.((iyc+ir).gt.truelr)) THEN
        itest = 1
      ELSE
        itest = 0
      ENDIF
c
c...Loop In Annulus Accepting Reasonable Pixels
c
      IF (itest.eq.0) THEN
        DO i=i1,i2
          ix = ixc + listapx(i)
          iy = iyc + listapy(i)
          IF ((data(ix,iy).ge.jmin).and.(data(ix,iy).le.jmax)) THEN
            ssky = ssky + data(ix,iy)
            nsky = nsky + 1
          ENDIF
        ENDDO
      ELSE
        DO i=i1,i2
          ix = ixc + listapx(i)
          iy = iyc + listapy(i)
          IF  ((ix.ge.truefc).and.(ix.le.truelc)
     *    .and.(iy.ge.truefr).and.(iy.le.truelr)) THEN
            IF ((data(ix,iy).ge.jmin).and.(data(ix,iy).le.jmax)) THEN
              ssky = ssky + data(ix,iy)
              nsky = nsky + 1
            ENDIF
          ENDIF
        ENDDO
      ENDIF
c
c...Update Sky Value If Enough Pixels Were OK
c
      IF (nsky.ge.ntest) THEN
        sstar(istar) = ssky/REAL(nsky)
      ENDIF
      RETURN
      END
