      SUBROUTINE  procnodup
c
c...Remove Duplicate Entries Before Accurate Photometry And Astrometry
c
      INCLUDE
     *            '../global.inc'
c
c...Parameter RAD Is Search Radius.  Note that FIND and PROCCENT0 Both
c	work with integer coordinates.
c
      PARAMETER
     *            rad = 1.5,
     *            rsqr = rad*rad
      INTEGER
     *            nq, iput, iget, i, i1, i2, low, high
      REAL
     *            xl, yl, ml, dr
c
c...Remove TAGs
c
  100 nq = 0
      iput = frnsfrst(nframe)-1
      DO iget=frnsfrst(nframe),frnslast(nframe)
        IF (xstar(iget).ne.TAG) THEN
          iput = iput+1
          xstar(iput) = xstar(iget)
          ystar(iput) = ystar(iget)
          mstar(iput) = mstar(iget)
          sstar(iput) = sstar(iget)
          nq = nq+1
          sindex(nq) = nq
        ENDIF
      ENDDO
      frnslast(nframe) = iput
      nstar = iput
      IF (nq.le.0) RETURN
c
c...Sort On X And Permute Y,M,S
c
      i1 = frnsfrst(nframe)
      i2 = frnslast(nframe)
      CALL fqsrt(nq, xstar(i1), sindex)
      CALL rpostsort(nq, sindex, ystar(i1), stemp)
      CALL rpostsort(nq, sindex, mstar(i1), stemp)
      CALL rpostsort(nq, sindex, sstar(i1), stemp)
c
c...Remove Fainter Stars Inside Of Detection Radius
c
      low = i1-1
  110 low = low+1
      IF (low.lt.i2) THEN
        IF (xstar(low).eq.TAG) GO TO 110
        xl = xstar(low)
        yl = ystar(low)
        ml = mstar(low)
        high = low
  120   IF (high.lt.i2) THEN
          IF (xstar(high+1).eq.TAG) THEN
            high = high+1
            GO TO 120
          ENDIF
          IF ((xstar(high+1)-xl).le.RAD) THEN
            high = high+1
            GO TO 120
          ENDIF
        ENDIF
c
c...Search Between LOW and HIGH Removing All But The Brightest Entry
c
        IF (high.gt.low) THEN
          DO i=low+1,high
            IF (xstar(i).ne.TAG) THEN
              dr = (xstar(i)-xl)**2 + (ystar(i)-yl)**2
              IF (dr.le.RSQR) THEN
                IF (mstar(i).gt.ml) THEN
                  xstar(low) = TAG
                  ml = mstar(i)
                ELSE
                  xstar(i) = TAG
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF
        GO TO 110
      ENDIF
c
c...Remove TAGs
c
      iput = i1-1
      DO iget=i1,i2
        IF (xstar(iget).ne.TAG) THEN
          iput = iput+1
          xstar(iput) = xstar(iget)
          ystar(iput) = ystar(iget)
          mstar(iput) = mstar(iget)
          sstar(iput) = sstar(iget)
        ENDIF
      ENDDO
      frnslast(nframe) = iput
      nstar = iput
      RETURN
      END
