      IMPLICIT
     *             NONE
c
c...Define Videk Parameters For All Users
c
      PARAMETER
     *             nrows = 1037,
     *             ncols = 1394,
     *             truefc = 67,
     *             truelc = 1378,
     *             truefr = 3,
     *             truelr = 1035,
     *             scale_x0 = 690.0D00,
     *             scale_y0 = 519.0D00
c
c...MAGNIFY Independent Include File
c
      PARAMETER
     *             nbcoef = 6,
     *             nrcommon = 100,
     *             nicommon = 100,
     *             nfrmax = 5000,
     *             tapesize = 84*2880,
     *             numhuge = 216,
     *             tag = -90909.0,
     *             nints = ((ncols*nrows-1)/4)+1,
     *             nbigbuf = 13,
     *             nstmax = ((numhuge*tapesize-2880)/(4*nbigbuf))
      PARAMETER
     *             nsubx = 6,
     *             nsuby = 7,
     *             naplim = 64,
     *             napmax = 13085,
     *             nfit = 6
      PARAMETER
     *             nfringe=6,
     *             big_size = nfringe,
     *             big_dim  = 2*big_size+1,
     *             mastercpu = 1,
     *             box_max = (13*13),
     *             pix_max = (4*4),
     *             plmax = (box_max*pix_max)
c
c...What Remains Of ASTROMETRY.INC
c
      PARAMETER
     *             factor = 1000.0,
     *             irmin = -4600,
     *             irmax =  9200,
     *             sgmax = 2.0,
     *             sgmax2 = sgmax*sgmax,
     *             nplimit = 4000,
     *             nafit = 6
c
c...What Remains Of FITS.INC
c
c	Support for 2 kinds of FITS files.
c
c		REAL*4 for BIAS and FLAT
c		LOGICAL*1 for Single Grab
c
c	(1037*1394*1)/2880 =  502
c	(1037*1394*4)/2880 = 2008
c
c	Add 2 blocks (=72 lines) header for data pix
c	Add 8 blocks             header for bias,flat pix
c	Equals 6 I/O requests for data, 24 for bias/flat pix
c
      PARAMETER
     *         ngrabim = (  NCOLS*NROWS),
     *         ngrabhd = 2,
     *         ngrabhb = (2880*ngrabhd),
     *         ngrabbk = (((ngrabim-1)/2880) + 1 + ngrabhd),
     *         ngrabbt = (2880*ngrabbk),
     *         ngrabdm = (ngrabbt - (ngrabim+ngrabhb))
      PARAMETER
     *         nbiasim = (4*NCOLS*NROWS),
     *         nbiashd = 8,
     *         nbiashb = (2880*nbiashd),
     *         nbiasbk = (((nbiasim-1)/2880) + 1 + nbiashd),
     *         nbiasbt = (2880*nbiasbk),
     *         nbiasdm = (nbiasbt - (nbiasim+nbiashb))
      PARAMETER
     *         nflatim = (4*NCOLS*NROWS),
     *         nflathd = 8,
     *         nflathb = (2880*nflathd),
     *         nflatbk = (((nflatim-1)/2880) + 1 + nflathd),
     *         nflatbt = (2880*nflatbk),
     *         nflatdm = (nflatbt - (nflatim+nflathb))
c
c...Bits That Control IALTERNATE Processing
c
      PARAMETER
     *         no_moment      = '00000001'x,
     *         constant_mag   = '00000004'x,
     *         count_sat      = '00000008'x,
     *         std_astrometry = '00000010'x,
     *         second_iter    = '00000040'x,
     *         x_astrometry   = '00000080'x,
     *         x_photometry   = '00000100'x,
     *         kill_normal    = '00000200'x,
     *         find_huge      = '00000400'x,
     *         find_saturate  = '00000800'x,
     *         save_resids    = '00001000'x
c
c...The Data Arrive As Unsigned BYTES
c
      INTEGER
     *             raw(nints,7)
      LOGICAL*1
     *             raw1(ncols,nrows), raw2(ncols,nrows),
     *             raw3(ncols,nrows), raw4(ncols,nrows),
     *             raw5(ncols,nrows), raw6(ncols,nrows),
     *             raw7(ncols,nrows), raw8(ncols,nrows)
      BYTE
     *             grabbuf(2880,NGRABBK), grabhdr(2880,NGRABHD),
     *             biasbuf(2880,NBIASBK), biashdr(2880,NBIASHD),
     *             flatbuf(2880,NFLATBK), flathdr(2880,NFLATHD),
     *             grabdum(NGRABDM),
     *             biasdum(NBIASDM),
     *             flatdum(NFLATDM)
c
c...BYTE Declarations Needed To Mage Data Storage Into A FITS File
c
      BYTE
     *             hugebuf(numhuge*tapesize),
     *             bighead(2880)
c
c...Default INTEGER Declarations
c
      INTEGER
     *             wholehist(0:255),
     *             frdn1(nfrmax),
     *             frdn2(nfrmax),
     *             frsdn(nfrmax),
     *             frsup(nfrmax),
     *             frnsfrst(nfrmax),
     *             frnslast(nfrmax),
     *             frfmode(nfrmax),
     *             sindex(nstmax),
     *             listapr(napmax),
     *             listapx(napmax),
     *             listapy(napmax),
     *             listaps1(napmax),
     *             listaps2(napmax)
      INTEGER
     *             bapply,
     *             nframe,
     *             nstar,
     *             findmode,
     *             richthr,
     *             richnbad,
     *             richmndn,
     *             richsky,
     *             ialternate,
     *             tidycall,
     *             quiet,
     *             magmode,
     *             cenminap,
     *             asvar,
     *             dumpmode
      INTEGER
     *             parwide,
     *             parsat,
     *             parmagnify,
     *             flatmode,
     *             ncoef,
     *             nomexp,
     *             ndzcoef,
     *             ndzxy,
     *             dzdoit,
     *             exptick,
     *             ndprefix,
     *             nplateid,
     *             scdoit,
     *             magdoit,
     *             nblob,
     *             icommon(nicommon)
      INTEGER
     *             masterstat,
     *             slavestat,
     *             cpuhandle,
     *             cpulock,
     *             nordxc,
     *             grabnorm,
     *             dxbig(big_dim),
     *             dybig(big_dim),
     *             frflag(nfrmax),
     *             e_min, e_max,
     *             napodize, toobig, toastflag, barpos, holder,
     *             noisy, frexp(nfrmax), toastfract,
     *             fitsover, fitsfd, fitserr, fitsdoit
      INTEGER
     *             bigbuf(nstmax,nbigbuf),
     *             partmp(nstmax,5),
     *             iast(nstmax),
     *             ibst(nstmax),
     *             icst(nstmax),
     *             idst(nstmax),
     *             iest(nstmax),
     *             imst(nstmax),
     *             isst(nstmax),
     *             itst(nstmax),
     *             ixst(nstmax),
     *             iyst(nstmax),
     *             ia1st(nstmax),
     *             ie1st(nstmax),
     *             it1st(nstmax)
c
c...Default REAL Declarations
c
      REAL
     *             bias(ncols,nrows),
     *             flat(ncols,nrows),
     *             data(ncols,nrows),
     *             resid(ncols,nrows),
     *             bcoef(nbcoef),
     *             frpreww(nfrmax),
     *             frprewp(nfrmax)
      REAL
     *             astar(nstmax),
     *             bstar(nstmax),
     *             cstar(nstmax),
     *             dstar(nstmax),
     *             estar(nstmax),
     *             mstar(nstmax),
     *             sstar(nstmax),
     *             tstar(nstmax),
     *             xstar(nstmax),
     *             ystar(nstmax),
     *             stemp(nstmax),
     *             a1star(nstmax),
     *             e1star(nstmax),
     *             t1star(nstmax)
      REAL
     *             wholewp,
     *             wholeww,
     *             tidysize,
     *             unitsig,
     *             parsigma,
     *             rcommon(nrcommon)
      REAL
     *             exparray(IRMIN:IRMAX),
     *             deriv(IRMIN:IRMAX),
     *             nomgrab,
     *             nomsky,
     *             magoffset,
     *             magslope,
     *             cmag1,
     *             cmag2,
     *             cmagexp
      REAL
     *             xrefscale, llcx, llcy,
     *             zetadot, zetaref, zetacur,
     *             plepoch,
     *             plexpose,
     *             sig_mult,
     *             dn_low, dn_high, dn_targ,
     *             fitstime
c
c...Double Precision Coefficients
c
      DOUBLE PRECISION
     *             xcoef(10), ycoef(10),
     *             dzxcoef(10,10), dzycoef(10,10),
     *             frx0(nfrmax), fry0(nfrmax), frz0(nfrmax),
     *             fra0(nfrmax), frt0(nfrmax), frl0(nfrmax),
     *             frc0(nfrmax), frd0(nfrmax), lasertick(2)
c
c...Character Variables
c
      CHARACTER*80
     *             grabchead(36*NGRABHD),
     *             biaschead(36*NBIASHD),
     *             flatchead(36*NFLATHD)
      CHARACTER*64
     *             dprefix, plateid
      CHARACTER*15
     *             plnow
      CHARACTER*14
     *             pltime
      CHARACTER*9
     *             plra
      CHARACTER*8
     *             pldec
      CHARACTER*6
     *             pltape
      CHARACTER*1
     *             whoami, plsurvey, plemulsion
c
c...COMMON Block Is Just Global Variable List
c
      COMMON /lockblock/
     *             xcoef, ycoef, dzxcoef, dzycoef, frx0, fry0,
     *             frz0, fra0, frt0, frl0, frc0, frd0, lasertick,
     *             raw, data, grabbuf, biasbuf, flatbuf, resid,
     *             wholehist, bcoef, frpreww, frprewp, frdn1, frdn2,
     *             frsdn, frsup, exparray, deriv,
     *             frnsfrst, frnslast, frfmode,
     *             dxbig, dybig, rcommon,
     *             hugebuf, partmp, icommon, frflag, frexp,
     *             listapr, listapx, listapy, listaps1, listaps2,
     *             plateid, dprefix, whoami, plsurvey, plemulsion,
     *             pltime, plra, pldec, plnow, pltape,
     *             grabchead, biaschead, flatchead
c
c...This Equivalence Needed To Align BYTE Images For DMA
c
      EQUIVALENCE
     *             (raw(1,1),raw2(1,1)),
     *             (raw(1,2),raw3(1,1)),
     *             (raw(1,3),raw4(1,1)),
     *             (raw(1,4),raw5(1,1)),
     *             (raw(1,5),raw6(1,1)),
     *             (raw(1,6),raw7(1,1)),
     *             (raw(1,7),raw8(1,1))
c
c...Equivalences For FITS Images
c
      EQUIVALENCE
     *             (hugebuf(1),bighead(1)),
     *             (hugebuf(2881),bigbuf(1,1)),
     *             (bigbuf(1, 1), astar(1), iast(1)),
     *             (bigbuf(1, 2), bstar(1), ibst(1)),
     *             (bigbuf(1, 3), cstar(1), icst(1)),
     *             (bigbuf(1, 4), dstar(1), idst(1)),
     *             (bigbuf(1, 5), estar(1), iest(1)),
     *             (bigbuf(1, 6), mstar(1), imst(1)),
     *             (bigbuf(1, 7), sstar(1), isst(1)),
     *             (bigbuf(1, 8), tstar(1), itst(1)),
     *             (bigbuf(1, 9), xstar(1), ixst(1)),
     *             (bigbuf(1,10), ystar(1), iyst(1)),
     *             (bigbuf(1,11),a1star(1),ia1st(1)),
     *             (bigbuf(1,12),e1star(1),ie1st(1)),
     *             (bigbuf(1,13),t1star(1),it1st(1))
      EQUIVALENCE
     *             (grabbuf(1,        1), grabhdr(1,1)),
     *             (grabbuf(1,NGRABHD+1), raw1(1,1)),
     *             (grabbuf(2880,NGRABBK), grabdum(NGRABDM)),
     *             (biasbuf(1,        1), biashdr(1,1)),
     *             (biasbuf(1,NBIASHD+1), bias(1,1)),
     *             (biasbuf(2880,NBIASBK), biasdum(NBIASDM)),
     *             (flatbuf(1,        1), flathdr(1,1)),
     *             (flatbuf(1,NFLATHD+1), flat(1,1)),
     *             (flatbuf(2880,NFLATBK), flatdum(NFLATDM))
c
c...Other Equivalences
c
      EQUIVALENCE
     *             (partmp(1,1), stemp(1)),
     *             (partmp(1,5), sindex(1))
      EQUIVALENCE
     *             (icommon( 1), bapply),
     *             (icommon( 2), nframe),
     *             (icommon( 3), nstar),
     *             (icommon( 4), findmode),
     *             (icommon( 5), richthr),
     *             (icommon( 6), richnbad),
     *             (icommon( 7), richmndn),
     *             (icommon( 8), richsky),
     *             (icommon( 9), ialternate),
     *             (icommon(10), tidycall)
      EQUIVALENCE
     *             (icommon(11), quiet),
     *             (icommon(12), magmode),
     *             (icommon(13), cenminap),
     *             (icommon(14), asvar),
     *             (icommon(15), masterstat),
     *             (icommon(16), slavestat),
     *             (icommon(17), cpuhandle),
     *             (icommon(18), cpulock),
     *             (icommon(19), nordxc),
     *             (icommon(20), grabnorm)
      EQUIVALENCE
     *             (icommon(21), parwide),
     *             (icommon(22), parsat),
     *             (icommon(23), parmagnify),
     *             (icommon(24), flatmode),
     *             (icommon(25), ncoef),
     *             (icommon(26), nomexp),
     *             (icommon(27), ndzcoef),
     *             (icommon(28), toastflag),
     *             (icommon(29), noisy),
     *             (icommon(30), toastfract)
      EQUIVALENCE
     *             (icommon(32), ndzxy),
     *             (icommon(33), exptick),
     *             (icommon(34), ndprefix),
     *             (icommon(35), nplateid),
     *             (icommon(36), dzdoit),
     *             (icommon(37), scdoit),
     *             (icommon(38), magdoit),
     *             (icommon(39), dumpmode),
     *             (icommon(40), nblob)
      EQUIVALENCE
     *             (icommon(41), e_min),
     *             (icommon(42), e_max),
     *             (icommon(43), toobig),
     *             (icommon(44), napodize),
     *             (icommon(45), barpos),
     *             (icommon(46), holder),
     *             (icommon(47), fitsover),
     *             (icommon(48), fitsfd),
     *             (icommon(49), fitserr),
     *             (icommon(50), fitsdoit)
      EQUIVALENCE
     *             (rcommon( 1), wholewp),
     *             (rcommon( 2), wholeww),
     *             (rcommon( 3), tidysize),
     *             (rcommon( 4), unitsig),
     *             (rcommon( 5), parsigma),
     *             (rcommon( 8), nomgrab),
     *             (rcommon( 9), nomsky),
     *             (rcommon(10), fitstime),
     *             (rcommon(11), magoffset),
     *             (rcommon(12), magslope),
     *             (rcommon(13), cmag1),
     *             (rcommon(14), cmag2),
     *             (rcommon(15), cmagexp)
      EQUIVALENCE
     *             (rcommon(16), xrefscale),
     *             (rcommon(17), zetadot),
     *             (rcommon(18), zetaref),
     *             (rcommon(19), plepoch),
     *             (rcommon(20), plexpose),
     *             (rcommon(21), sig_mult),
     *             (rcommon(22), zetacur),
     *             (rcommon(23), llcx),
     *             (rcommon(24), llcy),
     *             (rcommon(25), dn_low),
     *             (rcommon(26), dn_high),
     *             (rcommon(27), dn_targ)
c
