      FUNCTION f_examexp(lb)
c
c...Statistics Of Exposures
c
      INCLUDE
     *         '../global.inc'
      PARAMETER
     *         ndefault = 5
      CHARACTER*(*)
     *         lb
      CHARACTER*19
     *         sb
      CHARACTER*6
     *         eb
      INTEGER
     *         f_examexp, nlb, n, ret, i, F_DOEXP, F_NEXP, x, y
      REAL
     *         dn
c
 9001 FORMAT (8x, i3)
 9002 FORMAT ('EXP', i3.3)
 9003 FORMAT ('Taking Exposure ', i3)
 9004 FORMAT (i3, i10)
c
c...Make Sure We Take Single Frames
c
  100 CALL x_respond(1)
      IF (grabnorm.ne.1) THEN
        ret = F_NEXP('NEXP=1')
        IF (ret.ne.1) THEN
          f_examexp = ret
          RETURN
        ENDIF
      ENDIF
c
c...Parse Line To Get Number Of Exposures
c
      nlb = LEN(lb)
      IF (nlb.gt.8) THEN
        READ (lb(1:nlb),9001,err=110) n
        IF (n.gt.1) GO TO 120
      ENDIF
  110 n = NDEFAULT
  120 CONTINUE
c
c...First Frame Enables AutoExposure
c
      i = 1
      WRITE (sb,9003) i
      CALL x_fortwrite(sb)
      nomexp = 0
      WRITE (eb,9002) nomexp
      ret = f_doexp(eb)
      IF (ret.ne.1) THEN
        f_examexp = ret
      ENDIF
      DO y=1,NROWS
        DO x=1,NCOLS
          dn = ZEXT(raw1(x,y))
          data(x,y) = dn
          flat(x,y) = dn
        ENDDO
      ENDDO
c
c...Process The Rest
c
      DO i=2,n
        WRITE (sb,9003) i
        CALL x_fortwrite(sb)
        WRITE (eb,9002) exptick
        ret = f_doexp(eb)
        IF (ret.ne.1) THEN
          f_examexp = ret
        ENDIF
        DO y=1,NROWS
          DO x=1,NCOLS
            dn = ZEXT(raw1(x,y))
            data(x,y) = MAX(data(x,y),dn)
            flat(x,y) = MIN(flat(x,y),dn)
          ENDDO
        ENDDO
      ENDDO
c
c...Load DATA With What We Want To See
c
      DO i=0,255
        wholehist(i) = 0
      ENDDO
      DO y=1,NROWS
        DO x=1,NCOLS
          i = data(x,y) + 0.5 - flat(x,y)
          i = MAX(0,MIN(255,i))
          wholehist(i) = wholehist(i) + 1
          data(x,y) = i
        ENDDO
      ENDDO
      CALL x_make0
c
c...Save Difference Histogram
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='diff.hist',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=0,255
        IF (wholehist(i).gt.0) THEN
          WRITE (1,9004) i,wholehist(i)
        ENDIF
      ENDDO
      CLOSE (1)
      f_examexp = 1
      RETURN
c
c...Problems
c
  200 f_examexp = -11
      RETURN
      END
