      FUNCTION  f_parse(buf)
c
c...Parse A Command Line
c
      INCLUDE
     *          '../global.inc'
      CHARACTER*80
     *          line
      BYTE
     *          buf(*), j
      INTEGER
     *          nline, i, F_PARSE, ret, F_DOEXP, F_DODISP, F_DOSEQ,
     *          F_PMMSEQ, F_RESET, F_SETMODE, F_SETSIG, F_SETMAG,
     *          F_DODUMP, F_DOSEE, F_DOFLAT, F_DOFIND, F_DOFINC,
     *          F_SETFLAT, F_SDUMP, F_ALLDUMP, F_PAUSE, F_NEXP,
     *          F_NOMEXP, F_PROCFLAT, F_PREFIX, C_CALLSYS, F_REREAD,
     *          F_EXAMINE, F_DNEXP, F_DODATA, F_QUIET, F_DOTOAST,
     *          F_SHOW, F_EXAMEXP, F_NEWNOM, F_ECLEAN, F_ENABLE,
     *          FITSOP, F_NEWID, F_FOCEXP, F_DZENABLE, F_SCENABLE,
     *          F_MAGENABLE, F_SATURATE, F_AUXLOAD, F_QMMSEQ, F_TAKE,
     *          F_PROCSG, F_SETDUMP, F_INFO, F_CONVOLVE, F_NEWFIND,
     *          F_ZETA, FITSVAX, FITSBFDUMP, F_DOTICK, F_ZSANE
c
c...Catch Requestes For SYSTEM() Calls Before Case/Stripping Functions
c	Note:  Strip Out Leading > Here
c
  100 IF (buf(1).eq.'>') THEN
        f_parse = C_CALLSYS(buf(2))
        RETURN
      ENDIF
c
c...Convert From Byte To Upper Case
c
c	WARNING.  Leave Spaces In SEQ Command
c
      nline = 0
      DO i=1,LEN(line)-1
        j = buf(i)
        IF (j.eq.0) THEN
          GO TO 110
        ELSEIF (j.gt.32) THEN
          IF ((j.ge.'a').and.(j.le.'z')) THEN
            j = j-32
          ENDIF
          nline = nline+1
          line(nline:nline) = CHAR(ZEXT(j))
        ELSEIF (j.eq.32) THEN
          IF (nline.ge.3) THEN
            IF (line(1:3).eq.'SEQ') THEN
              nline = nline+1
              line(nline:nline) = CHAR(ZEXT(j))
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      f_parse = -2
      RETURN
  110 IF (nline.le.0) THEN
        f_parse = -3
        RETURN
      ENDIF
      line(nline+1:nline+1) = ' '
c
c...Process The Line
c
      IF (line(1:3).eq.'EXP') THEN
        ret = f_doexp(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'DISP') THEN
        ret = f_dodisp(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'SEQ') THEN
        ret = f_doseq(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'PMM') THEN
        ret = f_pmmseq(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'QMM') THEN
        ret = f_qmmseq(line(1:nline))
c...QMMSEQ Does Its Own Call To MESSAGE Instead Of Respond!!!
      ELSEIF (line(1:3).eq.'RES') THEN
        ret = f_reset(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'SIG') THEN
        ret = f_setsig(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'MODE') THEN
        ret = f_setmode(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'MAG') THEN
        ret = f_setmag(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'DUMP') THEN
        CALL x_respond(1)
        ret = f_dodump(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'DATA') THEN
        CALL x_respond(1)
        ret = f_dodata(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'SDUMP') THEN
        CALL x_respond(1)
        ret = f_sdump(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'ADUMP') THEN
        CALL x_respond(1)
        ret = f_alldump(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'DMODE') THEN
        ret = f_setdump(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'SEE') THEN
        ret = f_dosee(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'DOFLAT') THEN
        ret = f_doflat(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'FIND') THEN
        CALL x_respond(1)
        ret = f_dofind(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'FINC') THEN
        ret = f_dofinc(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'FLAT') THEN
        ret = f_setflat(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'PAUSE') THEN
        ret = f_pause(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'NEXP') THEN
        ret = f_nexp(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'NOMEXP') THEN
        ret = f_nomexp(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:8).eq.'PROCFLAT') THEN
        CALL x_respond(1)
        ret = f_procflat(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'PREFIX') THEN
        ret = f_prefix(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'REREAD') THEN
        ret = f_reread(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:7).eq.'EXAMEXP') THEN
        ret = f_examexp(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'EXAM') THEN
        ret = f_examine(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'TREAD') THEN
        ret = -4
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'TWRITE') THEN
        ret = -4
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'DNEXP') THEN
        ret = f_dnexp(line(1:nline))
c...DNEXP Does Its Own Call To MESSAGE Instead Of RESPOND!!!
      ELSEIF (INDEX(line(1:nline),'QUIET').gt.0) THEN
        ret = f_quiet(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'SHOW') THEN
        ret = f_show(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'NEWNOM') THEN
        ret = f_newnom(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'ECLEAN') THEN
        ret = f_eclean(line(1:nline))
        CALL x_respond(0)
      ELSEIF (INDEX(line(1:nline),'DOFITS').gt.0) THEN
        ret = f_enable(line(1:nline))
        CALL x_respond(0)
      ELSEIF (INDEX(line(1:nline),'FITSVAX').gt.0) THEN
        ret = fitsvax(line(1:nline))
c...FITSVAX Does MESSAGE So No Respond Here
      ELSEIF (line(1:10).eq.'FITSBFDUMP') THEN
        ret = fitsbfdump(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'FITS') THEN
        ret = fitsop(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:2).eq.'ID') THEN
        ret = f_newid(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'FOCEXP') THEN
        ret = F_FOCEXP(line(1:nline))
c...FOCEXP Does Its Own Call To MESSAGE Instead Of RESPOND!!!
      ELSEIF (INDEX(line(1:nline),'DZ').gt.0) THEN
        ret = F_DZENABLE(line(1:nline))
        CALL x_respond(0)
      ELSEIF (INDEX(line(1:nline),'SC').gt.0) THEN
        ret = F_SCENABLE(line(1:nline))
        CALL x_respond(0)
      ELSEIF (INDEX(line(1:nline),'INT').gt.0) THEN
        ret = F_MAGENABLE(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:3).eq.'SAT') THEN
        ret = F_SATURATE(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:7).eq.'AUXLOAD') THEN
        ret = F_AUXLOAD(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:8).eq.'LOADFLAT') THEN
        CALL flatload
        ret = 1
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'TAKE') THEN
        ret = F_TAKE(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:6).eq.'PROCSG') THEN
        ret = F_PROCSG(line(1:nline))
c...PROCSG Does Its Own Call To MESSAGE Instead Of RESPOND!!!
      ELSEIF (line(1:4).eq.'INFO') THEN
        ret = F_INFO(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:7).eq.'INCTAKE') THEN
        ret = F_DOFINC('FINC')
        ret = F_TAKE(line(4:nline))
        CALL x_respond(0)
      ELSEIF (line(2:6).eq.'TOAST') THEN
        ret = F_DOTOAST(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'BDUMP') THEN
        CALL x_respond(1)
        CALL bdumpall(dprefix(1:ndprefix))
        CALL x_respond(0)
        ret = 1
      ELSEIF (line(1:4).eq.'ZETA') THEN
        ret = F_ZETA(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:5).eq.'ZSANE') THEN
        ret = F_ZSANE(line(1:nline))
        CALL x_respond(0)
      ELSEIF (line(1:4).eq.'TICK') THEN
        ret = F_DOTICK(line(1:nline))
        CALL x_respond(0)
      ELSE
        ret = -4
        CALL x_respond(0)
      ENDIF
      f_parse = ret
      RETURN
      END
