      SUBROUTINE  mgo_docont(x0,y0,x1,y1)
c
c...Contour Inside A Box
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            NMAX = 100000
      INTEGER
     *            x0, y0, x1, y1, ix0, iy0, ix1, iy1, x, y, buf(20),
     *            i, nx, ny
      REAL
     *            jrast(NMAX)
      REAL
     *            udx, udy, ddx, ddy, rx, ry, rr
c
c...Set Up
c
  100 ix0 = MIN(x0,x1) + 1
      ix1 = MAX(x0,x1) + 1
      iy0 = MIN(y0,y1) + 1
      iy1 = MAX(y0,y1) + 1
      ix0 = MAX(1,MIN(NCOLS,ix0))
      ix1 = MAX(1,MIN(NCOLS,ix1))
      iy0 = MAX(1,MIN(NROWS,iy0))
      iy1 = MAX(1,MIN(NROWS,iy1))
      nx = MAX(1,ix1+1-ix0)
      ny = MAX(1,iy1+1-iy0)
c
c...Truncate Box If Too Big
c
      IF ((nx*ny).gt.NMAX) THEN
        iy1 = iy0 + NMAX/nx
      ENDIF
c
c...Keep Pixels Square
c
      udx = MAX(1, nx)
      udy = MAX(1, ny)
      CALL x_export(buf)
      ddx = buf(14)
      ddy = buf(15)
      rx = ddx/udx
      ry = ddy/udy
      rr = MIN(rx,ry)
c
c...Do The Contour Diagram The Hard Way
c
      CALL x_erase7
      i = 0
      DO y=iy0,iy1
        DO x=ix0,ix1
          i = i+1
          jrast(i) = data(x,y)
        ENDDO
      ENDDO
      CALL xd_contour(jrast,nx,nx,ny, 10.,250.,10., rr)
      RETURN
      END
