      SUBROUTINE  cc_auto0foc(err)
c
c...Driver For AutoFocus Loop
c
c	Uses F_FOCEXP On SGx
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            zstep = 0.4,
     *            nitmax = 3
      INTEGER
     *            err, i, niter
      REAL
     *            zlow, zmid, zhigh, llow, lmid, lhigh
c
 9001 FORMAT (f8.0)
 9002 FORMAT (/ ' CC Error '/)
 9003 FORMAT (/ ' Parse Error >>', z, '<<' /)
 9004 FORMAT (/ ' SG Error ', a /)
 9005 FORMAT (/ ' Lost ', 6f8.2 /)
 9006 FORMAT (i8)
 9007 FORMAT ('0=FOCEXP0(', f6.3, ')')
 9008 FORMAT ('0=FOCEXP(', f6.3, ')')
c
c...Start At Current Location
c
  100 niter = 0
      nlb = 5
      lb(1:nlb) = 'WAIT0'
      CALL cc_wait(err)
      IF (err.ne.0) GO TO 200
      zmid = curpos(3)
      WRITE (lb,9007) curpos(3)
      nlb = 17
      CALL cc_sg0talk(err)
      IF (err.ne.0) GO TO 200
      READ (lb(1:nlb),9001,err=210) lmid
      IF (lmid.lt.0.0) GO TO 220
c
c...Guess An Increment In Z
c
      zhigh = zmid + ZSTEP
      reqpos(3) = zhigh
      nlb = 7
      lb(1:nlb) = 'OFFSETS'
      CALL cc_offset(err)
      IF (err.ne.0) GO TO 200
      CALL cc_move(err)
      IF (err.ne.0) GO TO 200
      nlb = 5
      lb(1:nlb) = 'WAIT0'
      CALL cc_wait(err)
      IF (err.ne.0) GO TO 200
      WRITE (lb,9008) curpos(3)
      nlb = 16
      CALL cc_sg0talk(err)
      IF (err.ne.0) GO TO 200
      READ (lb(1:nlb),9001,err=210) lhigh
      IF (lhigh.lt.0.0) GO TO 220
c
c...Did It Get Better
c
  110 IF (lhigh.gt.lmid) THEN
        zlow = zmid
        llow = lmid
        zmid = zhigh
        lmid = lhigh
        zhigh = zmid + (zmid-zlow)
        reqpos(3) = zhigh
        nlb = 7
        lb(1:nlb) = 'OFFSETS'
        CALL cc_offset(err)
        IF (err.ne.0) GO TO 200
        CALL cc_move(err)
        IF (err.ne.0) GO TO 200
        nlb = 5
        lb(1:nlb) = 'WAIT0'
        CALL cc_wait(err)
        IF (err.ne.0) GO TO 200
        WRITE (lb,9008) curpos(3)
        nlb = 16
        CALL cc_sg0talk(err)
        IF (err.ne.0) GO TO 200
        READ (lb(1:nlb),9001,err=210) lhigh
        IF (lhigh.lt.0.0) GO TO 220
      ELSE
c
c...Or Worse
c
        zlow = zmid - (zhigh-zmid)
        reqpos(3) = zlow
        nlb = 7
        lb(1:nlb) = 'OFFSETS'
        CALL cc_offset(err)
        IF (err.ne.0) GO TO 200
        CALL cc_move(err)
        IF (err.ne.0) GO TO 200
        nlb = 5
        lb(1:nlb) = 'WAIT0'
        CALL cc_wait(err)
        IF (err.ne.0) GO TO 200
        WRITE (lb,9008) curpos(3)
        nlb = 16
        CALL cc_sg0talk(err)
        IF (err.ne.0) GO TO 200
        READ (lb(1:nlb),9001,err=210) llow
        IF (llow.lt.0.0) GO TO 220
      ENDIF
c
c...Use 3 Points To Improve Our Guess
c
  120 CONTINUE
      IF ((lhigh.gt.lmid).and.(lmid.gt.llow)) THEN
        GO TO 110
      ELSEIF ((llow.gt.lmid).and.(lmid.gt.lhigh)) THEN
        zhigh = zmid
        lhigh = lmid
        zmid = zlow
        lmid = llow
        GO TO 110
      ELSEIF ((llow.gt.lmid).and.(lhigh.gt.lmid)) THEN
        GO TO 230
      ELSE
        IF ((lmid-lhigh).lt.(lmid-llow)) THEN
          zlow = zmid
          llow = lmid
        ELSE
          zhigh = zmid
          lhigh = lmid
        ENDIF
        zmid = 0.5*(zlow+zhigh)
        reqpos(3) = zmid
        nlb = 7
        lb(1:nlb) = 'OFFSETS'
        CALL cc_offset(err)
        IF (err.ne.0) GO TO 200
        CALL cc_move(err)
        IF (err.ne.0) GO TO 200
        nlb = 5
        lb(1:nlb) = 'WAIT0'
        CALL cc_wait(err)
        IF (err.ne.0) GO TO 200
        WRITE (lb,9008) curpos(3)
        nlb = 16
        CALL cc_sg0talk(err)
        IF (err.ne.0) GO TO 200
        READ (lb(1:nlb),9001,err=210) lmid
        IF (lmid.lt.0.0) GO TO 220
        niter = niter+1
        IF (niter.le.NITMAX) GO TO 120
      ENDIF
      err = 0
      RETURN
c
c...Error
c
  200 WRITE (*,9002)
      err = -89
      RETURN
  210 WRITE (*,9003) lb(1:nlb)
      err = -88
      RETURN
  220 READ (lb(1:nlb),9006,err=210) err
      RETURN
  230 WRITE (*,9005) zlow,llow,zmid,lmid,zhigh,lhigh
c
c...Dies When We Are Close.  Just Take Middle
c
      reqpos(3) = zmid
      err=0
      RETURN
      END
