      SUBROUTINE  cc_cmazimuth(err)
c
c...Go To A Specific Azimuth (In Degrees)
c
      INCLUDE
     *            'c.inc'
      PARAMETER
     *            tick_per_rev = 50000,
     *            tick_min = -48000,
     *            tick_max = -2000
      CHARACTER*11
     *            tb
      INTEGER
     *            who, new, old, i, w, ntb, err
      REAL
     *            q
c
 9001 FORMAT (i10)
 9003 FORMAT (i1,  'D', i5.5, ' ', i1, 'G')
 9004 FORMAT (i1, 'D-', i5.5, ' ', i1, 'G')
c
c...Sanity Check
c
  100 IF (cm_state.lt.0) THEN
        WRITE (*,9001) cm_state
        RETURN
      ENDIF
c
c...Parse
c
      i = INDEX(lb(1:nlb),'=')
      IF ((i.le.0).or.(i.ge.nlb)) THEN
        err = -1
        RETURN
      ENDIF
      who = 2
      IF (lb(i-1:i-1).eq.'0') THEN
        who = 0
      ELSEIF (lb(i-1:i-1).eq.'1') THEN
        who = 1
      ENDIF
      CALL cc_cmpower(who,1)
      READ (lb(i+1:nlb),9001,err=200) new
      new = MOD(new,TICK_PER_REV)
      IF (new.gt.0) THEN
        new = new - TICK_PER_REV
      ENDIF
      new = MAX(TICK_MIN,MIN(TICK_MAX,new))
c
c...Process 0
c
      IF (who.ne.1) THEN
        CALL cc_cmposition(0,q,old,err)
        IF (err.ne.0) RETURN
        w = 1
        i = new-old
        IF (i.lt.0) THEN
          i = -i
          WRITE (tb,9004) w,i,w
          ntb = 11
        ELSE
          WRITE (tb,9003) w,i,w
          ntb = 10
        ENDIF
        CALL cc_cmwr(tb(1:ntb),err)
        IF (err.ne.0) RETURN
      ENDIF
c
c...Process 1
c
      IF (who.ne.0) THEN
        CALL cc_cmposition(1,q,old,err)
        IF (err.ne.0) RETURN
        w = 2
        i = new-old
        IF (i.lt.0) THEN
          i = -i
          WRITE (tb,9004) w,i,w
          ntb = 11
        ELSE
          WRITE (tb,9003) w,i,w
          ntb = 10
        ENDIF
        CALL cc_cmwr(tb,err)
        IF (err.ne.0) RETURN
      ENDIF
c
c...Wait
c
      CALL cc_cmwait(who,err)
      CALL cc_cmpower(who,0)
      RETURN
c
c...Parse Error
c
  200 err = -3
      RETURN
      END
