      SUBROUTINE  cc_opener
c
c...Open All Of The I/O Channels
c
      INCLUDE
     *            'c.inc'
      INTEGER
     *            DEV_GETPRIV, DEV_PYOPEN, DEV_STTOPEN, DEV_PJOPEN,
     *            DEV_TTOPEN, DEV_CCDOPEN, DEV_RTSOPEN, DEV_XTTOPEN,
     *            DEV_TIMOPEN, DEV_QTER, err, i, j, DEV_NAGOPEN,
     *            DEV_UTTOPEN, DEV_ENCOPEN, DEV_SLEEP, DEV_CAMOPEN
c
 9001 FORMAT (' GETPRIV Error ', z8)
 9002 FORMAT (' STT Error ', z8, ' Assuming No SG0 Processing')
 9003 FORMAT ('  PY Error ', z8)
 9004 FORMAT ('  TT Error ', z8)
 9005 FORMAT (' RTS Error ', z8)
 9006 FORMAT (' XTT Error ', z8, ' Assuming No SG1 Processing')
 9007 FORMAT (' CCD Error ', z8)
 9008 FORMAT (' TIM Error ', z8)
 9009 FORMAT ('  PJ Error ', z8)
 9010 FORMAT (' NAG Error ', z8)
 9011 FORMAT (' UTT Error ', z8)
 9012 FORMAT (' ENC Error ', z8)
 9013 FORMAT (/ ' Waiting For PY ', z8 /)
 9014 FORMAT (' CAM Error ', z8)
c
c...Open The VMS Devices
c
  100 err = DEV_GETPRIV()
      IF (err.ne.0) THEN
        WRITE (*,9001) err
        GO TO 200
      ENDIF
      err = DEV_TIMOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9008) err
        GO TO 200
      ENDIF
c
c...Special Logic For Use Of SG1 Only
c
      err = DEV_STTOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9002) err
        sg0_open = -1
      ELSE
        sg0_open = 0
      ENDIF
c
c...Special Logic To Make Sure We Own PY While DAEMON Is Running
c
      DO i=1,3
        err = DEV_PYOPEN()
        IF (err.ne.0) THEN
          WRITE (*,9013) err
          j = DEV_SLEEP(1.0)
        ELSE
          GO TO 110
        ENDIF
      ENDDO
      err = DEV_PYOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9003) err
        GO TO 200
      ENDIF
  110 CONTINUE
c
      err = DEV_TTOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9004) err
        GO TO 200
      ENDIF
      err = DEV_RTSOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9005) err
        GO TO 200
      ENDIF
      err = DEV_XTTOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9006) err
        sg1_open = -1
      ELSE
        sg1_open = 0
      ENDIF
c      err = DEV_CCDOPEN()
c      IF (err.ne.0) THEN
c        WRITE (*,9007) err
c        GO TO 200
c      ENDIF
      err = DEV_NAGOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9010) err
        GO TO 200
      ENDIF
      err = DEV_UTTOPEN()
      IF (err.ne.0) THEN
        uttmode = 0
      ELSE
        uttmode = 1
      ENDIF
      err = DEV_ENCOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9012) err
        GO TO 200
      ENDIF
      err = DEV_CAMOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9014) err
        GO TO 200
      ENDIF
      err = DEV_PJOPEN()
      IF (err.ne.0) THEN
        WRITE (*,9009) err
        GO TO 200
      ENDIF
c
c...Default System Turn-On State
c
  120 err = DEV_QTER()
      IF (err.gt.0) GO TO 120
      CALL py_open(0,1,0,0)
      CALL cc_pyinit
      ano_open = 0
      CALL cc_anologin
      IF (ano_open.eq.0) GO TO 200
      CALL cc_anosync(err)
      IF (err.ne.0) GO TO 200
      IF (sg0_open.ge.0) THEN
        CALL cc_sg0login
      ELSE
        sg0_open = 0
      ENDIF
      IF (sg1_open.ge.0) THEN
        CALL cc_sg1login
      ELSE
        sg1_open = 0
      ENDIF
      CALL cc_cminit(err)
c
c...Initial Condition Of Variables In COMMON
c
      CALL cc_loadoff
      ano_seq = 0
      sg0_seq = 0
      sg1_seq = 0
      cm_state = 0
      panic = 0
      inunit = 0
      takeflag = 0
      separation(1) = -101.0D00
      separation(2) = 0.0D00
      separation(3) = 0.0D00
      separation(4) = 0.0D00
      postol(1) = 0.001D00
      postol(2) = 0.001D00
      postol(3) = 0.01D00
      postol(4) = 0.01D00
      movspeed(1) = 3.0
      movspeed(2) = 3.0
      movspeed(3) = 1.0
      movspeed(4) = 1.0
c
c...Nominals For Plate Holder 1
c
      platexmin(1,1) = 380.0
      platexmax(1,1) = 700.0
      plateymin(1,1) =  18.0
      plateymax(1,1) = 342.0
      platexmin(2,1) = 377.0
      platexmax(2,1) = 697.0
      plateymin(2,1) = 411.0
      plateymax(2,1) = 735.0
      platezmin(1) = 82.0
      platezmax(1) = 92.0
      plateamin(1) = 0.5
      plateamax(1) = 1.5
      plateznom(1,1) = 88.0
      plateznom(2,1) = 88.0
      plateanom(1,1) = 1.0
      plateanom(2,1) = 1.0
c
c...Nominals For Plate Holder 2
c
      platexmin(1,2) = 380.0
      platexmax(1,2) = 700.0
      plateymin(1,2) =  18.0
      plateymax(1,2) = 342.0
      platexmin(2,2) = 377.0
      platexmax(2,2) = 697.0
      plateymin(2,2) = 411.0
      plateymax(2,2) = 735.0
      platezmin(2) = 82.0
      platezmax(2) = 92.0
      plateamin(2) = 0.5
      plateamax(2) = 1.5
      plateznom(1,2) = 88.0
      plateznom(2,2) = 88.0
      plateanom(1,2) = 1.0
      plateanom(2,2) = 1.0
      emulsion(1) = 0.0D00
      emulsion(2) = 0.0D00
      usearea = 1
      nlb = 7
      lb(1:nlb) = 'MINMAX1'
      CALL cc_minmax(err)
      minval(3) = 82.0D00
      minval(4) = 0.5D00
      maxval(3) = 92.0D00
      maxval(4) = 1.5D00
      reqpos(1) = minval(1)
      reqpos(2) = minval(2)
      reqpos(3) = 88.0D00
      reqpos(4) = 1.0D00
      fit1min(1) = platexmin(1,1)
      fit1max(1) = platexmax(1,1)
      fit1min(2) = platexmin(2,1)
      fit1max(2) = platexmax(2,1)
      fit0min(1) = fit1min(1) + separation(1)
      fit0max(1) = fit1max(1) + separation(1)
      fit0min(2) = fit1min(2) + separation(1)
      fit0max(2) = fit1max(2) + separation(1)
      fitvalid = -1
      fitselect = 1
      zlcal = 88.0D00
      model(1) = 0
      model(2) = 0
      model(3) = 0
      model(4) = 0
      camoff(1) = 0.0
      camoff(2) = 0.0
      ano_dt = 60.0
      sg0_dt = 200.0
      sg1_dt = 200.0
      ncommand = 0
      seqstep = 0
      nstep = 0
      nxstep = 0
      nystep = 0
      doecho = 0
      taumode = 0
      nlb = 6
      lb(1:nlb) = 'RECAL1'
      CALL cc_recal(err)
      CALL cc_preseq
      CALL cc_shove(' ',statchar)
      CALL cc_shove(' ',waitchar)
      CALL cc_shove('0',deepchar)
      DO i=1,4
        status(i) = '?'
      ENDDO
      nplateid(1) = 6
      plateid(1) = 'UJ9999'
      nplateid(2) = 6
      plateid(2) = 'SJ9999'
      nplateid(3) = 6
      plateid(3) = 'SF9999'
      nplateid(4) = 6
      plateid(4) = 'SN9999'
      holder = 1
      barhold = 1
      barpos = 1
      whichbar = 0
      nbarid = 6
      barid = 'PLATE1'
      DO i=1,4
        plsurvey(i) = '0'
        plemul(i) = 'X'
        pltim(i) = '11:22:33:44:55'
        plra(i) = '11:22:33'
        pldec(i) = '+11:22:33'
        plexp(i) = '000.0'
      ENDDO
      DO i=1,2
        tapeid(i) = 0
      ENDDO
      tapenum = 0
      tapedrive = 0
      whichtape = 0
      CALL cc_gettime(bar_time)
      autofoc = 0
      DO i=1,2
        xfocus(i) = 0.0
        yfocus(i) = 0.0
        zfocus(i) = 0.0
      ENDDO
c
c...Null Request
c
      CALL cc_anogetxyza(err)
      IF (err.ne.0) GO TO 200
      DO i=1,4
        reqpos(i) = curpos(i)
        offset(i) = 0.0D00
      ENDDO
      RETURN
c
c...Error Exit
c
  200 CALL cc_closer
      CALL EXIT
      END
