      SUBROUTINE  cc_sg01rcv(err,wait,niter0,niter1)
c
c...Listen For Messages From SG0 and/or SG1
c
      INCLUDE
     *            'c.inc'
      INTEGER
     *            err, wait, do0, do1, inloop, i,
     *            niter0, niter1, nbb0, nbb1, e0, e1, o0, o1,
     *            DEV_STTSGREAD, DEV_XTTSGREAD
      BYTE
     *            bb(NIOMAX)
c
c...Figure Out What To Do
c
  100 IF ((err.ne.0).or.(wait.eq.0)) RETURN
      IF (wait.lt.0) THEN
        inloop = 1
        i = -wait
      ELSE
        inloop = 0
        i = wait
      ENDIF
      IF ((i.eq.1).or.(i.eq.3)) THEN
        do0 = 1
      ELSE
        do0 = 0
      ENDIF
      IF ((i.eq.2).or.(i.eq.3)) THEN
        do1 = 1
      ELSE
        do1 = 0
      ENDIF
c
c...See If SG0 Has Responded
c
  110 IF (do0.ne.0) THEN
        nbb0 = NIOMAX
        e0 = DEV_STTSGREAD(nbb0,bb)
        IF (e0.ne.0) THEN
          panic = IOR(panic,PANIC_SG0_RE)
        ELSE
          IF (nbb0.gt.0) THEN
            DO i=1,nbb0
              nrcv0 = nrcv0 + 1
              rcv0(nrcv0) = bb(i)
            ENDDO
            IF (rcv0(nrcv0).eq.'A') THEN
              sg0_seq = 1
            ELSEIF (rcv0(nrcv0).eq.'E') THEN
              IF (sg0_seq.gt.0) THEN
                panic = IOR(panic,PANIC_SG0_QIO)
                sg0_seq = 0
              ENDIF
            ELSEIF (rcv0(nrcv0).eq.'K') THEN
              IF (sg0_seq.gt.0) THEN
                sg0_seq = 0
              ENDIF
            ENDIF
            panic = IAND(panic,NOT(PANIC_SG0_DT))
            panic = IAND(panic,NOT(PANIC_SG0_RE))
            CALL sg_sgmsgcheck(nxmt0,xmt0,nrcv0,rcv0,e0,do1)
          ELSE
            niter0 = niter0+1
          ENDIF
        ENDIF
      ENDIF
c
c...See If SG1 Has Responded
c
      IF (do1.ne.0) THEN
        nbb1 = NIOMAX
        e1 = DEV_XTTSGREAD(nbb1,bb)
        IF (e1.ne.0) THEN
          panic = IOR(panic,PANIC_SG1_RE)
        ELSE
          IF (nbb1.gt.0) THEN
            DO i=1,nbb1
              nrcv1 = nrcv1 + 1
              rcv1(nrcv1) = bb(i)
            ENDDO
            IF (rcv1(nrcv1).eq.'A') THEN
              sg1_seq = 1
            ELSEIF (rcv1(nrcv1).eq.'E') THEN
              IF (sg1_seq.gt.0) THEN
                panic = IOR(panic,PANIC_SG1_QIO)
                sg1_seq = 0
              ENDIF
            ELSEIF (rcv1(nrcv1).eq.'K') THEN
              IF (sg1_seq.gt.0) THEN
                sg1_seq = 0
              ENDIF
            ENDIF
            panic = IAND(panic,NOT(PANIC_SG1_DT))
            panic = IAND(panic,NOT(PANIC_SG1_RE))
            CALL sg_sgmsgcheck(nxmt1,xmt1,nrcv1,rcv1,e1,do1)
          ELSE
            niter1 = niter1+1
          ENDIF
        ENDIF
      ENDIF
c
c...Monitor Progress Of Receiving
c
      IF (do0.ne.0) THEN
        CALL cc_sgmonitor(sg0_seq,niter0,e0,do0)
      ENDIF
      IF (do1.ne.0) THEN
        CALL cc_sgmonitor(sg1_seq,niter1,e1,do1)
      ENDIF
c
c...If INLOOP!=0 And Still Not Response, Wait And Try Again
c
      IF (inloop.eq.0) THEN
        IF ((do0.ne.0).or.(do1.ne.0)) THEN
          CALL cc_sleep(0.1)
          GO TO 110
        ENDIF
      ENDIF
c
c...Has An Error Occurred?
c
      err = -MAX(ABS(e0),ABS(e1))
      IF (err.ne.0) RETURN
c
c...Hard Checking For Spurious Messages
c
      RETURN
      END
