      SUBROUTINE  cc_zfit(nn,xx,yy,in,rr, nc,cc,scc,stder,sanity,err)
c
c...Perform The Z Fit
c
c	ERR=0	OK
c	ERR=1	Too Few Points
c	ERR=2	Matrix Didn't Invert
c	ERR=3	Error Is Too Big
c
      INCLUDE
     *            'c.inc'
      INTEGER
     *            nn, i, j, k, nc, ising, in(*), err, nin
      REAL
     *            xx(*), yy(*)
      DOUBLE PRECISION
     *            x, y, yc, yr, chisq, stder, dv(NZCMAX),
     *            zlhs(NZCMAX), zrhs(NZCMAX,NZCMAX),
     *            cc(*), scc(*), sanity, rr(*)
c
c...Initialize
c
  100 chisq = 0.0D00
      DO i=1,nc
        cc(i) = 0.0D00
        zlhs(i) = 0.0D00
        DO j=1,nc
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      nin = 0
c
c...Accumulate
c
      DO i=1,nn
        IF (in(i).ne.0) THEN
          x = xx(i)
          y = yy(i)
          dv(1) = 1.0D00
          DO j=2,nc
            dv(j) = dv(j-1)*x
          ENDDO
          DO j=1,nc
            zlhs(j) = zlhs(j) + dv(j)*y
            DO k=1,nc
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Invert
c
      IF (nin.le.(nc+1)) THEN
        err = 1
        GO TO 200
      ENDIF
      CALL cc_matinv(nc,zrhs,ising)
      IF (ising.ne.0) THEN
        err = 2
        GO TO 200
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        DO j=1,nc
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,nn
        x = xx(i)
        y = yy(i)
        dv(1) = 1.0D00
        DO j=2,nc
          dv(j) = dv(j-1)*x
        ENDDO
        yc = 0.0D00
        DO j=1,nc
          yc = yc + dv(j)*cc(j)
        ENDDO
        yr = y-yc
        rr(i) = yr
        IF (in(i).ne.0) THEN
          chisq = chisq + yr*yr
        ENDIF
      ENDDO
c
c...Errors
c
      stder = SQRT(chisq/(nin - (nc+1)))
      DO i=1,nc
        scc(i) = stder*SQRT(zrhs(i,i))
      ENDDO
      IF (stder.gt.sanity) THEN
        err = 3
      ELSE
        err = 0
      ENDIF
c
c...Common Exit
c
  200 CONTINUE
      RETURN
      END
