      SUBROUTINE  byteflat(im,dn)
c
c...InPlace Flatten
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            npixel = nrows*ncols
      BYTE
     *            im(*)
      REAL
     *            dn(*), bp(npixel), fp(npixel)
      INTEGER
     *            i
      EQUIVALENCE
     *            (bp(1),bias(1,1)), (fp(1),flat(1,1))
c
C$DOACROSS LOCAL (i)
  100 DO i=1,npixel
        dn(i) = im(i)
        IF (dn(i).lt.0.0) THEN
          dn(i) = dn(i) + 256.0
        ENDIF
        dn(i) = (dn(i) - bp(i))*fp(i)
        dn(i) = MAX(0.0,MIN(255.0,dn(i)))
        IF (dn(i).lt.128.0) THEN
          im(i) = dn(i)
        ELSE
          im(i) = dn(i) - 256.0
        ENDIF
      ENDDO
      RETURN
      END
