#include	"xpmm.h"
/*
 *****************************************************************************
 *
 *   x_event0  --  Events in Picture Display
 */
x_event0(e)
XEvent *e;
{
	static int inside = 0;
	static int down = 0;
	static unsigned int which = 0;
	static int xdown = 0;
	static int ydown = 0;
	static int winxd = 0;
	static int winyd = 0;
	int x, y, xraw, yraw, sx, sy, px, py;
/*
 *   Update Cursor On Every Call.  NOTE:  1-Indexed For FORTRAN
 */
	if (inside != 0) {
		x = e->xbutton.x;
		y = e->xbutton.y;
		if (x < 0)
			x = 0;
		if (x >= W0_WIDTH)
			x = W0_WIDTH - 1;
		if (y < 0)
			y = 0;
		if (y >= W0_HEIGHT)
			y = W0_HEIGHT - 1;
		xraw = x;
		yraw = y;
/*
 *   Convert From Screen To User Pixels.  ZOOM==0 Means We See TINY
 */
		if (zoom_0 <= 0) {
			x = x*ratio_0 + 1;
			y = y*ratio_0 + 1;
		} else {
			px = xpan_0 - W0_WIDTH/(2*zoom_0);
			py = ypan_0 - W0_HEIGHT/(2*zoom_0);
			if (px < 0)
				px = 0;
			if (py < 0)
				py = 0;
			x = (x-1)/zoom_0 + px;
			y = (y-1)/zoom_0 + py;
		}
/*
 *   Do Different Things On The Basis Of MODE_0
 */
		switch (mode_0) {

		case 1:
			sx = xpan_0;
			sy = ypan_0;
			xpan_0 = x;
			ypan_0 = y;
			x_update3_();
			xpan_0 = sx;
			ypan_0 = sy;
			break;

		case 2:
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
                case 12:
                case 25:
			if (down != 0) {
				xup_0 = x;
				yup_0 = y;
			} else {
				xcur_0 = x;
				ycur_0 = y;
			}
			x_update3_();
			break;

		case 3:
			if (down != 0) {
				xwin_0 = winxd + (1000*(xraw-xdown))/W0_WIDTH;
				if (xwin_0 < 0)
					xwin_0 = 0;
				if (xwin_0 > 999)
					xwin_0 = 999;
				ywin_0 = winyd + (1000*(yraw-ydown))/W0_HEIGHT;
				if (ywin_0 < 0)
					ywin_0 = 0;
				if (ywin_0 > 999)
					ywin_0 = 999;
				x_mapcmap0();
				x_update3_();
			}
			break;

		default:
			break;
		}
	}
/*
 *   Event Processing
 */
	switch (e->type) {

	case Expose:
	case ConfigureNotify:
	case MapNotify:
		x_make0_();
		x_update3_();
		break;

	case EnterNotify:
		inside = 1;
		break;

	case LeaveNotify:
		inside = 0;
		break;

	case VisibilityNotify:
		if (inside != 0) {
			x_make0_();
			x_update3_();
		}
		break;

	case ButtonPress:
		down = 1;
		which = e->xbutton.button;
		xdown = 0;
		ydown = 0;
		winxd = 0;
		winyd = 0;
		if (mode_0 == 0) {
			x_make0_();
			x_update3_();
		}
		break;

	case ButtonRelease:
		down = 0;
		if (mode_0 == 1) {
			xpan_0 = x;
			ypan_0 = y;
		}
		mode_0 = 0;
		break;

	case KeyPress:
		break;

	default:
		break;
	}
}
