      SUBROUTINE  x_make0
c
c...Generate Display Image From DATA
c
      INCLUDE
     *            '../global.inc'
      PARAMETER
     *            YPUTMAX = ((NROWS+2)/3),
     *            XGETMAX = ((NCOLS/3)*3)
      INTEGER
     *            zf, xget, xput, yget, yput, buf(20),
     *            px, py, wx, wy, nx, ny, x1, x2, y1, y2,
     *            xz, yz,who, X_PIXEL
      REAL
     *            rb(NCOLS)
c
c...Get Display Information
c
  100 CALL x_export(buf)
      px  = buf( 7)
      py  = buf( 8)
      zf  = buf( 9)
      wx  = buf(12)
      wy  = buf(13)
      who = buf(16)
c
c...ZOOM<0 Means Do Not Display
c
      IF (zf.lt.0) RETURN
c
c...ZOOM==0 Means Display Is Whole Image
c
      IF (zf.le.0) THEN
        yget = 0
        DO yput=1,YPUTMAX
c
c...First Row Is Copied
c
          yget = yget+1
          xput = 0
          DO xget=1,XGETMAX,3
            xput = xput+1
            rb(xput) = MAX(
     *                     X_PIXEL(xget  ,yget,who),
     *                     X_PIXEL(xget+1,yget,who),
     *                     X_PIXEL(xget+2,yget,who)
     *                    )
          ENDDO
c
c...Second Row (If Legal) Is Comparison
c
          yget = yget+1
          IF (yget.le.NROWS) THEN
            xput = 0
            DO xget=1,XGETMAX,3
              xput = xput+1
              rb(xput) = MAX(
     *                       rb(xput),
     *                       X_PIXEL(xget  ,yget,who),
     *                       X_PIXEL(xget+1,yget,who),
     *                       X_PIXEL(xget+2,yget,who)
     *                      )
            ENDDO
          ENDIF
c
c...Third Row (If Legal) Is Comparison
c
          yget = yget+1
          IF (yget.le.NROWS) THEN
            xput = 0
            DO xget=1,XGETMAX,3
              xput = xput+1
              rb(xput) = MAX(
     *                       rb(xput),
     *                       X_PIXEL(xget  ,yget,who),
     *                       X_PIXEL(xget+1,yget,who),
     *                       X_PIXEL(xget+2,yget,who)
     *                      )
            ENDDO
          ENDIF
c
c...Display This Line
c
          CALL x_wline0(yput,rb)
        ENDDO
        RETURN
      ENDIF
c
c...Display For Arbitrary Zoom/Pan
c
      nx = wx/zf
      x1 = px + 1 - nx/2
      x2 = px + nx/2
      IF (x1.lt.1) THEN
        x1 = 1
        x2 = nx
      ENDIF
      IF (x2.gt.NCOLS) THEN
        x2 = NCOLS
        x1 = NCOLS + 1 - nx
      ENDIF
      ny = wy/zf
      y1 = py + 1 - ny/2
      y2 = py + ny/2
      IF (y1.lt.1) THEN
        y1 = 1
        y2 = ny
      ENDIF
      IF (y2.gt.NROWS) THEN
        y2 = NROWS
        y1 = NROWS + 1 - ny
      ENDIF
c
c...Clear Out End Of Display Row
c
      DO xput=zf*nx+1,wx
        rb(xput) = 0.0
      ENDDO
c
c...Loop Over Source Rows
c
      yput = 0
      DO yget=y1,y2
        DO yz=1,zf
c
c...Loop Over Source Columns
c
          xput = 0
          DO xget=x1,x2
            DO xz=1,zf
              xput = xput+1
              rb(xput) = X_PIXEL(xget,yget,who)
            ENDDO
          ENDDO
c
c...Display This Line
c
          yput = yput+1
          CALL x_wline0(yput,rb)
        ENDDO
      ENDDO
      RETURN
      END
