#include	"xpmm.h"
#define	WIDE	999.5
/*
 *****************************************************************************
 *
 *   mapcmap0  -- Cursor To CMAP
 */
x_mapcmap0()
{
	double o, s, v, fx, fy, nn;
	int i, dn, x, y;
/*
 *   X Measures Slope, Y Measures Offset
 */
	fx = (2.0*(double)xwin_0 - WIDE)/WIDE;
	fy = (2.0*(double)ywin_0 - WIDE)/WIDE;
	nn = ncol_0;
	o = fy*nn;
	if (fx < 0.0)
		s = (fx/(1.0+fx))*256.0/nn;
	else
		s = (fx/(1.0-fx))*256.0/nn;
/*
 *   Fill Table And Apply
 */
	for (i=0; i<ncol_0; i++) {
		v = s*((double)i - o);
		if (v > 255.0)
			dn = 255;
		else {
			if (v < 0.0)
				dn = 0;
			else
				dn = v;
		}
		cmap0[i].red = 256*dn;
		cmap0[i].green = 256*dn;
		cmap0[i].blue = 256*dn;
		cmap0[i].flags = DoRed | DoGreen | DoBlue;
	}
	XStoreColors(dp_0, cm_0, cmap0, ncol_0);
}
