load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"
;;;;;;;;;;;;;;;;;;
function dlnws(T)
begin

pliq=0.01*exp(54.842763- 6763.22/T-4.21*log(T) + 0.000367*T+tanh(0.0415*(T-218.8))*\
                (53.878 -1331.22/T-9.44523*log(T) + 0.014025*T))
pice=exp(9.550426-5723.265/T+3.53068*log(T)-0.00728332*T)/100.
T1=T+1.
pliq1=0.01*exp(54.842763- 6763.22 / T1-4.21*log(T1) + 0.000367*T1+tanh(0.0415*(T1 - 218.8))*\
                (53.878 -1331.22/T1-9.44523*log(T1) + 0.014025*T1))
pice1=exp(9.550426-5723.265/T1+3.53068*log(T1)-0.00728332*T1)/100.

ws=where(T.ge.273,pliq,pice)
ws1=where(T1.ge.273,pliq1,pice1)

dws=ws/(ws1-ws)
return(dws)
end
;;;;;;;;;;;;;;;;;;;

;************************************************
begin
;************************************************
; variable and file handling
;************************************************

imodel=0
il=1

models= (/"GFDL-CM3","IPSL-CM5A-LR","HadGEM2-ES","CCSM4","CanESM2","MRI-CGCM3",\
"MPI-ESM-MR","inmcm4","MIROC5","NorESM1-M"/)
model      = models(imodel)
expr1      = "abrupt4xCO2"
expr2      = "piControl"
member     = "r1i1p1_144x90"
realm      = "Amon"

nyear      = 10
nmon       = 12
n          = nyear*nmon
nsum=150*12
var1_name  = "ta"
var2_name  = "ts"
var3_name  = "hus"
;************** input dir *********************** 
levs=(/"toa","surface"/)

print(il)

dir2       = "/gs/project/ktg-565-aa/xxtan/data/kernel/rrtmgkernel/kernel-highR/"+levs(il)+"/"  
file1      = addfile(dir2+"RRTMG_t_"+levs(il)+"_clr_highR.nc","r")
tkclr=file1->lwkernel
file1      = addfile(dir2+"RRTMG_t_"+levs(il)+"_cld_highR.nc","r")
tkcld=file1->lwkernel

file1      = addfile(dir2+"RRTMG_ts_"+levs(il)+"_clr_highR.nc","r")
tskclr=file1->lwkernel
file1      = addfile(dir2+"RRTMG_ts_"+levs(il)+"_cld_highR.nc","r")
tskcld=file1->lwkernel
file1      = addfile(dir2+"RRTMG_alb_"+levs(il)+"_clr_highR.nc","r")
albkclr=file1->swkernel
file1      = addfile(dir2+"RRTMG_alb_"+levs(il)+"_cld_highR.nc","r")
albkcld=file1->swkernel
file1      = addfile(dir2+"RRTMG_wv_lw_"+levs(il)+"_clr_highR.nc","r")
wvlwkclr=file1->lwkernel
file1      = addfile(dir2+"RRTMG_wv_sw_"+levs(il)+"_clr_highR.nc","r")
wvswkclr=file1->swkernel
file1      = addfile(dir2+"RRTMG_wv_lw_"+levs(il)+"_cld_highR.nc","r")
wvlwkcld=file1->lwkernel
file1      = addfile(dir2+"RRTMG_wv_sw_"+levs(il)+"_cld_highR.nc","r")
wvswkcld=file1->swkernel

lat=file1->lat
lon=file1->lon

file1      = addfile(dir2+"dp-highR.nc","r")
pt=file1->player
dp=file1->dp
plevel=file1->plevel

nlat=dimsizes(lat)
nlon=dimsizes(lon)
;*************************
file2      = "ta_ts_hus_clim."+model+"_"+expr2+"_"+member+".nc"
diri       = "/gs/project/atmrad/mzhang/abrupt4xco2/abrupt/data/" 
file3      = var1_name+"_"+var2_name+"_"+var3_name+"_anom."+model+"_"+expr1+"_"+member+".nc"
file4	=  "albedo_clr_anom."+model+"_"+expr1+"_"+member+".nc"
file5=	"albedo_anom."+model+"_"+expr1+"_"+member+".nc"

;========= anomaly
in1      = addfile(diri+file3,"r")   
taa      = in1->$var1_name$(nsum-n:nsum-1,:,:,:)
tsa      = in1->$var2_name$(nsum-n:nsum-1,:,:)

in1=addfile("/gs/project/atmrad/mzhang/abrupt4xco2/abrupt/lnq/data/ln_hus_anom."+model+"_abrupt4xCO2_r1i1p1_144x90.nc","r")
qa       = in1->$var3_name$(nsum-n:nsum-1,:,:,:)

in2	=addfile(diri+file4,"r")
alba	=100.*in2->albedo(nsum-n:nsum-1,:,:)
in2     =addfile(diri+file5,"r")
albclda    =100.*in2->albedo(nsum-n:nsum-1,:,:)

if(imodel.ne.0) then
lat1=in1->latitude
lon1=in1->longitude
else
lat1=in1->lat
lon1=in1->lon
end if

lev      = (in1->plev)/100.
nlat1=dimsizes(lat1)
nlon1=dimsizes(lon1)
nlev1=dimsizes(lev)

mta=linint2_Wrap(lon1,lat1,int2p_n_Wrap(lev,taa,pt,2,1),True,lon,lat(::-1),0)
mqa=linint2_Wrap(lon1,lat1,int2p_n_Wrap(lev,qa,pt,2,1),True,lon,lat(::-1),0)
mtsa=linint2_Wrap(lon1,lat1,tsa,True,lon,lat(::-1),0)
malba=linint2_Wrap(lon1,lat1,alba,True,lon,lat(::-1),0)
malbclda=linint2_Wrap(lon1,lat1,albclda,True,lon,lat(::-1),0)
mta=mta(:,:,::-1,:)
mqa=mqa(:,:,::-1,:)
mtsa=mtsa(:,::-1,:)
malba=malba(:,::-1,:)
malbclda=malbclda(:,::-1,:)

;;;;;;;;;;;;

;ps
a=addfile("/gs/project/ktg-565-aa/xxtan/data/cmip5/ps_mon."+model+"_"+expr1+"_"+member+".nc","r")
psmon1=a->ps
psmon1=psmon1/100.
psmon=linint2_Wrap(lon1,lat1,psmon1,True,lon,lat(::-1),0)
psmon=psmon(:,::-1,:)
;;;;;;;;;;;;;;;;;;;;;;;


;==== climatology
in2      = addfile(diri+file2,"r")  
Ta       = in2->$var1_name$(:,:,:,:)

mt=linint2_Wrap(lon1,lat1,int2p_n_Wrap(lev,Ta,pt,2,1),True,lon,lat(::-1),0)
mt=mt(:,:,::-1,:)

;*********** dr = kernel * dx ***********************
;%%%%%%%%%%%%%%%%% calculate dr%%%%%%%%%%%%%%%%%%
;%%% ln(q) && dln(qs)/dT = Lv/(Rv*T**2)
;%%% parameters
Rv = 487.5; ; gas constant of water vapor
Lv = 2.5e+06; ; latent heat of water vapor
ntime = 12; ; kernels are supposed to contain a full annual cycle

dr_tclr = new((/nyear,nlat,nlon/),float,mta@_FillValue)
drlw_qclr = new((/nyear,nlat,nlon/),float,mta@_FillValue)
dr_tcld=dr_tclr
drlw_qcld=drlw_qclr
drsw_qclr=drlw_qclr
drsw_qcld=drlw_qclr

dr_albclr=dr_tclr
dr_albcld=dr_albclr
dr_tsclr=dr_albclr
dr_tscld=dr_tsclr

dtsgm1=dr_tclr(:,0,0)
;****************************************
rad         = 4.0*atan(1.0)/180.0
clat1       = cos(lat*rad)

do iyear = 1, nyear

nst=(iyear-1)*12
ned=iyear*12-1

dq = mqa(nst:ned,:,:,:)*dlnws(mt)   ;*mt^2*Rv/Lv
dtsgm1(iyear-1)=dim_avg_n(wgt_areaave(mtsa(nst:ned,:,:),clat1,1.0,0),0)  ;time

;;;;;;;;;;;;;;;;;;;;;;;;
;calculate the depth of each layer (especially the lowest layer)
dps=conform(dq,dp,1)
dps=0.
sp=psmon(nst:ned,:,:)
dplow=dps(:,0,:,:) ;the lowest layer

do iti=0,11
do i=0,nlat-1
do j=0,nlon-1
if(.not.ismissing(sp(iti,i,j))) then

 indyp=min(ind(sp(iti,i,j)-pt.ge.0))
  dps(iti,indyp,i,j)=sp(iti,i,j)-plevel(indyp+1)
  dps(iti,indyp+1:,i,j)=dp(indyp+1:)
  dplow(iti,i,j)=sp(iti,i,j)-plevel(indyp+1)

end if
end do
end do
end do
dps=dps/100.
dplow=dplow/100.
;======== 

drlw_qclr(iyear-1,:,:) =  dim_sum_n(dim_avg_n(wvlwkclr*dq*dps,0),0)
drlw_qcld(iyear-1,:,:) =  dim_sum_n(dim_avg_n(wvlwkcld*dq*dps,0),0)
drsw_qclr(iyear-1,:,:) =  dim_sum_n(dim_avg_n(wvswkclr*dq*dps,0),0)
drsw_qcld(iyear-1,:,:) =  dim_sum_n(dim_avg_n(wvswkcld*dq*dps,0),0)

dr_tclr(iyear-1,:,:) =  dim_sum_n(dim_avg_n(tkclr(:,1:,:,:)*mta(nst:ned,:,:,:)*dps,0),0)+\
			dim_avg_n(tkclr(:,0,:,:)*mtsa(nst:ned,:,:)*dplow,0)
dr_tcld(iyear-1,:,:) =  dim_sum_n(dim_avg_n(tkcld(:,1:,:,:)*mta(nst:ned,:,:,:)*dps,0),0)+\
                        dim_avg_n(tkcld(:,0,:,:)*mtsa(nst:ned,:,:)*dplow,0)

dr_tsclr(iyear-1,:,:) =  dim_avg_n(tskclr*mtsa(nst:ned,:,:),0)
dr_tscld(iyear-1,:,:) =  dim_avg_n(tskcld*mtsa(nst:ned,:,:),0)
dr_albclr(iyear-1,:,:) =  dim_avg_n(albkclr*malba(nst:ned,:,:),0)
dr_albcld(iyear-1,:,:) =  dim_avg_n(albkcld*malbclda(nst:ned,:,:),0)
end do

dr_tclr!0 = "year"
dr_tclr!1 = "lat"
dr_tclr!2 = "lon"
dr_tclr@units="w/m2"

dr_tclr&lat  = lat
dr_tclr&lon  = lon


copy_VarCoords(dr_tclr,dr_tcld)
copy_VarCoords(dr_tclr,drlw_qclr)
copy_VarCoords(dr_tclr,drlw_qcld)
copy_VarCoords(dr_tclr,drsw_qclr)
copy_VarCoords(dr_tclr,drsw_qcld)
copy_VarCoords(dr_tclr,dr_tsclr)
copy_VarCoords(dr_tclr,dr_tscld)
copy_VarCoords(dr_tclr,dr_albclr)
copy_VarCoords(dr_tclr,dr_albcld)
end










