      PROGRAM  genbycd
c
c...Generate The List Of Fields To Process By CD (To Save Time)
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 10000
      CHARACTER*132
     *         lb, el(10)
      CHARACTER*6
     *         id(NMAX)
      CHARACTER*11
     *         cd(NMAX)
      CHARACTER*5
     *         prev
      CHARACTER*4
     *         cdname, test
      CHARACTER*2
     *         pri, sec, dst
      CHARACTER*1
     *         c
      INTEGER
     *         nlb, n, idx(NMAX), nx, ny, i, nn, f, j, nel(10)
c
 9001 FORMAT (q, a)
 9002 FORMAT (2i5)
 9003 FORMAT ('#', a)
 9004 FORMAT (a)
 9005 FORMAT (i4)
 9006 FORMAT (' RAW File To Remove [Null=none]: ' $)
c
c...Figure Out What To Do
c
  100 CALL getprisec(pri,sec)
      DO i=1,2
        c = pri(i:i)
        IF ((c.ge.'A').and.(c.le.'Z')) THEN
          c = CHAR(ICHAR(c)+32)
        ENDIF
        pri(i:i) = c
        c = sec(i:i)
        IF ((c.ge.'A').and.(c.le.'Z')) THEN
          c = CHAR(ICHAR(c)+32)
        ENDIF
        sec(i:i) = c
      ENDDO
      dst = pri(2:2)//sec(2:2)
      IF ((pri.eq.'so').or.(pri.eq.'se')) THEN
        cdname = 'p1cd'
      ELSEIF ((pri.eq.'uj').or.(pri.eq.'sj').or.(pri.eq.'sf')
     *    .or.(pri.eq.'sn')) THEN
        cdname = 'p2cd'
      ELSEIF ((pri.eq.'sb').or.(pri.eq.'sr').or.(pri.eq.'ao')) THEN
        cdname = 'sscd'
      ELSE
        cdname = 'nspm'
      ENDIF
c
c...Ingest CDROM Directory
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../../binary/cddir/'//cdname//'.dir',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002) nx,ny
      nn = 0
      DO j=1,ny
        DO i=1,nx
          READ (1,9001) nel(i),el(i)
        ENDDO
        IF ((nel(1).gt.20).and.(nel(2).gt.20)) THEN
          nn = nn+1
          cd(nn) = el(1)(16:20)//el(1)(22:27)
          id(nn) = el(1)(22:27)
          idx(nn) = nn
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Remove Those Already Done?
c
  115 WRITE (*,9006)
      READ  (*,9001) nlb,lb
      IF (nlb.gt.0) THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=115,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
  117   READ (1,9004,end=119) test
        DO i=1,LEN(test)
          IF (test(i:i).eq.' ') THEN
            test(i:i) = '0'
          ENDIF
        ENDDO
        DO i=1,nn
          IF (test.eq.id(i)(3:6)) THEN
            id(i) = '      '
            GO TO 117
          ENDIF
        ENDDO
        GO TO 117
  119   CLOSE (1)
        j = 0
        DO i=1,nn
          IF (id(i)(1:1).ne.' ') THEN
            j = j+1
            cd(j) = cd(i)
            id(j) = id(i)
            idx(j) = j
          ENDIF
        ENDDO
        nn = j
      ENDIF
c
c...Sort On CD
c
      CALL quqsrt(nn,cd,idx)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='bycd.lis',
     *      status='unknown',
     *      unit=1
     *     )
      prev = '     '
      DO i=1,nn
        IF (cd(i)(1:5).ne.prev) THEN
          WRITE (1,9003) cd(i)
          prev = cd(i)(1:5)
        ENDIF
        WRITE (1,9004) id(idx(i))
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
