      SUBROUTINE  poss1load(id,who)
c
c...Look In Database To Fill In Exposure Info
c
      INCLUDE
     *            'proc.inc'
      PARAMETER
     *            palomar = 33.357D00
      CHARACTER*(*)
     *            id
      DOUBLE PRECISION
     *            a, b, c, czd, x, y, z, r, d, h, e, t
      INTEGER
     *            nlb, field, i, who, ix, iy, j, year, month, day
      CHARACTER*132
     *            lb
      CHARACTER*3
     *            mm, mmlist(12)
      DATA
     *   mmlist/'JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN',
     *          'JUL', 'AUG', 'SEP', 'OCT', 'NOV', 'DEC'/
c
 9001 FORMAT (q, a)
 9002 FORMAT (i4)
 9003 FORMAT (2i2, f2.0)
 9004 FORMAT (f1.0, 1x, f2.0)
 9005 FORMAT (' Fatal Error', 5(' >>', a, '<<'))
 9006 FORMAT (i2, a, i2)
 9007 FORMAT (2f2.0, 1x)
 9008 FORMAT (f3.0)
c
c...Open Catalog
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../tycho/possi.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=77
     *     )
      READ (77,9001)
      IF (who.eq.1) THEN
        DO i=1,NFDIM
          ra1(i) = 0.0D00
          dec1(i) = 0.0D00
          ha1(i) = 0.0D00
          zd1(i) = 0.0D00
          yy1(i) = 0
          mm1(i) = 0
          dd1(i) = 0
          ut1(i) = 0.0D00
        ENDDO
      ELSE
        DO i=1,NFDIM
          ra2(i) = 0.0D00
          dec2(i) = 0.0D00
          ha2(i) = 0.0D00
          zd2(i) = 0.0D00
          yy2(i) = 0
          mm2(i) = 0
          dd2(i) = 0
          ut2(i) = 0.0D00
        ENDDO
      ENDIF
      radian = 45.0D00/ATAN(1.0D00)
c
c...Read And Keep Only Our Entries
c
  110 READ (77,9001,err=110,end=130) nlb,lb
      IF (nlb.le.0) GO TO 110
      IF (lb(70:70).ne.id(2:2)) GO TO 110
      READ (lb(3:6),9002,err=200) field
      READ (lb(30:35),9003,err=200) ix,iy,z
      CALL sla_DTF2R(ix,iy,z, r,j)
      READ (lb(38:43),9003,err=200) ix,iy,z
      CALL sla_DAF2R(ix,iy,z, d,j)
      IF (lb(37:37).eq.'-') THEN
        d = -d
      ENDIF
      READ (lb(84:87),9004,err=200) x,y
      h = x + y/60.0D00
      IF (lb(88:88).eq.'E') THEN
        h = -h
      ENDIF
      READ (lb(24:28),9007) x,y
      READ (lb(80:82),9008) z
      t = x + y/60.0D00 + z/120.0D00
c
c...Compute Epoch
c
      READ (lb(16:22),9006,err=200) day,mm,year
      DO i=1,12
        IF (mm.eq.mmlist(i)) THEN
          month = i
          GO TO 120
        ENDIF
      ENDDO
      GO TO 200
c
c...Compute ZD
c
  120 b = 90.0D00 - PALOMAR
      c = 90.0D00 - d*radian
      czd = COSD(b)*COSD(c) + SIND(b)*SIND(c)*COSD(h*15.0D00)
      z = ACOSD(czd)
c
c...Copy Into Storage Buffers
c
      IF (who.eq.1) THEN
        ra1(field) = r
        dec1(field) = d
        ha1(field) = h
        yy1(field) = year
        mm1(field) = month
        dd1(field) = day
        zd1(field) = z
        ut1(field) = t
      ELSE
        ra2(field) = r
        dec2(field) = d
        ha2(field) = h
        yy2(field) = year
        mm2(field) = month
        dd2(field) = day
        zd2(field) = z
        ut2(field) = t
      ENDIF
      GO TO 110
  130 CLOSE (77)
      RETURN
c
c...Problems
c
  200 WRITE (*,9005) lb(3:6),lb(30:35),lb(37:43),lb(84:88),lb(16:22)
      CLOSE (77)
      CALL EXIT
      END
