      SUBROUTINE  slasurvey(id,emul,obs_long,obs_lat,obs_elev,
     *                      obs_wave,obs_scale,obs_disco)
c
c...Observatory Specific Part Of SLALIB Setup
c
      IMPLICIT
     *            NONE
      PARAMETER
     *            pal_long = -(116.0D00 + 51.8D00/60.0D00),
     *            pal_lat = (33.0D00 + 21.4D00/60.0D00),
     *            pal_elev = 1706.0D00,
     *            pal_scale = 67.18D00,
     *            aao_long = 149.07D00,
     *            aao_lat = -31.27D00,
     *            aao_elev = 1130.0D00,
     *            aao_scale = 67.18D00,
     *            eso_long =  -(70.0D00 + 43.8D00/60.0D00),
     *            eso_lat = -(29.0D00 + 15.4D00/60.0D00),
     *            eso_elev = 2347.0D00,
     *            eso_scale = 67.18D00,
     *            lick_long =  -(121.0D00 + 38.2D00/60.0D00),
     *            lick_lat = (37.0D00 + 20.6D00/60.0D00),
     *            lick_elev = 1290.0D00,
     *            lick_scale = 55.10D00
      PARAMETER
     *            pal_disco = -0.3333D00,
     *            aao_disco = -0.3333D00,
     *            eso_disco = -0.3333D00,
     *            lick_disco = 0.0D00
      INTEGER
     *            id
      CHARACTER*2
     *            emul
      DOUBLE PRECISION
     *            obs_long, obs_lat, obs_elev, obs_wave, obs_scale,
     *            obs_disco
c
c...These Are Palomar I
c
  100 IF ((emul.eq.'SO').or.(emul.eq.'SE')) THEN
        obs_long = PAL_LONG
        obs_lat = PAL_LAT
        obs_elev = PAL_ELEV
        obs_scale = PAL_SCALE
        obs_disco = PAL_DISCO
        IF (emul.eq.'SE') THEN
          obs_wave = 0.65D00
        ELSE
          obs_wave = 0.41D00
        ENDIF
c
c...These Are Palomar II
c
      ELSEIF ((emul.eq.'UJ').or.(emul.eq.'SJ').or.(emul.eq.'SF')
     *    .or.(emul.eq.'SN')) THEN
        obs_long = PAL_LONG
        obs_lat = PAL_LAT
        obs_elev = PAL_ELEV
        obs_scale = PAL_SCALE
        obs_disco = PAL_DISCO
        IF (emul.eq.'SN') THEN
          obs_wave = 0.85D00
        ELSEIF (emul.eq.'SF') THEN
          obs_wave = 0.65D00
        ELSE
          obs_wave = 0.48D00
        ENDIF
c
c...These Are Southern Surveys
c
      ELSEIF ((emul.eq.'SB').or.(emul.eq.'SR').or.(emul.eq.'AO')) THEN
        IF ((emul.eq.'SR').and.(id.le.606)) THEN
          obs_long = ESO_LONG
          obs_lat = ESO_LAT
          obs_elev = ESO_ELEV
          obs_scale = ESO_SCALE
          obs_disco = ESO_DISCO
        ELSE
          obs_long = AAO_LONG
          obs_lat = AAO_LAT
          obs_elev = AAO_ELEV
          obs_scale = AAO_SCALE
          obs_disco = AAO_DISCO
        ENDIF
        IF (emul.eq.'SR') THEN
          obs_wave = 0.65D00
        ELSE
          obs_wave = 0.48D00
        ENDIF
c
c...These Are Lick Surveys
c
      ELSEIF ((emul.eq.'NA').or.(emul.eq.'NB').or.(emul.eq.'NY')) THEN
        obs_long = LICK_LONG
        obs_lat = LICK_LAT
        obs_elev = LICK_ELEV
        obs_scale = LICK_SCALE
        obs_disco = LICK_DISCO
        IF (emul.eq.'NY') THEN
          obs_wave = 0.54D00
        ELSE
          obs_wave = 0.42D00
        ENDIF
c
c...Problem
c
      ELSE
        STOP 'SLASURVEY'
      ENDIF
      RETURN
      END
