      PROGRAM  summary
c
c...Look At RAW File And Print Various Neat Things
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 2000,
     *         bperp = (1394.0D00*1037.0D00*588.0D00*2.0D00)
      INTEGER
     *         found(NMAX), id, npair, nmin, crazy, notpair, n1, n2,
     *         ndone, n1sum, n2sum, npsum, i, idmax, m1, m2, m1sum,
     *         m2sum, dn1, dn2, idden, nden, b, mpair, nlb
      REAL
     *         sigmax, sigmay, fract, ra, dec, ha, ep, ut, zd, lon,
     *         lat, alat, x, y
      DOUBLE PRECISION
     *         psum
      CHARACTER*2
     *         pri, sec, dst
      CHARACTER*1
     *         c
      CHARACTER*64
     *         lb
c
 9001 FORMAT (i4, i8, 2f6.2, i8, f6.1, 4f8.3, 2f7.3, i5, i8, 2f8.3,
     *        2i8)
 9002 FORMAT (' ', i4, ' Is Not Unique')
 9003 FORMAT (' ', i4, ' Is Missing')
 9004 FORMAT (' ', a, '+', a, '= ', i4, ' (', f4.0, '%)  N(pair)=',
     * i10, '  N(', a, ')=', i10, '  N(', a, ')=', i10)
 9005 FORMAT (i4, 8i8, 2f8.3)
 9006 FORMAT (' Count ID=', i4, '  FOUND=', i1)
 9007 FORMAT (' N(', a, ')=', i10, '  N(', a, ')=', i10)
 9008 FORMAT (' Number of Pixels=', f20.1)
 9009 FORMAT (' Densest ID=', i4, '   NP=', i12)
 9010 FORMAT (' Million+ Pair Fields=', i4)
 9011 FORMAT (' ', i4, ' Fields Remain')
c
c...Figure Out What To Do
c
  100 CALL getprisec(pri,sec)
      DO i=1,2
        c = pri(i:i)
        IF ((c.ge.'A').and.(c.le.'Z')) THEN
          c = CHAR(ICHAR(c)+32)
        ENDIF
        pri(i:i) = c
        c = sec(i:i)
        IF ((c.ge.'A').and.(c.le.'Z')) THEN
          c = CHAR(ICHAR(c)+32)
        ENDIF
        sec(i:i) = c
      ENDDO
      dst = pri(2:2)//sec(2:2)
      lb = 'taff'//dst//'.raw'
      nlb = 10
c
c...Initialization
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      DO i=1,NMAX
        found(i) = 0
      ENDDO
      idmax = 0
      ndone = 0
      n1sum = 0
      n2sum = 0
      npsum = 0
      psum = 0.0D00
      idden = 0
      nden = 0
      mpair = 0
c
c...Read Each Line
c
  110 READ (1,9001,end=120) id,npair,sigmax,sigmay,nmin,fract,ra,dec,
     *                      ha,ep,ut,zd,crazy,notpair,lon,lat,n1,n2
      IF (found(id).ne.0) THEN
        WRITE (*,9002) id
        ndone = ndone-1
      ENDIF
      found(id) = 1
      idmax = MAX(idmax,id)
      npsum = npsum + npair
      n1sum = n1sum + n1
      n2sum = n2sum + n2
      ndone = ndone + 1
      psum = psum+BPERP
      IF (npair.gt.nden) THEN
        nden = npair
        idden = id
      ENDIF
      IF (npair.ge.1000000) THEN
        mpair = mpair+1
      ENDIF
      GO TO 110
c
c...All Done
c
  120 CLOSE (1)
      DO i=1,idmax
        IF (found(i).eq.0) THEN
          WRITE (*,9003) i
        ENDIF
      ENDDO
      x = 100.0*ndone/937.0
      WRITE (*,9004) pri,sec,ndone,x,npsum, pri,n1sum,sec,n2sum
      WRITE (*,9008) psum
      WRITE (*,9009) idden,nden
      WRITE (*,9010) mpair
      i = 937-ndone
      WRITE (*,9011) i
c
c...Use SYSTEM To Sort List
c
      CALL system(' sort -n '//lb(1:nlb)//' >x')
      CALL system(' cp x '//lb(1:nlb))
      CALL EXIT
      END
