      SUBROUTINE  zfit(nn,xx,yy,zz, cc,sc,se)
c
c...Least Squares Fit To A Plane
c
      INCLUDE
     *            'magover.inc'
      INTEGER
     *            nn, i, j, k, ising
      DOUBLE PRECISION
     *            xx(*), yy(*), zz(*), cc(*), sc(*), se, zc, zr, chisq
c
 9001 FORMAT (i2, 2(1x,pe13.6, '+/-', 1pe10.3))
c
c...Initialization
c
  100 ncoef = 6
      DO i=1,ncoef
        zlhs(i) = 0.0D00
        cc(i) = 0.0D00
        DO j=1,ncoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
c
c...Accumulation
c
      DO i=1,nn
        dv(1) = 1.0D00
        dv(2) = xx(i)
        dv(3) = yy(i)
        dv(4) = xx(i)*xx(i)
        dv(5) = xx(i)*yy(i)
        dv(6) = yy(i)*yy(i)
        DO j=1,ncoef
          zlhs(j) = zlhs(j) + dv(j)*zz(i)
          DO k=1,ncoef
            zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
          ENDDO
        ENDDO
      ENDDO
c
c...Inversion
c
      CALL matinv(ising)
      IF (ising.ne.0) THEN
        STOP 'Singular Matrix In ZFIT'
      ENDIF
c
c...Coefficients
c
      DO i=1,ncoef
        DO j=1,ncoef
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Errors
c
      DO i=1,nn
        dv(1) = 1.0D00
        dv(2) = xx(i)
        dv(3) = yy(i)
        dv(4) = xx(i)*xx(i)
        dv(5) = xx(i)*yy(i)
        dv(6) = yy(i)*yy(i)
        zc = 0.0D00
        DO j=1,3
          zc = zc + dv(j)*cc(j)
        ENDDO
        zr = zz(i)-zc
        chisq = chisq + zr*zr
      ENDDO
      se = SQRT(chisq/(nn-(ncoef+1)))
      DO i=1,ncoef
        sc(i) = se*SQRT(zrhs(i,i))
      ENDDO
      DO i=1,ncoef
c       WRITE (*,9001) i,cc(i),sc(i)
      ENDDO
      RETURN
      END
