      PROGRAM  genbycd
c
c...Generate The List Of Fields To Process By CD (To Save Time)
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 10000,
     *         nkmax = 100
      CHARACTER*132
     *         lb
      CHARACTER*8
     *         fn
      CHARACTER*6
     *         id(NMAX), kill(NKMAX), qk
      CHARACTER*11
     *         cd(NMAX)
      CHARACTER*5
     *         prev
      CHARACTER*2
     *         key
      CHARACTER*1
     *         c
      INTEGER
     *         nlb, n, idx(NMAX), nx, ny, i, nn, done(NMAX), j, nkill
c
 9001 FORMAT (q, a)
 9002 FORMAT (2i5)
 9003 FORMAT ('#', a)
 9004 FORMAT (a)
 9005 FORMAT (' Enter Prefix: ' $)
 9006 FORMAT (' Unknown Key >>', a, '<<')
 9007 FORMAT (i4)
 9008 FORMAT (' Enter SG0/1 Directory: ' $)
 9009 FORMAT (a, i4.4)
 9010 FORMAT (' Omit Existing Solutions (y/n)? ' $)
 9011 FORMAT (' Cannot Remove ', i4, '  May Be Duplicate')
 9012 FORMAT (' NKILL=', i3)
c
c...Figure Out What To Do
c
  100 WRITE (*,9005)
      READ  (*,9004) key
      IF ((key.eq.'na').or.(key.eq.'nb').or.(key.eq.'ny')) THEN
        fn = 'nspm.dir'
      ELSEIF ((key.eq.'so').or.(key.eq.'se')) THEN
        fn = 'p1cd.dir'
      ELSEIF ((key.eq.'uj').or.(key.eq.'sj').or.(key.eq.'sn')
     *    .or.(key.eq.'sf')) THEN
        fn = 'p2cd.dir'
      ELSEIF ((key.eq.'sb').or.(key.eq.'sr').or.(key.eq.'ao')) THEN
        fn = 'sscd.dir'
      ELSE
        WRITE (*,9006) key
        GO TO 100
      ENDIF
      DO i=1,NMAX
        done(i) = 0
      ENDDO
c
c...Reak KILL File
c
      nkill = 0
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=106,
     *      form='formatted',
     *      name='bycd.kill',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
  102 READ (1,9004,end=104) qk
      nkill = nkill+1
      kill(nkill) = qk
      GO TO 102
  104 CLOSE (1)
  106 WRITE (*,9012) nkill
c
c...Ingest CDROM Directory
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../../binary/cddir/'//fn,
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9002) nx,ny
      n = nx*ny
      nn = 0
      DO i=1,n
        READ (1,9001) nlb,lb
        IF (lb(1:2).eq.key) THEN
          IF (nlb.eq.32) THEN
            DO j=1,nkill
              IF (lb(22:27).eq.kill(j)) GO TO 108
            ENDDO
            nn = nn+1
            cd(nn) = lb(16:20)//lb(22:27)
            id(nn) = lb(22:27)
            idx(nn) = nn
            READ (lb(24:27),9007) done(nn)
  108       CONTINUE
          ENDIF
        ENDIF
      ENDDO
      CLOSE (1)
c
c...Add Those In Directories
c
  110 WRITE (*,9008)
      READ  (*,9001) nlb,lb
      IF (nlb.eq.3) THEN
        CALL system('\ls /ue0/xpmm/'//lb(1:nlb)//
     *               '/*a.inf  >genbycd.inp')
        CALL system('\ls /ue1/xpmm/'//lb(1:nlb)//
     *               '/*a.inf >>genbycd.inp')
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=110,
     *        form='formatted',
     *        name='genbycd.inp',
     *        status='old',
     *        unit=1
     *       )
  120   READ (1,9001,end=130) nlb,lb
        IF (nlb.le.9) GO TO 120
        IF (lb(nlb-10:nlb-9).ne.key) GO TO 120
        IF (lb(nlb-4:nlb).ne.'a.inf') GO TO 120
        nn = nn+1
        cd(nn) = '           '
        id(nn) = lb(nlb-10:nlb-5)
        idx(nn) = nn
        READ(lb(nlb-8:nlb-5),9007) done(nn)
        GO TO 120
  130   CLOSE (1)
        GO TO 110
      ENDIF
c
c...Omit
c
      WRITE (*,9010)
      READ  (*,9004) c
      IF (c.eq.'y') THEN
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='realtaff'//key//'.raw',
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
  140   READ (1,9007,end=150) j
        DO i=1,nn
          IF (done(i).eq.j) THEN
            done(i) = 0
            GO TO 140
          ENDIF
        ENDDO
        WRITE (*,9011) j
        GO TO 140
  150   CLOSE (1)
        j = 0
        DO i=1,nn
          IF (done(i).ne.0) THEN
            j = j+1
            cd(j) = cd(i)
            id(j) = id(i)
            idx(j) = j
            done(j) = done(i)
          ENDIF
        ENDDO
        nn = j
      ENDIF
c
c...Sort On CD
c
      CALL quqsrt(nn,cd,idx)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='bycd.lis',
     *      status='unknown',
     *      unit=1
     *     )
      prev = '     '
      DO i=1,nn
        IF (cd(i)(1:5).ne.prev) THEN
          WRITE (1,9003) cd(i)
          prev = cd(i)(1:5)
        ENDIF
        WRITE (1,9004) id(idx(i))
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
