      SUBROUTINE  getccd
c
c...Compute True CCD Pixel Location
c
      INCLUDE
     *            'tbproc.inc'
      PARAMETER
     *            tol = 2,
     *            itmax = 5
      INTEGER
     *            px, py, nn, ixl, iyl, ixh, iyh, ixt, iyt, ix, iy,
     *            i, j, rx, ry, iter, nfail
      REAL
     *            xl, yl, xh, yh, xn, xd, yn, yd, fx, fy, x, y,
     *            qx, qy
c
 9001 FORMAT ('NFAIL=', i10, ' For ', a)
c
c...Crack CCD Pixel Coordinates And Create Fake X,Y
c
  100 nfail = 0
      DO i=1,n2
        j = ccdq(i)
        nn = j/NPIXELS
        j = j - nn*NPIXELS
        py = j/NCOLS
        px = j - py*NCOLS
        ixt = x2(i)
        iyt = y2(i)
c
c...Assume Truncated Part Was 0
c
        xl = px+0.5
        yl = py+0.5
        qx = xl
        qy = yl
        CALL dzapply(qx,qy)
        CALL scapply(nn,qx,qy,ixl,iyl)
c
c...Assume Truncated Part Was 1
c
        xh = px+1.5
        yh = py+1.5
        qx = xh
        qy = yh
        CALL dzapply(qx,qy)
        CALL scapply(nn,qx,qy,ixh,iyh)
c
c...See How To Improve
c
        iter = 0
  110   iter = iter+1
        xn = ixt-ixl
        xd = ixh-ixl
        fx = xn/xd
        yn = iyt-iyl
        yd = iyh-iyl
        fy = yn/yd
        x = xl + fx*(xh-xl)
        y = yl + fy*(yh-yl)
        qx = x
        qy = y
        CALL dzapply(qx,qy)
        CALL scapply(nn,qx,qy,ix,iy)
        rx = ix-ixt
        ry = iy-iyt
        IF (ix.gt.ixt) THEN
          xh = x
          ixh = ix
        ELSE
          xl = x
          ixl = ix
        ENDIF
        IF (iy.gt.iyt) THEN
          yh = y
          iyh = iy
        ELSE
          yl = y
          iyl = iy
        ENDIF
        IF (iter.le.ITMAX) THEN
          IF ((ABS(rx).gt.TOL).or.(ABS(ry).gt.TOL)) GO TO 110
        ELSE
          nfail = nfail+1
        ENDIF
c
c...Save The Answer
c
        ccdx(i) = x
        ccdy(i) = y
        ccdd(i) = d2(i)
        ccdo(i) = o2(i)
        ccdq(i) = nn
      ENDDO
      IF (nfail.gt.5) THEN
        OPEN (
     *        access='append',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name='realquiet.log',
     *        status='unknown',
     *        unit=1
     *       )
        WRITE (1,9001) nfail,fn2(nfn2-6:nfn2)
        CLOSE (1)
      ENDIF
      RETURN
      END
