      SUBROUTINE  magfit(dochop, zcoef,szcoef,sigmaz, err)
c
c...Least Squares Fit To Magnitude Transformation
c
      INCLUDE
     *            'tbproc.inc'
      DOUBLE PRECISION
     *            zcoef(*), szcoef(*), sigmaz, x, y, z, chisq, zc,
     *            zr, m, dv(NCMAX), qrhs(NCMAX,NCMAX)
      INTEGER
     *            i, j, k, nn, ising, err, dochop
c
 9001 FORMAT (' Singular Matrix In MAGFIT')
c
c...Initialization
c
  100 DO i=1,nmcoef
        zlhs(i) = 0.0D00
        DO j=1,nmcoef
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0
      sigmaz = SANITYTAG
      nn = 0
c
c...Accumulation
c
      DO i=1,npair
        IF ((dochop.eq.0).or.(tmp(i).ne.0)) THEN
          x = d2(pair2(i)) + vigmag(i)
          z = d1(pair1(i))
          CALL magdv(x,z,dv)
          DO j=1,nmcoef
            zlhs(j) = zlhs(j) + dv(j)*z
            DO k=1,nmcoef
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
            ENDDO
          ENDDO
          nn = nn+1
        ENDIF
      ENDDO
c
c...Inversion And Coefficients
c
c	WARNING.  If there were no bright stars, this inversion will fail.
c		Extra logic solves for the fainter piece of the transformation.
c
      DO j=1,nmcoef
        DO i=1,nmcoef
          qrhs(i,j) = zrhs(i,j)
        ENDDO
      ENDDO
      CALL matinv(nmcoef,ising)
      IF (ising.eq.0) THEN
        DO i=1,nmcoef
          zcoef(i) = 0.0D00
          DO j=1,nmcoef
            zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
          ENDDO
        ENDDO
      ELSE
        DO i=3,4
          zlhs(i-2) = zlhs(i)
          DO j=3,4
            zrhs(i-2,j-2) = qrhs(i,j)
          ENDDO
        ENDDO
        CALL matinv(2,ising)
        IF (ising.ne.0) THEN
          WRITE (*,9001)
          err = -115
          RETURN
        ENDIF
        DO i=1,2
          zcoef(i) = 0.0D00
          DO j=1,2
            zcoef(i) = zcoef(i) + zrhs(i,j)*zlhs(j)
          ENDDO
        ENDDO
        zcoef(3) = zcoef(1)
        zcoef(4) = zcoef(2)
        DO i=3,4
          zrhs(i,i) = zrhs(i-2,i-2)
        ENDDO
      ENDIF
c
c...Residuals And ChiSquared
c
      DO i=1,npair
        x = d2(pair2(i)) + vigmag(i)
        z = d1(pair1(i))
        CALL magdv(x,z,dv)
        zc = 0.0D00
        DO j=1,nmcoef
          zc = zc + zcoef(j)*dv(j)
        ENDDO
        zr = z-zc
        IF ((dochop.eq.0).or.(tmp(i).ne.0)) THEN
          chisq = chisq + zr*zr
        ENDIF
        tmp(i) = ABS(zr)+0.5D00
      ENDDO
      sigmaz = SQRT(chisq/(nn-(nmcoef+1)))
c
c...Errors
c
      DO i=1,nmcoef
        szcoef(i) = sigmaz*SQRT(zrhs(i,i))
      ENDDO
c
c...Convert To User's Units
c
      sigmaz = 0.01D00*sigmaz
      err = nn
      RETURN
      END
