      SUBROUTINE  magproc(id)
c
c...Compute Preliminary Mapping
c
      INCLUDE
     *            'tbproc.inc'
      INTEGER
     *            i, dochop, m1, m2, err, id, nlb
      CHARACTER*64
     *            lb
c
 9004 FORMAT (4i10, f10.2, 2i10)
 9005 FORMAT (i2, 2(1x,1pe15.8))
c
 9001 FORMAT (' Fatal Error In MAGPROC ', i10)
c
c...Simple Test If Nothing To Do
c
  100 minmag = 600
      midmag = 800
      maxmag = 1299
      nmcoef = 4
      dochop = 100
      CALL usevignette
c
c...First Guess Is To Chop All Unreasonable Values
c
      DO i=1,npair
        m1 = d1(pair1(i))
        m2 = d2(pair2(i))
        IF ((m1.lt.minmag).or.(m1.gt.maxmag)) THEN
          idx(i) = 0
        ELSEIF ((m2.lt.500).or.(m2.gt.2200)) THEN
          idx(i) = 0
        ELSE
          idx(i) = 1
        ENDIF
        tmp(i) = idx(i)
      ENDDO
      IF (nmcoef.le.1) THEN
        CALL magbar(dochop, mcoef,smcoef,sigmam, err)
      ELSE
        CALL magfit(dochop, mcoef,smcoef,sigmam, err)
      ENDIF
      IF (err.lt.0) GO TO 200
c
c...Second Iteration Is A Sanity Test On The Residuals
c
      DO i=1,npair
        IF (tmp(i).lt.dochop) THEN
          tmp(i) = idx(i)
        ELSE
          tmp(i) = 0
        ENDIF
      ENDDO
      IF (nmcoef.le.1) THEN
        CALL magbar(dochop, mcoef,smcoef,sigmam, err)
      ELSE
        CALL magfit(dochop, mcoef,smcoef,sigmam, err)
      ENDIF
      IF (err.lt.0) GO TO 200
c
c...Third Iteration Is Based On Sigma
c
      dochop = 300.0D00*sigmam
      DO i=1,npair
        IF (tmp(i).lt.dochop) THEN
          tmp(i) = idx(i)
        ELSE
          tmp(i) = 0
        ENDIF
      ENDDO
      IF (nmcoef.le.1) THEN
        CALL magbar(dochop, mcoef,smcoef,sigmam, err)
      ELSE
        CALL magfit(dochop, mcoef,smcoef,sigmam, err)
      ENDIF
      IF (err.lt.0) GO TO 200
c
c...Save The Results
c
      CALL f_doenv(fnout(1:nfnout)//'.phx',nlb,lb)
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name=lb(1:nlb),
     *      status='unknown',
     *      unit=1
     *     )
      WRITE (1,9004) nmcoef,minmag,maxmag,midmag,sigmam,err,dovignette
      DO i=1,nmcoef
        WRITE (1,9005) i,mcoef(i),smcoef(i)
      ENDDO
      CLOSE (1)
      err = 0
      RETURN
c
c...Some Sort Of Error
c
  200 nmcoef = 0
      WRITE (*,9001) err
      RETURN
      END
