      PROGRAM  zetahist
c
c...Histogram Of Changes In Zeta
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nbin = 20,
     *         round = 25
      REAL
     *         xbin(NBIN), zbin(NBIN), xmin, xmax, ymin, ymax, z, z0
      INTEGER
     *         low, high, j, nlb, in
      CHARACTER*64
     *         lb
c
 9001 FORMAT (5x, f8.3, 48x, f8.3)
 9002 FORMAT (' Enter ZETA File: ' $)
 9003 FORMAT (q, a)
 9004 FORMAT (' N(in) = ', i3, '  N(low)=', i3, '  N(high)=', i3)
c
  100 WRITE (*,9002)
      READ  (*,9003) nlb,lb
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=110,
     *      form='formatted',
     *      name=lb(1:nlb),
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      in = 0
      low = 0
      high = 0
      DO j=1,NBIN
        zbin(j) = 0.0
      ENDDO
c
  110 READ (1,9001,end=120) z0,z
      j = 10.0*(z-z0) + 11.0
      IF (j.lt.1) THEN
        low = low+1
      ELSEIF (j.gt.NBIN) THEN
        high = high+1
      ELSE
        in = in+1
        zbin(j) = zbin(j)+1.0
      ENDIF
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9004) in,low,high
c
      ymin = 0.0
      ymax = zbin(1)
      DO j=1,NBIN
        xbin(j) = -0.95 + 0.1*(j-1)
        ymax = MAX(ymax,zbin(j))
      ENDDO
      j = (ymax-1.0)/ROUND
      ymax = (j+1)*ROUND
      xmin = xbin(1)-0.05
      xmax = xbin(NBIN)+0.05
      CALL mgoinit
      CALL mgosetup(-6)
      CALL mgoerase
      CALL mgosetlim(xmin,ymin,xmax,ymax)
      CALL mgobox(1,1)
      CALL mgoxlabel(nlb,lb(1:nlb))
      CALL mgohistogram(xbin,zbin,NBIN)
      CALL mgoprntplot(j)
      CALL EXIT
      END
