      SUBROUTINE  oebar(id,np,p1,p2, n1,x1,y1, n2,x2,y2, err)
c
c...Remove Mean Difference Between Blue And Red.  Assume Blue Is Correct
c
      INCLUDE
     *            'ugap012.inc'
      PARAMETER
     *            half = 180*3600*100,
     *            circle = (2*half)
      INTEGER
     *            id, np, p1(*), p2(*), n1, x1(*), y1(*), n2, x2(*),
     *            y2(*), i1, i2, i, err, x, y
      DOUBLE PRECISION
     *            sx, sy, sd, dx, dy
c
 9001 FORMAT (' OEBAR Field ', i4, ' Removed <X>=', f6.2, '  <Y>=',
     *        f6.2, ' arcsec')
 9002 FORMAT (' Illegal OEPAIRS Index', 4i10)
c
c...Compute
c
  100 sx = 0.0D00
      sy = 0.0D00
      sd = 0.0D00
      DO i=1,np
        i1 = p1(i)
        IF ((i1.lt.1).or.(i1.gt.n1)) THEN
          WRITE (*,9002) i,i1,i2,n1
          err = -30
          RETURN
        ENDIF
        i2 = p2(i)
        IF ((i2.lt.1).or.(i2.gt.n2)) THEN
          WRITE (*,9002) i,i1,i2,n2
          err = -31
          RETURN
        ENDIF
        dx = x1(i1)-x2(i2)
        dy = y1(i1)-y2(i2)
        IF (dx.lt.-HALF) THEN
          dx = dx+CIRCLE
        ELSEIF (dx.gt.HALF) THEN
          dx = dx-CIRCLE
        ENDIF
        sx = sx + dx
        sy = sy + dy
        sd = sd + y1(i1)
      ENDDO
      sx = sx/np
      sy = sy/np
      sd = sd/np
c
c...Apply
c
      DO i=1,np
        i2 = p2(i)
        x = x2(i2)+sx
        IF (x.lt.0) THEN
          x = x+CIRCLE
        ELSEIF (x.ge.CIRCLE) THEN
          x = x-CIRCLE
        ENDIF
        y = y2(i2)+sy
        x2(i2) = x
        y2(i2) = y
      ENDDO
c
c...Tell User
c
      sx = COSD(sd/360000.0D00-90.0D00)*sx/100.0D00
      sy = sy/100.0D00
      WRITE (*,9001) id,sx,sy
      WRITE (10,9001) id,sx,sy
      err = 0
      RETURN
      END
