      SUBROUTINE  correlate(bb,ff, nc,cc,sc,sigma, fn)
c
c...Use Calibrated Fields To Derive ZeroPoint Correlation
c
      INCLUDE
     *            'ugapea.inc'
      PARAMETER
     *            test = 3.0D00
      CHARACTER*(*)
     *            fn
      DOUBLE PRECISION
     *            bb(4,NMAX), ff(6,NMAX), cc(*), sc(*), sigma,
     *            xx(NMAX), yy(NMAX), x, y, yr, yc, chisq, rr(NMAX)
      INTEGER
     *            nc, nn, i, j, k, ising, id(NMAX), in(NMAX), iter, nin
c
 9001 FORMAT (' Singular Matrix In CORRELATE')
 9002 FORMAT (i5, 4f10.2, i5)
 9003 FORMAT (i5, f10.2, i5)
 9004 FORMAT (i5, 2(1x,1pe15.8))
c
c...Extraction
c
  100 nn = 0
      DO i=1,NMAX
        DO j=1,4
          IF (bb(j,i).eq.TAG) GO TO 110
        ENDDO
        DO j=1,6
          IF (ff(j,i).eq.TAG) GO TO 110
        ENDDO
        nn = nn+1
        xx(nn) = bb(1,i)
        yy(nn) = ff(1,i)
        id(nn) = i
        rr(nn) = 0.0D00
  110   CONTINUE
      ENDDO
c
c...Loop
c
      DO iter=1,2
        DO i=1,nn
          IF (rr(i).le.TEST) THEN
            in(i) = 1
          ELSE
            in(i) = 0
          ENDIF
        ENDDO
c
c...Initialization
c
        DO i=1,nc
          zlhs(i) = 0.0D00
          cc(i) = 0.0D00
          DO j=1,nc
            zrhs(i,j) = 0.0D00
          ENDDO
        ENDDO
        chisq = 0.0D00
c
c...Accumulation
c
        nin = 0
        DO i=1,nn
          IF (in(i).ne.0) THEN
            nin = nin+1
            x = xx(i)
            y = yy(i)
            dv(1) = 1.0D00
            DO j=2,nc
              dv(j) = dv(j-1)*x
            ENDDO
            DO j=1,nc
              zlhs(j) = zlhs(j) + dv(j)*y
              DO k=1,nc
                zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)
              ENDDO
            ENDDO
          ENDIF
        ENDDO
c
c...Inversion
c
        CALL matinv(nc,ising)
        IF (ising.ne.0) THEN
          WRITE (*,9001)
          CALL EXIT
        ENDIF
c
c...Coefficients
c
        DO i=1,nc
          DO j=1,nc
            cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
          ENDDO
        ENDDO
c
c...Residuals And Chisquared
c
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=fn,
     *        status='unknown',
     *        unit=1
     *       )
        DO i=1,nn
          x = xx(i)
          y = yy(i)
          dv(1) = 1.0D00
          DO j=2,nc
            dv(j) = dv(j-1)*x
          ENDDO
          yc = 0.0D00
          DO j=1,nc
            yc = yc + dv(j)*cc(j)
          ENDDO
          yr = y-yc
          rr(i) = yr
          IF (in(i).ne.0) THEN
            chisq = chisq + yr*yr
          ENDIF
          WRITE (1,9002) id(i),x,y,yc,yr,in(i)
        ENDDO
        CLOSE (1)
c
c...Errors
c
        sigma = SQRT(chisq/(nin-(nc+1)))
        DO i=1,nc
          sc(i) = sigma*SQRT(zrhs(i,i))
        ENDDO
        DO i=1,nn
          rr(i) = ABS(rr(i)/sigma)
        ENDDO
c
c...End Of Iteration
c
      ENDDO
c
c...Apply To All Solutions
c
      DO i=1,NMAX
        IF (bb(1,i).eq.TAG) THEN
          ff(1,i) = TAG
        ELSE
          x = bb(1,i)
          dv(1) = 1.0D00
          DO j=2,nc
            dv(j) = dv(j-1)*x
          ENDDO
          y = 0.0D00
          DO j=1,nc
            y = y + dv(j)*cc(j)
          ENDDO
          ff(1,i) = y
          ff(4,i) = sigma
        ENDIF
      ENDDO
c
c...Save
c
      WRITE (2,9003) nin,sigma,nn
      DO i=1,nc
        WRITE (2,9004) i,cc(i),sc(i)
      ENDDO
      RETURN
      END
