      SUBROUTINE  apply(z,n)
c
c...Apply Photometric Calibration
c
      INCLUDE
     *            'ugapf.inc'
      PARAMETER
     *            bright = 1,
     *            faint = 249
      INTEGER
     *            n, i, jj, sgn, bad, field, blue, red, z, jd
      DOUBLE PRECISION
     *            m, mb, mr
c
c...Outer Loop Starts With Cracking
c
  100 DO i=1,n
        jj = cat(3,i)
        IF (jj.lt.0) THEN
          sgn = -1
          jj = -jj
        ELSE
          sgn = 1
        ENDIF
        bad = jj/BILLION
        jj = jj - bad*BILLION
        field = jj/MILLION
        IF (field.gt.0) THEN
          jj = jj - field*MILLION
          blue = jj/THOUSAND
          red = jj - blue*THOUSAND
          IF ((z.le.10).and.(field.le.606)) THEN
            jd = plpack(field+1000)
          ELSE
            jd = plpack(field)
          ENDIF
c
c...Apply Each Calibration
c
          IF ((blue.ge.BRIGHT).and.(blue.le.FAINT)) THEN
            m = 0.1D00*blue
            IF (m.lt.bxform(1,jd)) THEN
              mb = bxform(3,jd) + m*bxform(4,jd)
            ELSE
              mb = bxform(5,jd) + m*bxform(6,jd) + m*m*bxform(7,jd)
            ENDIF
            jj = mb*10.0D00 + 0.5D00
            blue = MAX(BRIGHT,MIN(FAINT,jj))
          ENDIF
          IF ((red.ge.BRIGHT).and.(red.le.FAINT)) THEN
            m = 0.1D00*red
            IF (m.lt.rxform(1,jd)) THEN
              mr = rxform(3,jd) + m*rxform(4,jd)
            ELSE
              mr = rxform(5,jd) + m*rxform(6,jd) + m*m*rxform(7,jd)
            ENDIF
            jj = mr*10.0D00 + 0.5D00
            red = MAX(BRIGHT,MIN(FAINT,jj))
          ENDIF
c
c...Repack
c
          cat(3,i) = sgn*(bad*BILLION
     *                  + field*MILLION
     *                  + blue*THOUSAND
     *                  + red)
        ENDIF
      ENDDO
      RETURN
      END
