      SUBROUTINE  getact
c
c...Get And Parse The Needed ACT Entries.  Code should look a lot like
c	actgen/act.f
c
      INCLUDE
     *            'ugap3.inc'
      PARAMETER
     *            nhist = 15
      INTEGER
     *            nraw, nlb, m, tid1, tid2, j, thist(NHIST),
     *            inhist(NHIST), outhist(NHIST)
      CHARACTER*512
     *            lb
      CHARACTER*1
     *            s
      DOUBLE PRECISION
     *            x, y, z, dra, ddec, pmra, pmdec, mbt, mvt, mkeep,
     *            pin, pout
c
 9001 FORMAT (q, a)
 9002 FORMAT (f2.0, 1x, f2.0, 1x, f7.0)
 9003 FORMAT (a, f2.0, 1x, f2.0, 1x, f6.0)
 9004 FORMAT (f7.0)
 9005 FORMAT (f6.0)
 9006 FORMAT (i10, ' Stars Loaded From ACT')
 9007 FORMAT (' Cannot Open ACT Catalog')
 9008 FORMAT (i4, i8)
 9009 FORMAT (' Mag=', i2, '  Total=', i6, '  In=', i6, ' (', f5.1,
     *        ')  Out=', i6, ' (', f5.1, ')')
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='/uw13/xpmm/ugap3/pmtycho.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nraw = 0
      DO j=1,NHIST
        thist(j) = 0
        inhist(j) = 0
        outhist(j) = 0
      ENDDO
c
c...Process All Entries
c
  110 READ (1,9001,end=120) nlb,lb
      nraw = nraw+1
      READ (lb(69:74),9005) mbt
      READ (lb(76:81),9005) mvt
      IF ((mvt.ne.0.0D00).and.(mvt.lt.15.0D00)) THEN
        mkeep = mvt
      ELSE
        mkeep = mbt
      ENDIF
      m = mkeep
      m = MAX(1,MIN(NHIST,m))
      thist(m) = thist(m)+1
      IF (actid(nraw).ne.0) THEN
        inhist(m) = inhist(m)+1
      ELSE
        outhist(m) = outhist(m)+1
        READ (lb(1:13),9002) x,y,z
        dra = 15.0D00*(x + y/60.0D00 + z/3600.0D00)
        READ (lb(15:27),9003) s,x,y,z
        ddec = x + y/60.0D00 + z/3600.0D00
        IF (s.eq.'-') THEN
          ddec = -ddec
        ENDIF
        READ (lb(29:35),9004) pmra
        READ (lb(37:43),9004) pmdec
        nn = nn+1
        buf(1,nn) = dra*DEGREE
        buf(2,nn) = (ddec+90.0D00)*DEGREE
        m = mkeep*10.0D00 + 0.5D00
        m = MAX(1,MIN(999,m))
        buf(3,nn) = -m
        DO j=96,107
          IF (lb(j:j).eq.' ') THEN
            lb(j:j) = '0'
          ENDIF
        ENDDO
        READ (lb(96:107),9008) tid1,tid2
        buf(4,nn) = tid1
        buf(5,nn) = tid2
      ENDIF
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9006) nn
      WRITE (9,9006) nn
c
c...Tell The User
c
      DO j=1,NHIST
        IF (thist(j).gt.0) THEN
          x = inhist(j)
          y = outhist(j)
          z = thist(j)
          pin = 100.0D00*x/z
          pout = 100.0D00*y/z
          WRITE (*,9009) j,thist(j),inhist(j),pin,outhist(j),pout
          WRITE (9,9009) j,thist(j),inhist(j),pin,outhist(j),pout
        ENDIF
      ENDDO
      RETURN
c
c...Big Problem
c
  200 WRITE (*,9007)
      CALL EXIT
      END
