      SUBROUTINE  gettyc
c
c...Read The Missing-From-ACT File Of TYCHO Stars
c
      INCLUDE
     *            'ugap3.inc'
      INTEGER
     *            nraw, tid1, tid2, nlb, m, j
      CHARACTER*512
     *            lb
      DOUBLE PRECISION
     *         dra, ddec, pmra, pmdec, mbt, mvt, mkeep
c
 9001 FORMAT (q, a)
 9002 FORMAT (i10, 1x, a)
 9003 FORMAT (f12.9)
 9004 FORMAT (f6.3)
 9006 FORMAT (i10, ' Stars Loaded From TYC')
 9007 FORMAT (' Cannot Open XTYCHO.CAT')
 9008 FORMAT (i4, i8)
c
c...Initialization
c
  100 OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      err=200,
     *      form='formatted',
     *      name='/uw13/xpmm/ugap3/xtycho.cat',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      nraw = 0
c
c...Process All Entries
c
  110 READ (1,9001,end=120) nlb,lb
      nraw = nraw+1
      READ (lb( 52: 63),9003) dra
      READ (lb( 65: 76),9003) ddec
      READ (lb(218:223),9004) mbt
      READ (lb(231:236),9004) mvt
      IF ((mvt.ne.0.0D00).and.(mvt.lt.15.0D00)) THEN
        mkeep = mvt
      ELSE
        mkeep = mbt
      ENDIF
      nn = nn+1
      buf(1,nn) = dra*DEGREE
      buf(2,nn) = (ddec+90.0D00)*DEGREE
      m = mkeep*10.0D00 + 0.5D00
      m = MAX(1,MIN(999,m))
      buf(3,nn) = -(BILLION + m)
      DO j=3,14
        IF (lb(j:j).eq.' ') THEN
          lb(j:j) = '0'
        ENDIF
      ENDDO
      READ (lb(3:14),9008) tid1,tid2
      buf(4,nn) = tid1
      buf(5,nn) = tid2
      GO TO 110
  120 CLOSE (1)
      WRITE (*,9006) nraw
      WRITE (9,9006) nraw
      RETURN
c
c...Big Problem
c
  200 WRITE (*,9007)
      CALL EXIT
      END
