      SUBROUTINE  xynodup
c
c...Remove Duplicate Entries In Polar Fields
c
      INCLUDE
     *            'ugap5.inc'
      PARAMETER
     *            nfmax = 100
      INTEGER
     *            test, low1, high1, low2, high2, dx, dy, rsqr, q,
     *            x, y, xl, xh, yl, yh, last1, last2, p, nfind, ex, ey,
     *            ifind(NFMAX), jfind(NFMAX), er, ntag, mfind(NFMAX),
     *            i, rfind(NFMAX), dfind(NFMAX)
c
 9001 FORMAT (' XYNODUP Removed ', i12)
c
c...Initializations
c
  100 test = s1frst(1)-1
      low1 = 1
      high1 = 1
      last1 = s1last(1)
      low2 = 1
      high2 = 1
      last2 = s2last(1)
      dx = radius*MICRON + 0.5
      dy = radius*MICRON + 0.5
      rsqr = dy*dy
      ntag = 0
c
c...Outer Loop Over Tested Star
c
  110 test = test+1
      IF (test.gt.last1) GO TO 200
      IF (z1(1,test).eq.TAG) GO TO 110
      x = z1(1,test)
      y = z1(2,test)
      xl = x-dx
      xh = x+dx
      yl = y-dy
      yh = y+dy
c
c...Look For LOW Limit
c
  120 q = z1(1,low1)
      IF (q.ne.TAG) THEN
        IF (q.ge.xl) GO TO 130
      ENDIF
      low1 = low1+1
      IF (low1.le.last1) GO TO 120
  130 q = z2(1,low2)
      IF (q.ne.TAG) THEN
        IF (q.ge.xl) GO TO 140
      ENDIF
      low2 = low2+1
      IF (low2.le.last2) GO TO 130
  140 CONTINUE
c
c...Look For HIGH Limit
c
      IF (low1.le.last1) THEN
        high1 = MAX(high1,low1)
        DO p=high1+1,last1
          q = z1(1,p)
          IF (q.ne.TAG) THEN
            IF (q.le.xh) THEN
              high1 = p
            ELSE
              GO TO 150
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  150 IF (low2.le.last2) THEN
        high2 = MAX(high2,low2)
        DO p=high2+1,last2
          q = z2(1,p)
          IF (q.ne.TAG) THEN
            IF (q.le.xh) THEN
              high2 = p
            ELSE
              GO TO 160
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  160 CONTINUE
c
c...Range From LOW to HIGH Needs To Be Examined
c
      nfind = 0
      IF (low1.le.last1) THEN
        nfind = 1
        ifind(nfind) = test
        jfind(nfind) = 1
        rfind(nfind) = z1(1,test)
        dfind(nfind) = z1(2,test)
        mfind(nfind) = z1(3,test)
        DO p=low1,high1
          IF (p.ne.test) THEN
            IF (z1(1,p).ne.TAG) THEN
              ex = ABS(z1(1,p)-x)
              ey = ABS(z1(2,p)-y)
              IF ((ex.le.dx).and.(ey.le.dy)) THEN
                er = ex*ex + ey*ey
                IF (er.le.rsqr) THEN
                  nfind = nfind+1
                  ifind(nfind) = p
                  jfind(nfind) = 1
                  rfind(nfind) = z1(1,p)
                  dfind(nfind) = z1(2,p)
                  mfind(nfind) = z1(3,p)
                  IF (nfind.ge.NFMAX) GO TO 170
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  170 IF (low2.le.last2) THEN
        DO p=low2,high2
          IF (z2(1,p).ne.TAG) THEN
            ex = ABS(z2(1,p)-x)
            ey = ABS(z2(2,p)-y)
            IF ((ex.le.dx).and.(ey.le.dy)) THEN
              er = ex*ex + ey*ey
              IF (er.le.rsqr) THEN
                nfind = nfind+1
                ifind(nfind) = p
                jfind(nfind) = 2
                rfind(nfind) = z2(1,p)
                dfind(nfind) = z2(2,p)
                mfind(nfind) = z2(3,p)
                IF (nfind.ge.NFMAX) GO TO 180
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
  180 CONTINUE
c
c...Put Selection Logic Somewhere Else
c
      IF (nfind.gt.1) THEN
        CALL xyselect(nfind,ifind,jfind,rfind,dfind,mfind)
        ntag = ntag + (nfind-1)
      ENDIF
      GO TO 110
c
c...All Done
c
  200 WRITE (*,9001) ntag
      WRITE (2,9001) ntag
      RETURN
      END
