      PROGRAM  countact
c
c...Count ACT Stars In Each Field
c
      IMPLICIT
     *         NONE
      PARAMETER
     *         nmax = 1500,
     *         nzone = 72,
     *         billion = 1000*1000*1000,
     *         million = 1000*1000,
     *         chunk = 1*million
      INTEGER
     *         total(NMAX), good(NMAX), nlb, z, j, bad, f, m, err,
     *         C_GENLEN, C_READER, buf(5,CHUNK), nmost, nlast, nper,
     *         i, n, fd, nchunk, C_ROOPEN, newz0(4,NMAX)
      CHARACTER*64
     *         lb
      BYTE
     *         bb(65)
c
 9001 FORMAT (q, a)
 9002 FORMAT (7i11)
 9003 FORMAT (i4, i8)
c
c...Initialization
c
  100 DO i=1,NMAX
        total(i) = 0
        good(i) = 0
        DO j=1,NZONE
          newz0(j,i) = 0
        ENDDO
      ENDDO
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../proc3/ugap4.toc',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
c
c...Load NEWZ0 Results
c
      DO j=1,4
        IF (j.eq.1) THEN
          lb = '../newz0/realtaffso.raw'
          nlb = 23
          m = 0
        ELSEIF (j.eq.2) THEN
          lb = '../newz0/realtaffsb.raw'
          nlb = 23
          m = 1000
        ELSEIF (j.eq.3) THEN
          lb = '../newz0/realtaffse.raw'
          nlb = 23
          m = 0
        ELSE
          lb = '../newz0/realtaffsr.raw'
          nlb = 23
          m = 1000
        ENDIF
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=2
     *       )
  110   READ (2,9003,end=120) i,f
        i = i+m
        IF ((i.ge.1).and.(i.le.NMAX)) THEN
          newz0(j,i) = f
        ENDIF
        GO TO 110
  120   CLOSE (2)
      ENDDO
c
c...Outer Loop Over Rings
c
      DO z=1,NZONE
        READ (1,9001) nlb,lb
        lb(nlb-2:nlb) = 'cat'
      write (*,9991) lb(1:nlb)
 9991 format (' Working On ', a)
        DO j=1,nlb
          bb(j) = ICHAR(lb(j:j))
        ENDDO
        bb(nlb+1) = 0
        n = C_GENLEN(bb)/20
        nchunk = (n-1)/CHUNK + 1
        nmost = CHUNK
        nlast = n - (nchunk-1)*nmost
        fd = C_ROOPEN(bb)
c
c...Inner Loop Over Chunks
c
        DO j=1,nchunk
          IF (j.eq.nchunk) THEN
            nper = nlast
          ELSE
            nper = nmost
          ENDIF
          err = C_READER(fd,buf,20*nper)
          DO i=1,nper
            m = buf(3,i)
            IF (m.lt.0) THEN
              m = -m
              bad = m/BILLION
              m = m - bad*BILLION
              f = m/MILLION
              IF (f.gt.0) THEN
                IF ((z.le.30).and.(f.le.408)) THEN
                  f = f+1000
                ENDIF
                total(f) = total(f)+1
                IF (bad.eq.0) THEN
                  good(f) = good(f)+1
                ENDIF
              ENDIF
            ENDIF
          ENDDO
c
c...All Done
c
        ENDDO
        CALL c_closer(fd)
      ENDDO
      CLOSE (1)
c
c...Report Results
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='countact.out',
     *      status='unknown',
     *      unit=1
     *     )
      DO i=1,NMAX
        IF (total(i).gt.0) THEN
          IF (i.le.1000) THEN
            j = MIN(newz0(1,i),newz0(3,i))
            m = j-total(i)
            WRITE (1,9002) i,newz0(1,i),newz0(3,i),total(i),good(i),m
          ELSE
            j = MIN(newz0(2,i),newz0(4,i))
            m = j-total(i)
            WRITE (1,9002) i,newz0(2,i),newz0(4,i),total(i),good(i),m
          ENDIF
        ENDIF
      ENDDO
      CLOSE (1)
      CALL EXIT
      END
