      SUBROUTINE  sumit(r1,r2,dz,d1,d2,r0,d0,sc,nx,ny,im)
c
c...Ingest ACC And Loop Over DAT
c
      INCLUDE
     *            'square.inc'
      INTEGER
     *            dz, i, i1, i2, fr, nr, C_ROOPEN, fd, nlb, err,
     *            C_POSITION, n, nmost, nlast, ir1, ir2, id1, id2,
     *            C_CLOSER, C_READER, m, j, nx, ny, im(nx,ny), ix, iy
      DOUBLE PRECISION
     *            r1, r2, d1, d2, sc, radian, r0, d0, radr0, radd0,
     *            r, d, xi, eta
      CHARACTER*64
     *            lb
      BYTE
     *            bb(65)
c
 9002 FORMAT (5x, 2i12)
 9003 FORMAT (' Cannot Open ', a)
 9004 FORMAT (' Fatal Error Accessing ', a)
 9005 FORMAT (' Too Many Stars - Quitting Early')
 9006 FORMAT (' Z=', i4, ' RA(', i9, ':', i9, ')  SPD(', i9, ':',
     *        i9, ')')
 9007 FORMAT (' Fatal SLALIB Error', i12)
c
c...Eat The ACC File
c
  100 IF (dz.ne.oldzone) THEN
        j = dz/75 + 1
        lb = zfn(j)
        nlb = nzfn(j)
        lb(nlb-2:nlb) = 'acc'
        OPEN (
     *        access='sequential',
     *        carriagecontrol='list',
     *        dispose='keep',
     *        err=200,
     *        form='formatted',
     *        name=lb(1:nlb),
     *        readonly,
     *        shared,
     *        status='old',
     *        unit=1
     *       )
        DO i=1,NACC
          READ (1,9002) frec(i),nrec(i)
        ENDDO
        CLOSE (1)
        oldzone = dz
      ENDIF
c
c...Compute Offset And Length
c
      i1 = r1/3.75D00
      i1 = MAX(1,MIN(NACC,i1+1))
      i2 = r2/3.75D00
      i2 = MAX(1,MIN(NACC,i2+1))
      fr = frec(i1)-1
      nr = 0
      DO i=i1,i2
        nr = nr+nrec(i)
      ENDDO
c
c...Open And Position File
c
      lb(nlb-2:nlb) = 'cat'
      DO i=1,nlb
        bb(i) = ICHAR(lb(i:i))
      ENDDO
      bb(nlb+1) = 0
      fd = C_ROOPEN(bb)
      IF (fd.lt.3) THEN
        WRITE (*,9003) lb(1:nlb)
        CALL EXIT(0)
      ENDIF
      IF (fr.gt.0) THEN
        err = C_POSITION(fd,12*fr)
        IF (err.le.0) THEN
          WRITE (*,9004) lb(1:nlb)
          CALL EXIT(0)
        ENDIF
      ENDIF
c
c...Set Up Search Parameters
c
      n = ((nr-1)/NCHUNK) + 1
      IF (n.gt.1) THEN
        nmost = NCHUNK
        nlast = nr - (n-1)*NCHUNK
      ELSE
        nmost = 0
        nlast = nr
      ENDIF
      ir1 = CONVERT*r1
      ir2 = CONVERT*r2
      id1 = CONVERT*(d1+90.0D00)
      id2 = CONVERT*(d2+90.0D00)
      WRITE (*,9006) oldzone,ir1,ir2,id1,id2
c
c...Set Up The Summation Parameters
c
      radian = 45.0D00/ATAN(1.0D00)
      scale = (nx/2)/(sc/radian)
      radr0 = 15.0D00*r0/radian
      radd0 = d0/radian
c
c...Do The Search
c
      DO i=1,n
        IF (i.eq.n) THEN
          m = nlast
        ELSE
          m = nmost
        ENDIF
        err = C_READER(fd,buf,12*m)
        IF (err.ne.0) THEN
          WRITE (*,9004) lb(1:nlb)
          CALL EXIT(0)
        ENDIF
        DO j=1,m
          IF (buf(1,j).ge.ir1) THEN
            IF (buf(1,j).le.ir2) THEN
              IF ((buf(2,j).ge.id1).and.(buf(2,j).le.id2)) THEN
                r = buf(1,j)/(CONVERT*radian)
                d = ((buf(2,j)/CONVERT)-90.0D00)/radian
                CALL sla_DS2TP(r,d,radr0,radd0,xi,eta,err)
                IF (err.ne.0) GO TO 210
                ix = (nx/2) + xi*scale
                iy = (ny/2) + eta*scale
                IF  ((ix.ge.1).and.(ix.le.nx)
     *          .and.(iy.ge.1).and.(iy.le.ny)) THEN
                  ix = (nx+1)-ix
                  im(ix,iy) = im(ix,iy)+1
                  nsav = nsav+1
                ENDIF
              ENDIF
            ELSE
              GO TO 110
            ENDIF
          ENDIF
        ENDDO
        fr = fr+m
      ENDDO
c
c...All Done
c
  110 err = C_CLOSER(fd)
      RETURN
c
c...You Better Not Get Here
c
  200 WRITE (*,9003) lb(1:nlb)
      CALL EXIT(0)
  210 WRITE (*,9007) err
      CALL EXIT(0)
      END
