      SUBROUTINE  dofit1(cc,ss,sg, err)
c
c...Least Squares Fit
c
      INCLUDE
     *            'ugapc2.inc'
      INTEGER
     *            i, j, k, ising, nin, nfree, err
      DOUBLE PRECISION
     *            chisq, yc, yr, cc(*), ss(*), sg, w
c
c...Initialization
c
  100 DO i=1,nc
        cc(i) = 0.0D00
        zlhs(i) = 0.D00
        DO j=1,nc
          zrhs(i,j) = 0.0D00
        ENDDO
      ENDDO
      chisq = 0.0D00
      nin = 0
c
c...Accumulation
c
      DO i=1,mm
        IF (i.eq.1) THEN
          w = 5.0D00
        ELSE
          w = 1.0D00
        ENDIF
        IF (kfit(i).ne.0) THEN
          CALL gimmedv(xfit(i))
          DO j=1,nc
            zlhs(j) = zlhs(j) + dv(j)*yfit(i)*w
            DO k=1,nc
              zrhs(j,k) = zrhs(j,k) + dv(j)*dv(k)*w
            ENDDO
          ENDDO
          nin = nin+1
        ENDIF
      ENDDO
c
c...Inversion
c
      nfree = nin - (nc+1)
      IF (nfree.le.0) THEN
        err = -1
        RETURN
      ENDIF
      CALL inv1(ising)
      IF (ising.ne.0) THEN
        err = -2
        RETURN
      ENDIF
c
c...Coefficients
c
      DO i=1,nc
        DO j=1,nc
          cc(i) = cc(i) + zrhs(i,j)*zlhs(j)
        ENDDO
      ENDDO
c
c...Residuals And ChiSquared
c
      DO i=1,mm
        IF (i.eq.1) THEN
          w = 5.0D00
        ELSE
          w = 1.0D00
        ENDIF
        CALL gimmedv(xfit(i))
        yc = 0.0D00
        DO j=1,nc
          yc = yc + dv(j)*cc(j)
        ENDDO
        yr = yfit(i)-yc
        re(i) = yr
        IF (kfit(i).ne.0) THEN
          chisq = chisq + yr*yr*w
        ENDIF
      ENDDO
c
c...Errors
c
      sg = SQRT(chisq/nfree)
      DO i=1,nc
        ss(i) = sg*SQRT(zrhs(i,i))
      ENDDO
      err = 0
      RETURN
      END
