      SUBROUTINE  getquad
c
c...Load Linear And Quadratic Coefficients From USNO Photometry
c
      INCLUDE
     *            'ugapcs0.inc'
      INTEGER
     *            i
      DOUBLE PRECISION
     *            x, y, z
c
 9001 FORMAT (3x, 3f10.0, i5)
c
c...Initialization
c
  100 DO i=1,NFMAX
        usnoid(i,1) = 0
        usnoid(i,2) = 0
      ENDDO
c
c...Get Blue
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../proc8/ugapc3b.fit',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      READ (1,9001)
      READ (1,9001) jcoef(nplate+1),sjcoef(nplate+1)
      READ (1,9001) jcoef(nplate+2),sjcoef(nplate+1)
  110 READ (1,9001,end=120) x,y,z,i
      IF (i.gt.2000) THEN
        i = i-2000
        usnoid(i,1) = 1
        usno(i,1) = x
        usno(i,2) = y
      ENDIF
      GO TO 110
  120 CLOSE (1)
c
c...Get Red
c
      OPEN (
     *      access='sequential',
     *      carriagecontrol='list',
     *      dispose='keep',
     *      form='formatted',
     *      name='../proc8/ugapc3r.fit',
     *      readonly,
     *      shared,
     *      status='old',
     *      unit=1
     *     )
      READ (1,9001)
      READ (1,9001)
      READ (1,9001) fcoef(nplate+1),sfcoef(nplate+1)
      READ (1,9001) fcoef(nplate+2),sfcoef(nplate+1)
  130 READ (1,9001,end=140) x,y,z,i
      IF (i.gt.2000) THEN
        i = i-2000
        usnoid(i,2) = 1
        usno(i,3) = x
        usno(i,4) = y
      ENDIF
      GO TO 130
  140 CLOSE (1)
      ncoef = nplate+2
      RETURN
      END
